/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.action;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.security.Securities$;
import org.beangle.web.action.view.View;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.ProjectBased;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.ExamStatus$;
import org.openurp.code.edu.model.ExamType$;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.course.model.ExamAnalysis;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.edu.grade.config.GradeInputSwitch;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.CourseGradeState;
import org.openurp.edu.grade.model.ExamGradeState;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.grade.model.GradeState;
import org.openurp.edu.grade.service.ClazzGradeService;
import org.openurp.edu.grade.service.CourseGradeCalculator;
import org.openurp.edu.grade.service.CourseGradeSetting;
import org.openurp.edu.grade.service.CourseGradeSettings;
import org.openurp.edu.grade.service.GradeInputSwitchService;
import org.openurp.edu.grade.service.GradeRateService;
import org.openurp.edu.grade.service.GradeTypePolicy;
import org.openurp.edu.grade.service.MakeupStdStrategy;
import org.openurp.edu.grade.service.stat.GradeSegStat$;
import org.openurp.edu.service.Features;
import org.openurp.edu.teaching.web.helper.ClazzGradeReport;
import org.openurp.edu.teaching.web.helper.ClazzGradeReport$;
import org.openurp.edu.teaching.web.helper.GradeInputHelper;
import org.openurp.starter.web.support.TeacherSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class GradeAction
extends TeacherSupport {
    private CourseGradeSettings settings;
    private GradeInputSwitchService gradeInputSwitchService;
    private ClazzGradeService clazzGradeService;
    private ClazzProvider clazzProvider;
    private GradeRateService gradeRateService;
    private CourseGradeCalculator calculator;
    private GradeTypePolicy gradeTypePolicy;
    private WebBusinessLogger businessLogger;
    private MakeupStdStrategy makeupStdStrategy;

    public CourseGradeSettings settings() {
        return this.settings;
    }

    public void settings_$eq(CourseGradeSettings x$1) {
        this.settings = x$1;
    }

    public GradeInputSwitchService gradeInputSwitchService() {
        return this.gradeInputSwitchService;
    }

    public void gradeInputSwitchService_$eq(GradeInputSwitchService x$1) {
        this.gradeInputSwitchService = x$1;
    }

    public ClazzGradeService clazzGradeService() {
        return this.clazzGradeService;
    }

    public void clazzGradeService_$eq(ClazzGradeService x$1) {
        this.clazzGradeService = x$1;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public GradeRateService gradeRateService() {
        return this.gradeRateService;
    }

    public void gradeRateService_$eq(GradeRateService x$1) {
        this.gradeRateService = x$1;
    }

    public CourseGradeCalculator calculator() {
        return this.calculator;
    }

    public void calculator_$eq(CourseGradeCalculator x$1) {
        this.calculator = x$1;
    }

    public GradeTypePolicy gradeTypePolicy() {
        return this.gradeTypePolicy;
    }

    public void gradeTypePolicy_$eq(GradeTypePolicy x$1) {
        this.gradeTypePolicy = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public MakeupStdStrategy makeupStdStrategy() {
        return this.makeupStdStrategy;
    }

    public void makeupStdStrategy_$eq(MakeupStdStrategy x$1) {
        this.makeupStdStrategy = x$1;
    }

    public View projectIndex(Teacher teacher, Project project) {
        Semester semester = this.getSemester();
        this.put("semester", semester);
        scala.collection.immutable.Seq clazzes = this.clazzProvider().getClazzes(semester, teacher, project);
        this.put("clazzes", clazzes);
        Map gradeStates = Collections$.MODULE$.newMap();
        clazzes.foreach((Function1)(JProcedure1 & Serializable)clazz -> {
            CourseGradeState state = this.clazzGradeService().getState(clazz);
            if (state != null) {
                gradeStates.put(clazz, (Object)state);
                return;
            }
        });
        this.put("makeupTakerCounts", this.makeupStdStrategy().getCourseTakerCounts(clazzes));
        this.put("gradeStates", gradeStates);
        this.put("gradeInputSwitch", this.getGradeInputSwitch(project, semester));
        this.put("EndGa", this.codeService().get(GradeType.class, GradeType$.MODULE$.EndGa()));
        this.put("MakeupGa", this.codeService().get(GradeType.class, GradeType$.MODULE$.MakeupGa()));
        this.put("DelayGa", this.codeService().get(GradeType.class, GradeType$.MODULE$.DelayGa()));
        return this.forward(this.forward$default$1());
    }

    public View statePanel() {
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        Project project = clazz.project();
        GradeInputSwitch gradeInputSwitch = this.getGradeInputSwitch(project, clazz.semester());
        this.put("gradeInputSwitch", gradeInputSwitch);
        CourseGradeState state = this.clazzGradeService().getState(clazz);
        if (state == null) {
            state = new CourseGradeState();
        }
        this.put("gradeState", state);
        this.putGradeConsts();
        this.put("makeupTakerCounts", this.makeupStdStrategy().getCourseTakerCounts((scala.collection.immutable.Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Clazz[]{clazz}))));
        this.put("clazz", clazz);
        return this.forward(this.forward$default$1());
    }

    public View info() {
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, this.getLong("clazzId").get());
        scala.collection.immutable.Seq grades = this.entityDao().findBy(CourseGrade.class, "clazz", (Object)clazz);
        Set examGradeTypes = Collections$.MODULE$.newSet();
        grades.foreach((Function1)(JProcedure1 & Serializable)g -> g.examGrades().foreach((Function1 & Serializable)eg -> (Set)examGradeTypes.addOne((Object)eg.gradeType())));
        Buffer gradeTypes = (Buffer)examGradeTypes.toBuffer().sortBy((Function1 & Serializable)_$10 -> _$10.code(), (Ordering)Ordering.String$.MODULE$);
        gradeTypes.addOne((Object)this.getCode(GradeType.class, GradeType$.MODULE$.EndGa()));
        this.put("gradeTypes", gradeTypes);
        CourseGradeState state = this.clazzGradeService().getState(clazz);
        this.put("gradeState", state);
        scala.collection.immutable.Map gradeMap = ((IterableOnceOps)grades.map((Function1 & Serializable)g -> Tuple2$.MODULE$.apply((Object)g.std(), g))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("clazz", clazz);
        this.put("grades", grades);
        this.put("gradeMap", gradeMap);
        this.put("EndGa", this.getCode(GradeType.class, GradeType$.MODULE$.EndGa()));
        return this.forward(this.forward$default$1());
    }

    public View clazz() {
        Teacher teacher;
        LazyRef lazyRef = new LazyRef();
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, this.getLong("clazzId").get());
        String msg = this.checkOwnerPermission(clazz, teacher = this.getTeacher());
        if (msg != null) {
            return this.forward("500", msg);
        }
        GradeInputSwitch gradeInputSwitch = this.getGradeInputSwitch(GradeAction.project$1(lazyRef, clazz), clazz.semester());
        this.put("gradeInputSwitch", gradeInputSwitch);
        Buffer gaGradeTypes = Collections$.MODULE$.newBuffer();
        CourseGradeSetting setting = this.settings().getSetting(clazz.project());
        setting.gaElementTypes().foreach((Function1)(JProcedure1 & Serializable)gradeType -> {
            GradeType gt = (GradeType)this.getCode(GradeType.class, BoxesRunTime.unboxToInt((Object)gradeType.id()));
            if (gradeInputSwitch.types().contains((Object)gt)) {
                gaGradeTypes.addOne((Object)gt);
                return;
            }
        });
        List gradeTypes = ((IterableOnceOps)gaGradeTypes.sortBy((Function1 & Serializable)_$11 -> _$11.code(), (Ordering)Ordering.String$.MODULE$)).toList();
        this.put("gradeTypes", gradeTypes);
        this.put("gaGradeTypes", gradeTypes);
        CourseGradeState state = this.clazzGradeService().getOrCreateState(clazz, (Iterable)gradeTypes, (Option)None$.MODULE$, (Option)None$.MODULE$);
        if (setting.gaElementTypes().size() == 1) {
            ((ExamGradeState)state.getState((GradeType)setting.gaElementTypes().head())).scorePercent_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)100)));
        }
        this.put("gradeState", state);
        this.putGradeConsts();
        this.put("gradingModes", this.gradeRateService().getGradingModes(clazz.project()));
        scala.collection.immutable.Seq grades = this.entityDao().findBy(CourseGrade.class, "clazz", (Object)clazz);
        scala.collection.immutable.Map gradeMap = ((IterableOnceOps)grades.map((Function1 & Serializable)g -> Tuple2$.MODULE$.apply((Object)g.std(), g))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("clazz", clazz);
        this.put("gradeMap", gradeMap);
        return this.forward(this.forward$default$1());
    }

    private void putGradeConsts() {
        this.put("Usual", this.getCode(GradeType.class, GradeType$.MODULE$.Usual()));
        this.put("End", this.getCode(GradeType.class, GradeType$.MODULE$.End()));
        this.put("Delay", this.getCode(GradeType.class, GradeType$.MODULE$.Delay()));
        this.put("Makeup", this.getCode(GradeType.class, GradeType$.MODULE$.Makeup()));
        this.put("EndGa", this.codeService().get(GradeType.class, GradeType$.MODULE$.EndGa()));
        this.put("MakeupGa", this.codeService().get(GradeType.class, GradeType$.MODULE$.MakeupGa()));
        this.put("DelayGa", this.codeService().get(GradeType.class, GradeType$.MODULE$.DelayGa()));
        this.put("FINAL", this.codeService().get(GradeType.class, GradeType$.MODULE$.Final()));
        this.put("ABSENT", BoxesRunTime.boxToInteger((int)ExamStatus$.MODULE$.Absent()));
        this.put("NEW", BoxesRunTime.boxToInteger((int)Grade.Status$.MODULE$.New()));
        this.put("CONFIRMED", BoxesRunTime.boxToInteger((int)Grade.Status$.MODULE$.Confirmed()));
        this.put("NormalTakeType", this.getCode(CourseTakeType.class, CourseTakeType$.MODULE$.Normal()));
        this.put("NormalExamStatus", this.getCode(ExamStatus.class, ExamStatus$.MODULE$.Normal()));
    }

    public View inputGa() {
        LazyRef lazyRef = new LazyRef();
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        Teacher teacher = this.getTeacher();
        List gradeTypes = this.codeService().get(GradeType.class, Strings$.MODULE$.splitToInt((String)this.get("gradeTypeIds", ""))).toList();
        Option gradingMode = this.getInt("gradingModeId").map((Function1 & Serializable)x -> this.$anonfun$5(BoxesRunTime.unboxToInt((Object)x)));
        CourseGradeState gradeState = this.clazzGradeService().getOrCreateState(clazz, (Iterable)gradeTypes, this.getInt("precision"), gradingMode);
        View check = this.checkEndGaPermission(clazz, teacher, gradeState);
        if (check != null) {
            return check;
        }
        CourseGradeSetting setting = this.settings().getSetting(clazz.project());
        GradeInputHelper helper = new GradeInputHelper(this.entityDao(), this.calculator(), this.clazzGradeService());
        boolean updatePercent = helper.populatePercent(gradeState, (Iterable<GradeType>)gradeTypes);
        gradeTypes = this.clazzGradeService().cleanZeroPercents(gradeState, (Iterable)gradeTypes);
        this.put("gradeTypes", gradeTypes);
        if (updatePercent) {
            this.clazzGradeService().recalculate(gradeState);
        }
        helper.putGradeMap(clazz, null);
        helper.buildGradeConfig(clazz, gradeState, (Iterable<GradeType>)gradeTypes);
        this.putGradeConsts();
        this.put("gradeRateConfigs", this.gradeRateService().getGradeItems(GradeAction.project$2(lazyRef, clazz)));
        this.put("examStatuses", this.getCodes(ExamStatus.class, GradeAction.project$2(lazyRef, clazz)));
        this.put("gradeTypePolicy", this.gradeTypePolicy());
        this.put("gradeState", gradeState);
        this.put("setting", setting);
        this.put("clazz", clazz);
        boolean inputTwiceEnabled = BoxesRunTime.unboxToBoolean((Object)this.getConfig(Features.Grade$.MODULE$.InputTwice(), GradeAction.project$2(lazyRef, clazz)));
        if (inputTwiceEnabled) {
            this.put("inputComplete", BoxesRunTime.boxToBoolean((boolean)this.clazzGradeService().isInputComplete(clazz, (Iterable)clazz.enrollment().courseTakers(), (Iterable)gradeTypes)));
        }
        this.put("inputTwiceEnabled", BoxesRunTime.boxToBoolean((boolean)inputTwiceEnabled));
        this.put("secondInput", BoxesRunTime.boxToBoolean((boolean)this.getBoolean("secondInput", false)));
        return this.forward(this.forward$default$1());
    }

    public View saveGa() {
        CourseGradeState gradeState;
        Teacher teacher;
        LazyRef lazyRef = new LazyRef();
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, this.getLong("clazzId").get());
        View check = this.checkEndGaPermission(clazz, teacher = this.getTeacher(), gradeState = this.clazzGradeService().getState(clazz));
        if (check != null) {
            return check;
        }
        boolean submit = !this.getBoolean("justSave", true);
        GradeInputHelper helper = new GradeInputHelper(this.entityDao(), this.calculator(), this.clazzGradeService());
        scala.collection.immutable.Map<Student, CourseGrade> existGradeMap = helper.getGradeMap(clazz, false);
        CourseGradeSetting setting = this.settings().getSetting(GradeAction.project$3(lazyRef, clazz));
        boolean isPublish = setting.submitIsPublish();
        if (submit) {
            existGradeMap.values().foreach((Function1)(JProcedure1 & Serializable)grade -> {
                if (!grade.published()) {
                    setting.gaElementTypes().foreach((Function1)(JProcedure1 & Serializable)gt -> grade.getExamGrade(gt).foreach((Function1 & Serializable)eg -> {
                        GradeState gradeState = gradeState.getState(gt);
                        if (gradeState == null) {
                            return grade.examGrades().$minus$eq(eg);
                        }
                        if (gradeState instanceof ExamGradeState) {
                            ExamGradeState egs = (ExamGradeState)gradeState;
                            if (BoxesRunTime.equals((Object)egs.scorePercent().getOrElse(GradeAction::saveGa$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1), (Object)BoxesRunTime.boxToInteger((int)0))) {
                                grade.examGrades().$minus$eq(eg);
                                return BoxedUnit.UNIT;
                            }
                            return BoxedUnit.UNIT;
                        }
                        throw new MatchError((Object)gradeState);
                    }));
                    return;
                }
            });
        }
        Instant updatedAt = Instant.now();
        Buffer grades = Collections$.MODULE$.newBuffer();
        int status = submit ? Grade.Status$.MODULE$.Confirmed() : Grade.Status$.MODULE$.New();
        List<CourseTaker> takers = helper.getCourseTakers(clazz);
        List gradeTypes = this.codeService().get(GradeType.class, Strings$.MODULE$.splitToInt((String)this.get("gradeTypeIds", ""))).toList();
        boolean inputTwiceEnabled = BoxesRunTime.unboxToBoolean((Object)this.getConfig(Features.Grade$.MODULE$.InputTwice(), GradeAction.project$3(lazyRef, clazz)));
        boolean beforeInputComplete = false;
        if (inputTwiceEnabled) {
            beforeInputComplete = this.clazzGradeService().isInputComplete(clazz, takers, (Iterable)gradeTypes);
        }
        takers.foreach((Function1)(JProcedure1 & Serializable)taker -> {
            CourseGrade grade = helper.build(clazz, gradeState, (Option<CourseGrade>)existGradeMap.get((Object)taker.std()), (CourseTaker)taker, (Iterable<GradeType>)gradeTypes, status, updatedAt);
            if (grade != null) {
                grades.addOne((Object)grade);
                return;
            }
        });
        String operator = Securities$.MODULE$.user();
        if (submit) {
            gradeState.updateStatus((Iterable)gradeTypes, Grade.Status$.MODULE$.Confirmed(), updatedAt, operator);
        } else {
            gradeState.updateStatus((Iterable)gradeTypes, Grade.Status$.MODULE$.New(), updatedAt, operator);
        }
        this.entityDao().saveOrUpdate((Object)grades, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{gradeState}));
        if (submit & isPublish) {
            Set publishables = (Set)Set$.MODULE$.from((IterableOnce)this.clazzGradeService().getPublishableGradeTypes(clazz.project()));
            publishables.addOne((Object)new GradeType(GradeType$.MODULE$.EndGa()));
            publishables.addOne((Object)new GradeType(GradeType$.MODULE$.Final()));
            this.clazzGradeService().publish("" + BoxesRunTime.unboxToLong((Object)clazz.id()), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])publishables.toArray(ClassTag$.MODULE$.apply(GradeType.class))), true);
        }
        StringBuilder params = new StringBuilder("&clazzId=" + clazz.id());
        params.append("&gradeTypeIds=").append(gradeTypes.map((Function1 & Serializable)_$12 -> BoxesRunTime.unboxToInt((Object)_$12.id())).mkString(","));
        String toInputGradeTypeIdStr = (String)this.get("toInputGradeType.id", "");
        if (Strings$.MODULE$.isNotEmpty((CharSequence)toInputGradeTypeIdStr)) {
            params.append("&toInputGradeType.ids=" + this.get("toInputGradeType.id"));
            scala.collection.immutable.Seq toInputGradeTypeIds = Strings$.MODULE$.splitToInt(toInputGradeTypeIdStr);
            toInputGradeTypeIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)gradeTypeId -> {
                if (gradeTypeId != GradeType$.MODULE$.EndGa()) {
                    params.append("&" + gradeTypeId + "Percent=" + this.get(gradeTypeId + "Percent", ""));
                    return;
                }
            });
        }
        if (inputTwiceEnabled) {
            boolean afterInputComplete = this.clazzGradeService().isInputComplete(clazz, takers, (Iterable)gradeTypes);
            if (!beforeInputComplete && afterInputComplete) {
                params.append("&secondInput=1");
            }
        }
        this.businessLogger().info((submit ? "\u5f55\u5165" : "\u63d0\u4ea4") + (clazz.crn() + "\u7684\u671f\u672b\u603b\u8bc4\u6210\u7ee9"), clazz.id(), (Object)Map$.MODULE$.empty());
        return this.redirect(submit ? "report" : "inputGa", params.toString(), "info.save.success");
    }

    public View removeGa() {
        CourseGradeState gradeState;
        Teacher teacher;
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        View check = this.checkEndGaPermission(clazz, teacher = this.getTeacher(), gradeState = this.clazzGradeService().getState(clazz));
        if (check != null) {
            return check;
        }
        this.clazzGradeService().remove(clazz, (GradeType)this.getCode(GradeType.class, GradeType$.MODULE$.EndGa()));
        this.businessLogger().info("\u5220\u9664\u4e86" + clazz.crn() + "\u7684\u671f\u672b\u603b\u8bc4\u6210\u7ee9", clazz.id(), (Object)Map$.MODULE$.empty());
        return this.redirect("clazz", "clazzId=" + clazz.id(), "info.remove.success");
    }

    public View revokeGa() {
        CourseGradeState gradeState;
        Teacher teacher;
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        View check = this.checkPermission(clazz, teacher = this.getTeacher(), gradeState = this.clazzGradeService().getState(clazz), GradeType$.MODULE$.EndGa(), Grade.Status$.MODULE$.Published());
        if (check != null) {
            return check;
        }
        CourseGradeSetting setting = this.settings().getSetting(clazz.project());
        setting.gaElementTypes().foreach((Function1)(JProcedure1 & Serializable)gt -> {
            GradeState s = gradeState.getState(gt);
            if (s != null) {
                s.status_$eq(Grade.Status$.MODULE$.New());
                return;
            }
        });
        gradeState.getState(new GradeType(GradeType$.MODULE$.EndGa())).status_$eq(Grade.Status$.MODULE$.New());
        this.entityDao().saveOrUpdate((Object)gradeState, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGradeState[0]));
        this.clazzGradeService().recalculate(gradeState);
        return this.redirect("clazz", "clazzId=" + clazz.id(), "\u64a4\u56de\u6210\u529f");
    }

    public View revokeMakeup() {
        CourseGradeState gradeState;
        Teacher teacher;
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        View check = this.checkPermission(clazz, teacher = this.getTeacher(), gradeState = this.clazzGradeService().getState(clazz), GradeType$.MODULE$.MakeupGa(), Grade.Status$.MODULE$.Published());
        if (check != null) {
            return check;
        }
        CourseGradeSetting setting = this.settings().getSetting(clazz.project());
        Buffer gradeTypes = Collections$.MODULE$.newBuffer();
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{GradeType$.MODULE$.Makeup(), GradeType$.MODULE$.MakeupGa(), GradeType$.MODULE$.Delay(), GradeType$.MODULE$.DelayGa()}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)gradeTypeId -> {
            GradeType gt = (GradeType)this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)gradeTypeId));
            GradeState s = gradeState.getState(gt);
            if (s != null) {
                s.status_$eq(Grade.Status$.MODULE$.New());
                return;
            }
        });
        this.entityDao().saveOrUpdate((Object)gradeState, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGradeState[0]));
        this.clazzGradeService().recalculate(gradeState);
        return this.redirect("clazz", "clazzId=" + clazz.id(), "\u64a4\u56de\u6210\u529f");
    }

    public View inputMakeup() {
        LazyRef lazyRef = new LazyRef();
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        Teacher teacher = this.getTeacher();
        CourseGradeSetting setting = this.settings().getSetting(clazz.project());
        Buffer gradeTypes = Collections$.MODULE$.newBuffer();
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{GradeType$.MODULE$.Makeup(), GradeType$.MODULE$.MakeupGa(), GradeType$.MODULE$.Delay(), GradeType$.MODULE$.DelayGa()}))).foreach((Function1 & Serializable)gradeTypeId -> this.inputMakeup$$anonfun$1(gradeTypes, BoxesRunTime.unboxToInt((Object)gradeTypeId)));
        CourseGradeState gradeState = this.clazzGradeService().getOrCreateState(clazz, (Iterable)gradeTypes, (Option)None$.MODULE$, (Option)None$.MODULE$);
        View check = this.checkPermission(clazz, teacher, gradeState, GradeType$.MODULE$.MakeupGa(), Grade.Status$.MODULE$.Published());
        if (check != null) {
            return check;
        }
        GradeInputHelper helper = new GradeInputHelper(this.entityDao(), this.calculator(), this.clazzGradeService());
        scala.collection.immutable.Seq courseTakers = this.makeupStdStrategy().getCourseTakers(clazz);
        helper.putGradeMap(clazz, (Iterable<CourseTaker>)courseTakers);
        helper.buildGradeConfig(clazz, gradeState, (Iterable<GradeType>)gradeTypes);
        this.put("gradeTypes", gradeTypes);
        this.putGradeConsts();
        Seq examStatuses = this.getCodes(ExamStatus.class, GradeAction.project$4(lazyRef, clazz));
        this.put("examStatuses", examStatuses.toBuffer().subtractAll((IterableOnce)examStatuses.filter((Function1 & Serializable)x -> x.name().contains("\u7f13\u8003"))));
        this.put("gradeTypePolicy", this.gradeTypePolicy());
        this.put("gradeState", gradeState);
        this.put("setting", setting);
        this.put("clazz", clazz);
        boolean inputTwiceEnabled = BoxesRunTime.unboxToBoolean((Object)this.getConfig(Features.Grade$.MODULE$.InputTwice(), GradeAction.project$4(lazyRef, clazz)));
        if (inputTwiceEnabled) {
            this.put("inputComplete", BoxesRunTime.boxToBoolean((boolean)this.clazzGradeService().isInputComplete(clazz, (Iterable)courseTakers, (Iterable)gradeTypes)));
        }
        this.put("inputTwiceEnabled", BoxesRunTime.boxToBoolean((boolean)inputTwiceEnabled));
        this.put("secondInput", BoxesRunTime.boxToBoolean((boolean)this.getBoolean("secondInput", false)));
        return this.forward(this.forward$default$1());
    }

    public View saveMakeup() {
        CourseGradeState gradeState;
        Teacher teacher;
        LazyRef lazyRef = new LazyRef();
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, this.getLong("clazzId").get());
        View check = this.checkMakeupGaPermission(clazz, teacher = this.getTeacher(), gradeState = this.clazzGradeService().getState(clazz));
        if (check != null) {
            return check;
        }
        boolean submit = !this.getBoolean("justSave", true);
        GradeInputHelper helper = new GradeInputHelper(this.entityDao(), this.calculator(), this.clazzGradeService());
        scala.collection.immutable.Map<Student, CourseGrade> existGradeMap = helper.getGradeMap(clazz, false);
        CourseGradeSetting setting = this.settings().getSetting(GradeAction.project$5(lazyRef, clazz));
        boolean isPublish = setting.submitIsPublish();
        Instant updatedAt = Instant.now();
        Buffer grades = Collections$.MODULE$.newBuffer();
        int status = submit ? Grade.Status$.MODULE$.Confirmed() : Grade.Status$.MODULE$.New();
        scala.collection.immutable.Seq takers = this.makeupStdStrategy().getCourseTakers(clazz);
        Buffer gradeTypes = Collections$.MODULE$.newBuffer();
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{GradeType$.MODULE$.Makeup(), GradeType$.MODULE$.MakeupGa(), GradeType$.MODULE$.Delay(), GradeType$.MODULE$.DelayGa()}))).foreach((Function1 & Serializable)gradeTypeId -> this.saveMakeup$$anonfun$1(gradeTypes, BoxesRunTime.unboxToInt((Object)gradeTypeId)));
        boolean inputTwiceEnabled = BoxesRunTime.unboxToBoolean((Object)this.getConfig(Features.Grade$.MODULE$.InputTwice(), GradeAction.project$5(lazyRef, clazz)));
        boolean beforeInputComplete = false;
        if (inputTwiceEnabled) {
            beforeInputComplete = this.clazzGradeService().isInputComplete(clazz, (Iterable)takers, (Iterable)gradeTypes);
        }
        takers.foreach((Function1)(JProcedure1 & Serializable)taker -> {
            CourseGrade grade = helper.build(clazz, gradeState, (Option<CourseGrade>)existGradeMap.get((Object)taker.std()), (CourseTaker)taker, (Iterable<GradeType>)gradeTypes, status, updatedAt);
            if (grade != null) {
                grades.addOne((Object)grade);
                return;
            }
        });
        String operator = Securities$.MODULE$.user();
        if (submit) {
            gradeState.updateStatus((Iterable)gradeTypes, Grade.Status$.MODULE$.Confirmed(), updatedAt, operator);
        } else {
            gradeState.updateStatus((Iterable)gradeTypes, Grade.Status$.MODULE$.New(), updatedAt, operator);
        }
        this.entityDao().saveOrUpdate((Object)grades, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{gradeState}));
        if (submit & isPublish) {
            Set publishables = (Set)Set$.MODULE$.from((IterableOnce)this.clazzGradeService().getPublishableGradeTypes(clazz.project()));
            publishables.addOne((Object)new GradeType(GradeType$.MODULE$.EndGa()));
            publishables.addOne((Object)new GradeType(GradeType$.MODULE$.Final()));
            this.clazzGradeService().publish("" + BoxesRunTime.unboxToLong((Object)clazz.id()), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])publishables.toArray(ClassTag$.MODULE$.apply(GradeType.class))), true);
        }
        this.businessLogger().info((submit ? "\u5f55\u5165" : "\u63d0\u4ea4") + (clazz.crn() + "\u7684\u8865\u7f13\u8003\u6210\u7ee9"), clazz.id(), (Object)Map$.MODULE$.empty());
        if (submit) {
            return this.redirect("report", "&clazzId=" + clazz.id() + "&gradeTypeId=" + GradeType$.MODULE$.MakeupGa(), "info.save.success");
        }
        StringBuilder params = new StringBuilder("&clazzId=" + clazz.id());
        params.append("&gradeTypeIds=").append(((IterableOnceOps)gradeTypes.map((Function1 & Serializable)_$13 -> BoxesRunTime.unboxToInt((Object)_$13.id()))).mkString(","));
        if (inputTwiceEnabled) {
            boolean afterInputComplete = this.clazzGradeService().isInputComplete(clazz, (Iterable)takers, (Iterable)gradeTypes);
            if (!beforeInputComplete && afterInputComplete) {
                params.append("&secondInput=1");
            }
        }
        return this.redirect("inputMakeup", params.toString(), "info.save.success");
    }

    public View removeMakeup() {
        CourseGradeState gradeState;
        Teacher teacher;
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        View check = this.checkMakeupGaPermission(clazz, teacher = this.getTeacher(), gradeState = this.clazzGradeService().getState(clazz));
        if (check != null) {
            return check;
        }
        this.clazzGradeService().remove(clazz, (GradeType)this.getCode(GradeType.class, GradeType$.MODULE$.MakeupGa()));
        this.businessLogger().info("\u5220\u9664\u4e86" + clazz.crn() + "\u7684\u8865\u7f13\u6210\u7ee9", clazz.id(), (Object)Map$.MODULE$.empty());
        return this.redirect("clazz", "clazzId=" + clazz.id(), "info.remove.success");
    }

    public View report() {
        List gradeTypeIds = this.getLongIds("gradeType");
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, this.getLong("clazzId").get());
        scala.collection.immutable.Seq grades = this.entityDao().findBy(CourseGrade.class, "clazz", (Object)clazz);
        CourseGradeState gradeState = this.clazzGradeService().getState(clazz);
        boolean isEndGa = gradeTypeIds.isEmpty() || gradeTypeIds.contains((Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.EndGa()));
        scala.collection.immutable.Seq<ClazzGradeReport> reports = ClazzGradeReport$.MODULE$.build(gradeState, (scala.collection.immutable.Seq<CourseGrade>)grades, isEndGa, this.settings().getSetting(clazz.project()), 3000);
        this.put("reports", reports);
        this.putGradeConsts();
        return this.forward(isEndGa ? "report/reportGa" : "report/reportMakeup");
    }

    public View blank() {
        scala.collection.immutable.Seq clazzes = this.entityDao().find(Clazz.class, (Iterable)this.getLongIds("clazz"));
        ObjectRef gradeTypes = ObjectRef.create((Object)Collections$.MODULE$.newBuffer());
        Map courseTakers = Collections$.MODULE$.newMap();
        Map courseGrades = Collections$.MODULE$.newMap();
        Map examTakers = Collections$.MODULE$.newMap();
        Map states = Collections$.MODULE$.newMap();
        BooleanRef makeup = BooleanRef.create((boolean)this.getBoolean("makeup", false));
        this.getInt("gradeType.id").foreach((Function1)(JFunction1.mcVI.sp & Serializable)g -> {
            boolean bl;
            makeup$1.elem = bl = ((GradeType)this.codeService().get(GradeType.class, g)).isMakeupOrDeplay();
        });
        if (makeup.elem) {
            Buffer buffer = this.codeService().get(GradeType.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{GradeType$.MODULE$.Delay(), GradeType$.MODULE$.Makeup()})).toBuffer();
            gradeTypes.elem = buffer;
            buffer = null;
            clazzes.foreach((Function1 & Serializable)clazz -> {
                CourseGradeState cgs = this.clazzGradeService().getState(clazz);
                if (cgs == null) {
                    cgs = new CourseGradeState();
                }
                states.put(clazz, (Object)cgs);
                scala.collection.immutable.Seq takers = this.makeupStdStrategy().getCourseTakers(clazz);
                courseTakers.put(clazz, (Object)takers);
                if (takers.isEmpty()) {
                    courseGrades.put(clazz, (Object)Map$.MODULE$.empty());
                    return examTakers.put(clazz, (Object)Map$.MODULE$.empty());
                }
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"clazz");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, clazz);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"std");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, takers.map((Function1 & Serializable)_$14 -> _$14.std()));
                scala.collection.immutable.Seq grades = this.entityDao().findBy(CourseGrade.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                courseGrades.put(clazz, (Object)((IterableOnceOps)grades.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.std(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                return examTakers.put(clazz, this.getExamTakerMap((Clazz)clazz, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{ExamType$.MODULE$.Delay(), ExamType$.MODULE$.Makeup()})));
            });
            this.put("Usual", this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.Usual())));
            this.put("End", this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.End())));
            this.put("EndGa", this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.EndGa())));
            v0 = BoxedUnit.UNIT;
        } else {
            clazzes.foreach((Function1 & Serializable)clazz -> {
                CourseGradeState cgs = this.clazzGradeService().getState(clazz);
                if (cgs == null) {
                    cgs = new CourseGradeState();
                }
                states.put(clazz, (Object)cgs);
                Buffer takers = clazz.enrollment().courseTakers();
                courseTakers.put(clazz, (Object)takers);
                if (takers.isEmpty()) {
                    courseGrades.put(clazz, (Object)Map$.MODULE$.empty());
                    return examTakers.put(clazz, (Object)Map$.MODULE$.empty());
                }
                OqlBuilder cgBuilder = (OqlBuilder)OqlBuilder$.MODULE$.from(CourseGrade.class, "cg").where("cg.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.semester()})).where("cg.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.project()})).where("cg.course=:course", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.course()})).where("cg.std in (:stds)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{takers.map((Function1 & Serializable)_$15 -> _$15.std())}));
                cgBuilder.where("cg.courseTakeType.id=:exemption", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())}));
                courseGrades.put(clazz, (Object)((IterableOnceOps)this.entityDao().search((QueryBuilder)cgBuilder).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.std(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                return examTakers.put(clazz, this.getExamTakerMap((Clazz)clazz, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{ExamType$.MODULE$.Final()})));
            });
            CourseGradeSetting setting = this.settings().getSetting(((ProjectBased)clazzes.head()).project());
            setting.gaElementTypes().foreach((Function1 & Serializable)gradeType -> {
                GradeType freshedGradeType = (GradeType)this.entityDao().get(GradeType.class, gradeType.id());
                return (Buffer)((Buffer)gradeTypes$5.elem).addOne((Object)freshedGradeType);
            });
            GradeType ga = (GradeType)this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.EndGa()));
            this.put("EndGa", ga);
            v0 = ((Buffer)gradeTypes.elem).addOne((Object)ga);
        }
        this.put("clazzes", clazzes);
        this.put("courseTakerMap", courseTakers);
        this.put("courseGradeMap", courseGrades);
        this.put("examTakerMap", examTakers);
        this.put("stateMap", states);
        this.put("gradeTypes", ((Buffer)gradeTypes.elem).sortBy((Function1 & Serializable)_$16 -> _$16.code(), (Ordering)Ordering.String$.MODULE$));
        return this.forward(makeup.elem ? "report/blankMakeup" : "report/blankGa");
    }

    public View examAnalysis() {
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        scala.collection.immutable.Seq grades = this.entityDao().findBy(CourseGrade.class, "clazz", (Object)clazz);
        GradeType gradeType = (GradeType)this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.End()));
        scala.collection.immutable.Seq stats = GradeSegStat$.MODULE$.stat((Iterable)grades, (Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GradeType[]{gradeType})), GradeSegStat$.MODULE$.getDefaultSegments());
        this.put("clazz", clazz);
        this.put("stats", stats);
        scala.collection.immutable.Seq analysis = this.entityDao().findBy(ExamAnalysis.class, "clazz", (Object)clazz);
        this.put("analysis", analysis.headOption());
        return this.forward(this.forward$default$1());
    }

    public View examReport() {
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        Teacher teacher = this.getTeacher();
        if (!clazz.teachers().contains((Object)teacher)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        scala.collection.immutable.Seq grades = this.entityDao().findBy(CourseGrade.class, "clazz", (Object)clazz);
        GradeType gradeType = (GradeType)this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.End()));
        scala.collection.immutable.Seq stats = GradeSegStat$.MODULE$.stat((Iterable)grades, (Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GradeType[]{gradeType})), GradeSegStat$.MODULE$.getDefaultSegments());
        this.put("stats", stats);
        this.put("clazz", clazz);
        ObjectRef analysis = ObjectRef.create((Object)this.entityDao().findBy(ExamAnalysis.class, "clazz", (Object)clazz).headOption());
        this.get("analysisContents").foreach((Function1)(JProcedure1 & Serializable)c -> {
            if (((Option)analysis$1.elem).isEmpty()) {
                ExamAnalysis n = new ExamAnalysis();
                n.clazz_$eq(clazz);
                n.updatedAt_$eq(Instant.now());
                n.contents_$eq(c);
                this.entityDao().saveOrUpdate((Object)n, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExamAnalysis[0]));
                Some some = Some$.MODULE$.apply((Object)n);
                analysis$1.elem = some;
                some = null;
                return;
            }
            ((ExamAnalysis)Option$.MODULE$.option2Iterable((Option)analysis$1.elem).head()).contents_$eq(c);
        });
        if (((Option)analysis.elem).isEmpty()) {
            return this.forward("examAnalysis");
        }
        this.put("analysis", (Option)analysis.elem);
        return this.forward(this.forward$default$1());
    }

    public scala.collection.immutable.Map<Student, ExamTaker> getExamTakerMap(Clazz clazz, scala.collection.immutable.Seq<Object> examTypeIds) {
        OqlBuilder query = (OqlBuilder)OqlBuilder$.MODULE$.from(ExamTaker.class, "examTaker").where("examTaker.clazz =:clazz", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz}));
        query.where("examTaker.examType.id in (:examTypeIds)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{examTypeIds}));
        return ((IterableOnceOps)this.entityDao().search((QueryBuilder)query).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.std(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private View checkEndGaPermission(Clazz clazz, Teacher teacher, CourseGradeState gradeState) {
        return this.checkPermission(clazz, teacher, gradeState, GradeType$.MODULE$.EndGa(), Grade.Status$.MODULE$.Confirmed());
    }

    private View checkMakeupGaPermission(Clazz clazz, Teacher teacher, CourseGradeState gradeState) {
        return this.checkPermission(clazz, teacher, gradeState, GradeType$.MODULE$.MakeupGa(), Grade.Status$.MODULE$.Confirmed());
    }

    private View checkPermission(Clazz clazz, Teacher teacher, CourseGradeState gradeState, int gaGradeTypeId, int checkedStatus) {
        String msg = this.checkOwnerPermission(clazz, teacher);
        if (msg != null) {
            return this.forward("500", msg);
        }
        GradeInputSwitch s = this.getGradeInputSwitch(clazz.project(), clazz.semester());
        if (!s.checkOpen(Instant.now())) {
            return this.redirect("index", "\u5f55\u5165\u5c1a\u672a\u5f00\u653e");
        }
        if (gradeState.isStatus(new GradeType(gaGradeTypeId), checkedStatus)) {
            return this.redirect("submitResult", "classId=" + clazz.id(), "info.save.success");
        }
        return null;
    }

    private String checkOwnerPermission(Clazz clazz, Teacher teacher) {
        if (teacher == null) {
            return "\u53ea\u6709\u6559\u5e08\u624d\u53ef\u4ee5\u5f55\u5165\u6210\u7ee9";
        }
        if (!clazz.teachers().contains((Object)teacher)) {
            return "\u6ca1\u6709\u6743\u9650";
        }
        return null;
    }

    private GradeInputSwitch getGradeInputSwitch(Project project, Semester semester) {
        GradeInputSwitch s = this.gradeInputSwitchService().getSwitch(project, semester);
        if (s == null) {
            s = new GradeInputSwitch();
            s.project_$eq(project);
            s.semester_$eq(semester);
            s.types().addAll((IterableOnce)this.codeService().get(GradeType.class));
        }
        return s;
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, Clazz clazz$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)clazz$1.project()));
        }
        return project;
    }

    private static final Project project$1(LazyRef project$lzy1$2, Clazz clazz$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : GradeAction.project$lzyINIT1$1(project$lzy1$2, clazz$2));
    }

    private final /* synthetic */ GradingMode $anonfun$5(int x) {
        return (GradingMode)this.getCode(GradingMode.class, x);
    }

    private static final Project project$lzyINIT2$1(LazyRef project$lzy2$1, Clazz clazz$3) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)clazz$3.project()));
        }
        return project;
    }

    private static final Project project$2(LazyRef project$lzy2$2, Clazz clazz$4) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : GradeAction.project$lzyINIT2$1(project$lzy2$2, clazz$4));
    }

    private static final Project project$lzyINIT3$1(LazyRef project$lzy3$1, Clazz clazz$5) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)clazz$5.project()));
        }
        return project;
    }

    private static final Project project$3(LazyRef project$lzy3$2, Clazz clazz$6) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : GradeAction.project$lzyINIT3$1(project$lzy3$2, clazz$6));
    }

    private static final Object saveGa$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return BoxesRunTime.boxToInteger((int)0);
    }

    private static final Project project$lzyINIT4$1(LazyRef project$lzy4$1, Clazz clazz$8) {
        Project project;
        LazyRef lazyRef = project$lzy4$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy4$1.initialized() ? project$lzy4$1.value() : project$lzy4$1.initialize((Object)clazz$8.project()));
        }
        return project;
    }

    private static final Project project$4(LazyRef project$lzy4$2, Clazz clazz$9) {
        return (Project)(project$lzy4$2.initialized() ? project$lzy4$2.value() : GradeAction.project$lzyINIT4$1(project$lzy4$2, clazz$9));
    }

    private final /* synthetic */ Buffer inputMakeup$$anonfun$1(Buffer gradeTypes$2, int gradeTypeId) {
        return (Buffer)gradeTypes$2.addOne((Object)this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)gradeTypeId)));
    }

    private static final Project project$lzyINIT5$1(LazyRef project$lzy5$1, Clazz clazz$10) {
        Project project;
        LazyRef lazyRef = project$lzy5$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy5$1.initialized() ? project$lzy5$1.value() : project$lzy5$1.initialize((Object)clazz$10.project()));
        }
        return project;
    }

    private static final Project project$5(LazyRef project$lzy5$2, Clazz clazz$11) {
        return (Project)(project$lzy5$2.initialized() ? project$lzy5$2.value() : GradeAction.project$lzyINIT5$1(project$lzy5$2, clazz$11));
    }

    private final /* synthetic */ Buffer saveMakeup$$anonfun$1(Buffer gradeTypes$3, int gradeTypeId) {
        return (Buffer)gradeTypes$3.addOne((Object)this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)gradeTypeId)));
    }
}

