/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.action;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.security.Securities$;
import org.beangle.web.action.view.View;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Terms;
import org.openurp.base.edu.model.Terms$;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.TermCalculator;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.edu.model.GradingMode$;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.GaGrade;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.grade.service.CourseGradeCalculator;
import org.openurp.edu.teaching.web.action.GuidanceCourseGroup;
import org.openurp.starter.web.support.TeacherSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

/*
 * Exception performing whole class analysis ignored.
 */
public class GuidanceAction
extends TeacherSupport {
    private WebBusinessLogger businessLogger;
    private CourseGradeCalculator calculator;

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public CourseGradeCalculator calculator() {
        return this.calculator;
    }

    public void calculator_$eq(CourseGradeCalculator x$1) {
        this.calculator = x$1;
    }

    public View projectIndex(Teacher teacher, Project project) {
        Semester semester = this.getSemester();
        Teacher teacher2 = this.getTeacher();
        this.put("semester", (Object)semester);
        this.put("teacher", (Object)teacher2);
        Seq groups = this.getGuidanceGroups(project);
        Seq allCourses = (Seq)groups.flatMap((Function1 & Serializable)_$3 -> _$3.courses());
        this.put("groups", (Object)groups);
        this.put("courses", (Object)allCourses);
        if (groups.nonEmpty()) {
            Seq stds = this.getStds(teacher2, semester);
            Set activeStds = Collections$.MODULE$.newSet();
            Map groupTerms = Collections$.MODULE$.newMap();
            TermCalculator termCalculator = new TermCalculator(project, semester, this.entityDao());
            stds.foreach((Function1)(JProcedure1 & Serializable)std -> {
                int term = this.calcTerm(std, semester);
                groups.foreach((Function1)(JProcedure1 & Serializable)group -> {
                    if (group.contains(term)) {
                        groupTerms.put((Object)(std.id() + "_" + group.name()), (Object)BoxesRunTime.boxToInteger((int)term));
                        activeStds.add(std);
                        return;
                    }
                });
            });
            this.put("stds", activeStds.toSeq().sortBy((Function1 & Serializable)x -> x.grade().code() + x.code(), (Ordering)Ordering.String$.MODULE$));
            this.put("stdGroupTerms", (Object)groupTerms);
            if (stds.nonEmpty()) {
                Seq grades = this.getGrades(project, semester, (Iterable)allCourses, (Iterable)stds);
                scala.collection.immutable.Map rs = (scala.collection.immutable.Map)grades.groupBy((Function1 & Serializable)_$4 -> _$4.course()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Course c = (Course)tuple2._1();
                        Seq gs = (Seq)tuple2._2();
                        return Tuple2$.MODULE$.apply((Object)c, (Object)gs.groupBy((Function1 & Serializable)_$5 -> _$5.std()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), ((IterableOps)x._2()).head())));
                    }
                    throw new MatchError((Object)tuple2);
                });
                this.put("gradeMap", (Object)rs);
            } else {
                this.put("gradeMap", (Object)Predef$.MODULE$.Map().empty());
            }
        }
        this.put("EmsApi", (Object)Ems$.MODULE$.api());
        return this.forward(this.forward$default$1());
    }

    private int calcTerm(Student std, Semester semester) {
        Project project = std.project();
        if (!this.isStuding(std, semester.beginOn().plusDays(20L), semester.endOn().minusDays(20L))) {
            return 0;
        }
        Tuple2 sp2 = this.semesterService().get(project, std.beginOn(), semester.endOn());
        Buffer semesters = Collections$.MODULE$.newBuffer();
        semesters.$plus$plus$eq((IterableOnce)sp2._1());
        semesters.$plus$plus$eq((IterableOnce)sp2._2());
        IntRef notinschool = IntRef.create((int)0);
        semesters.foreach((Function1)(JProcedure1 & Serializable)s -> {
            LocalDate endOn;
            LocalDate beginOn = s.beginOn().plusDays(20L);
            if (!this.isStuding(std, beginOn, endOn = s.endOn().minusDays(20L))) {
                int n;
                notinschool$1.elem = n = notinschool$1.elem + 1;
                return;
            }
        });
        return semesters.size() - notinschool.elem;
    }

    private boolean isStuding(Student std, LocalDate beginOn, LocalDate endOn) {
        Buffer states = (Buffer)std.states().filter((Function1 & Serializable)x -> x.beginOn().isBefore(endOn) && beginOn.isBefore(x.endOn()));
        if (states.exists((Function1 & Serializable)_$6 -> _$6.inschool())) {
            return true;
        }
        return states.exists((Function1 & Serializable)x -> ((String)x.remark().getOrElse(GuidanceAction::isStuding$$anonfun$2$$anonfun$1)).contains("\u4ea4\u6d41") || ((String)x.remark().getOrElse(GuidanceAction::isStuding$$anonfun$2$$anonfun$2)).contains("\u4ea4\u6362"));
    }

    private Seq<CourseGrade> getGrades(Project project, Semester semester, Iterable<Course> courses, Iterable<Student> stds) {
        OqlBuilder gradeQuery = OqlBuilder$.MODULE$.from(CourseGrade.class, "grade");
        gradeQuery.where("grade.std in(:stds)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{stds}));
        gradeQuery.where("grade.project=:project and grade.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project, semester}));
        gradeQuery.where("grade.course in(:course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courses}));
        return this.entityDao().search((QueryBuilder)gradeQuery);
    }

    private Seq<GuidanceCourseGroup> getGuidanceGroups(Project project) {
        String courseTerms = (String)this.getConfig("edu.course.guidance_course_terms", (Object)"", project);
        if (Strings$.MODULE$.isBlank((CharSequence)courseTerms)) {
            return package$.MODULE$.List().empty();
        }
        courseTerms = Strings$.MODULE$.substringBetween(courseTerms, "{", "}");
        Buffer groups = Collections$.MODULE$.newBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(courseTerms, ","));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)group -> {
            String name = Strings$.MODULE$.substringBefore(group, ":");
            name = Strings$.MODULE$.replace(name, "'", "");
            name = Strings$.MODULE$.replace(name, "\"", "");
            String termList = Strings$.MODULE$.substringAfter(group, ":");
            termList = Strings$.MODULE$.replace(termList, "'", "");
            termList = Strings$.MODULE$.replace(termList, "\"", "");
            Map course2Term = Collections$.MODULE$.newMap();
            Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(termList, ";"));
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)courseTerm -> {
                String[] data = Strings$.MODULE$.split(courseTerm, "=");
                Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(data[0]))));
                Terms term = Terms$.MODULE$.apply(data[1]);
                return course2Term.put((Object)course, (Object)term);
            });
            return (Buffer)groups.addOne((Object)new GuidanceCourseGroup(name, course2Term.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        });
        return groups.toSeq();
    }

    private Seq<Student> getStds(Teacher teacher, Semester semester) {
        OqlBuilder stdQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Student.class, "std").where("std.tutor=:me or std.advisor=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        stdQuery.where("std.beginOn < :endOn and :beginOn < std.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.endOn(), semester.beginOn()}));
        stdQuery.orderBy("std.state.grade.code,std.code");
        return this.entityDao().search((QueryBuilder)stdQuery);
    }

    public View save() {
        Seq stds;
        Project project = this.getProject();
        Semester semester = this.getSemester();
        Teacher teacher = this.getTeacher();
        Seq groups = this.getGuidanceGroups(project);
        Seq allCourses = (Seq)groups.flatMap((Function1 & Serializable)_$7 -> _$7.courses());
        if (allCourses.nonEmpty() && (stds = this.getStds(teacher, semester)).nonEmpty()) {
            Seq grades = this.getGrades(project, semester, (Iterable)allCourses, (Iterable)stds);
            scala.collection.immutable.Map gradeMap = (scala.collection.immutable.Map)grades.groupBy((Function1 & Serializable)_$8 -> _$8.course()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Course c = (Course)tuple2._1();
                    Seq gs = (Seq)tuple2._2();
                    return Tuple2$.MODULE$.apply((Object)c, (Object)gs.groupBy((Function1 & Serializable)_$9 -> _$9.std()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), ((IterableOps)x._2()).head())));
                }
                throw new MatchError((Object)tuple2);
            });
            GradingMode gradingMode = (GradingMode)this.entityDao().get(GradingMode.class, (Object)BoxesRunTime.boxToInteger((int)GradingMode$.MODULE$.Percent()));
            GradeType endGaType = (GradeType)this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.EndGa()));
            stds.foreach((Function1)(JProcedure1 & Serializable)std -> groups.foreach((Function1)(JProcedure1 & Serializable)group -> group.courses().withFilter((Function1 & Serializable)course -> group.matched(std, teacher)).foreach((Function1)(JProcedure1 & Serializable)course -> {
                Option option = this.getFloat(std.id() + "_" + course.id() + ".score");
                if (option instanceof Some) {
                    CourseGrade courseGrade;
                    float score = BoxesRunTime.unboxToFloat((Object)((Some)option).value());
                    Option option2 = ((MapOps)gradeMap.getOrElse(course, GuidanceAction::$anonfun$8)).get(std);
                    if (None$.MODULE$.equals(option2)) {
                        CourseGrade g = new CourseGrade();
                        g.project_$eq(project);
                        g.semester_$eq(semester);
                        g.course_$eq(course);
                        g.std_$eq(std);
                        g.createdAt_$eq(Instant.now());
                        g.updatedAt_$eq(Instant.now());
                        g.crn_$eq("--");
                        g.operator_$eq((Option)Some$.MODULE$.apply((Object)Securities$.MODULE$.user()));
                        g.gradingMode_$eq(gradingMode);
                        g.courseType_$eq((CourseType)course.courseType().get());
                        g.examMode_$eq(course.examMode());
                        CourseTakeType ctt = new CourseTakeType();
                        ctt.id_$eq((Object)BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Normal()));
                        g.courseTakeType_$eq(ctt);
                        GaGrade gaGrade2 = g.addGaGrade(endGaType, Grade.Status$.MODULE$.Published());
                        gaGrade2.operator_$eq((Option)Some$.MODULE$.apply((Object)Securities$.MODULE$.user()));
                        courseGrade = g;
                    } else if (option2 instanceof Some) {
                        CourseGrade g = (CourseGrade)((Some)option2).value();
                        GaGrade gaGrade3 = g.addGaGrade(endGaType, Grade.Status$.MODULE$.Published());
                        gaGrade3.operator_$eq((Option)Some$.MODULE$.apply((Object)Securities$.MODULE$.user()));
                        courseGrade = g;
                    } else {
                        throw new MatchError((Object)option2);
                    }
                    CourseGrade grade2 = courseGrade;
                    grade2.getGaGrade(endGaType).foreach((Function1)(JProcedure1 & Serializable)gaGrade -> {
                        float oldScore = BoxesRunTime.unboxToFloat((Object)gaGrade.score().getOrElse(GuidanceAction::$anonfun$9));
                        if (oldScore != score) {
                            this.calculator().updateScore(gaGrade, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)score)), grade2.gradingMode());
                            this.calculator().calcFinal(grade2);
                            this.entityDao().saveOrUpdate((Object)grade2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGrade[0]));
                            String msg = oldScore < 0.0f ? "\u5f55\u5165\u4e86" + std.code() + "\u7684" + course.name() + "\u6210\u7ee9\uff1a" + score : "\u4fee\u6539\u4e86" + std.code() + "\u7684" + course.name() + "\u6210\u7ee9\uff1a\u4ece" + oldScore + "\u6539\u4e3a" + score;
                            this.businessLogger().info(msg, grade2.id(), (Object)Predef$.MODULE$.Map().empty());
                            return;
                        }
                    });
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    if (this.get(std.id() + "_" + course.id() + ".score").nonEmpty()) {
                        ((MapOps)gradeMap.getOrElse(course, GuidanceAction::save$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2)).get(std).foreach((Function1)(JProcedure1 & Serializable)grade -> {
                            String oldScore = (String)grade.score().map((Function1 & Serializable)_$10 -> GuidanceAction.$anonfun$10((float)BoxesRunTime.unboxToFloat((Object)_$10))).getOrElse(GuidanceAction::$anonfun$11);
                            GaGrade gaGrade = grade.addGaGrade(endGaType, Grade.Status$.MODULE$.Published());
                            this.calculator().updateScore(gaGrade, (Option)None$.MODULE$, grade.gradingMode());
                            this.calculator().calcFinal(grade);
                            this.entityDao().saveOrUpdate(grade, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGrade[0]));
                            String msg = "\u5220\u9664\u4e86" + std.code() + "\u7684" + course.name() + "\u6210\u7ee9\uff1a" + oldScore;
                            this.businessLogger().info(msg, grade.id(), (Object)Predef$.MODULE$.Map().empty());
                        });
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            })));
        }
        int toSemesterId = BoxesRunTime.unboxToInt((Object)this.getInt("toSemester.id").getOrElse(() -> GuidanceAction.$anonfun$12(semester)));
        return this.redirect("index", "semester.id=" + toSemesterId, "info.save.success");
    }

    private static final String isStuding$$anonfun$2$$anonfun$1() {
        return "";
    }

    private static final String isStuding$$anonfun$2$$anonfun$2() {
        return "";
    }

    private static final scala.collection.immutable.Map $anonfun$8() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final float $anonfun$9() {
        return -1.0f;
    }

    private static final scala.collection.immutable.Map save$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final /* synthetic */ String $anonfun$10(float _$10) {
        return BoxesRunTime.boxToFloat((float)_$10).toString();
    }

    private static final String $anonfun$11() {
        return "";
    }

    private static final int $anonfun$12(Semester semester$5) {
        return BoxesRunTime.unboxToInt((Object)semester$5.id());
    }
}

