/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.action;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.edu.service.TimeSettingService;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.edu.clazz.config.ScheduleSetting;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.domain.WeekTimeBuilder$;
import org.openurp.edu.schedule.service.CourseTable;
import org.openurp.edu.service.Features;
import org.openurp.starter.web.helper.ProjectProfile$;
import org.openurp.starter.web.support.TeacherSupport;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class CoursetableAction
extends TeacherSupport {
    private TimeSettingService timeSettingService;
    private ClazzProvider clazzProvider;

    public TimeSettingService timeSettingService() {
        return this.timeSettingService;
    }

    public void timeSettingService_$eq(TimeSettingService x$1) {
        this.timeSettingService = x$1;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public View projectIndex(Teacher teacher, Project project) {
        Semester semester = this.getSemester();
        ScheduleSetting setting = this.getSwitch(project, semester);
        this.put("weekdays", semester.calendar().weekdays());
        this.put("semester", semester);
        CourseTable table = new CourseTable(semester, (Object)teacher, "teacher");
        table.placePublished_$eq(setting.placePublished());
        table.timePublished_$eq(setting.timePublished());
        Iterable weektimes = WeekTimeBuilder$.MODULE$.build(semester, "*");
        table.setClazzes(this.clazzProvider().getClazzes(semester, teacher, project), weektimes);
        Set campuses = ((IterableOnceOps)table.clazzes().map((Function1 & Serializable)_$3 -> _$3.campus())).toSet();
        if (campuses.isEmpty()) {
            campuses = project.campuses().toSet();
        }
        Buffer settings = Collections$.MODULE$.newBuffer();
        campuses.foreach((Function1 & Serializable)c -> {
            BoxedUnit boxedUnit;
            try {
                TimeSetting setting = this.timeSettingService().get(project, semester, (Option)Some$.MODULE$.apply(c));
                boxedUnit = settings.addOne((Object)setting);
            }
            catch (Exception e) {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        if (settings.isEmpty()) {
            TimeSetting setting2 = this.timeSettingService().get(project, semester, (Option)None$.MODULE$);
            settings.addOne((Object)setting2);
        }
        table.timeSetting_$eq((TimeSetting)settings.head());
        table.style_$eq(CourseTable.Style$.WEEK_TABLE);
        Object object = this.getConfig(Features.Clazz$.MODULE$.TableStyle(), project);
        String string = "UNIT_COLUMN";
        if (!(object != null ? !object.equals(string) : string != null)) {
            table.style_$eq(CourseTable.Style$.UNIT_COLUMN);
        }
        this.put("showClazzIndex", this.getConfig(Features.Clazz$.MODULE$.IndexSupported(), project));
        this.put("teachingNatures", this.codeService().get(TeachingNature.class));
        this.put("table", table);
        ProjectProfile$.MODULE$.set(project);
        return this.forward(this.forward$default$1());
    }

    private ScheduleSetting getSwitch(Project project, Semester semester) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(ScheduleSetting.class, "setting");
        query.where("setting.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where("setting.semester =:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.cacheable(query.cacheable$default$1());
        Option option = this.entityDao().search((QueryBuilder)query).headOption();
        if (None$.MODULE$.equals(option)) {
            ScheduleSetting ns = new ScheduleSetting();
            ns.placePublished_$eq(true);
            ns.timePublished_$eq(true);
            return ns;
        }
        if (option instanceof Some) {
            ScheduleSetting s = (ScheduleSetting)((Some)option).value();
            return s;
        }
        throw new MatchError((Object)option);
    }
}

