/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.ability.web.action;

import jakarta.servlet.http.Part;
import java.io.Serializable;
import java.time.Instant;
import java.time.YearMonth;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.webmvc.To;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.std.model.Student;
import org.openurp.prac.ability.config.AbilityCreditConfig;
import org.openurp.prac.ability.config.AbilityCreditSetting;
import org.openurp.prac.ability.model.AbilityCreditApply;
import org.openurp.prac.ability.web.action.StdCertAction;
import org.openurp.starter.web.support.StudentSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class StdAction
extends StudentSupport
implements EntityAction<AbilityCreditApply> {
    private Class entityClass;
    private WebBusinessLogger businessLogger;

    public StdAction() {
        EntitySupport.$init$((EntitySupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public View projectIndex(Student student) {
        boolean displayCredits = student.grade().beginIn().isAfter(YearMonth.parse("2022-07"));
        if (!displayCredits) {
            return this.redirect((To)this.to(StdCertAction.class, "index"), "");
        }
        Seq applies = this.entityDao().findBy(AbilityCreditApply.class, "std", (Object)student);
        this.put("applies", applies);
        Repository repo = EmsApp$.MODULE$.getBlobRepository(true);
        Seq paths = (Seq)applies.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x, (Object)repo.url(x.attachmentPath())));
        this.put("attachmentPaths", paths.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.put("editables", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Draft, AuditStatus$.Submited, AuditStatus$.Rejected, AuditStatus$.RejectedByDepartTrial, AuditStatus$.RejectedByDepart})));
        OqlBuilder configQuery = OqlBuilder$.MODULE$.from(AbilityCreditConfig.class, "config");
        configQuery.where("config.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{student.project()}));
        configQuery.where(":level in elements(config.levels) and config.eduType=:eduType", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{student.level(), student.eduType()}));
        configQuery.where("config.endAt > :now ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Instant.now()}));
        Option config = this.entityDao().search((QueryBuilder)configQuery).headOption();
        this.put("config", config);
        config.foreach((Function1)(JProcedure1 & Serializable)cfg -> {
            Buffer allSettings = (Buffer)cfg.settings().filter((Function1 & Serializable)_$2 -> _$2.suitable(student));
            Buffer specials = (Buffer)allSettings.filter((Function1 & Serializable)_$3 -> _$3.special());
            this.put("specials", specials.groupBy((Function1 & Serializable)_$4 -> _$4.certificate().category()));
            Buffer commons = (Buffer)allSettings.filter((Function1 & Serializable)_$5 -> !_$5.special());
            this.put("commons", commons.groupBy((Function1 & Serializable)_$6 -> _$6.certificate().category()));
        });
        if (config.isEmpty()) {
            this.put("commons", Predef$.MODULE$.Map().empty());
            this.put("specials", Predef$.MODULE$.Map().empty());
        }
        return this.forward(this.forward$default$1());
    }

    public View edit() {
        AbilityCreditApply abilityCreditApply;
        LazyRef lazyRef = new LazyRef();
        AbilityCreditSetting setting = (AbilityCreditSetting)this.entityDao().get(AbilityCreditSetting.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("setting")));
        Option option = this.getLong("apply.id");
        if (None$.MODULE$.equals(option)) {
            AbilityCreditApply ap = new AbilityCreditApply();
            ap.std_$eq(this.getStudent());
            abilityCreditApply = ap;
        } else if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            abilityCreditApply = (AbilityCreditApply)this.entityDao().get(AbilityCreditApply.class, (Object)BoxesRunTime.boxToLong((long)id));
        } else {
            throw new MatchError((Object)option);
        }
        AbilityCreditApply apply = abilityCreditApply;
        Student std = apply.std();
        apply.certificate_$eq(setting.certificate());
        if (!apply.persisted() && setting.certificate().subjects().isEmpty()) {
            apply.finished_$eq(true);
            apply.subjects_$eq("\u5168\u90e8");
        }
        this.put("setting", setting);
        this.put("apply", apply);
        return this.forward(this.forward$default$1());
    }

    public View remove() {
        block4: {
            AbilityCreditApply apply;
            Student std;
            block6: {
                block5: {
                    std = this.getStudent();
                    apply = (AbilityCreditApply)this.entityDao().get(AbilityCreditApply.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("apply")));
                    Student student = apply.std();
                    Student student2 = std;
                    if (student != null ? !student.equals(student2) : student2 != null) break block4;
                    AuditStatus auditStatus = apply.status();
                    AuditStatus auditStatus2 = AuditStatus$.Passed;
                    if (!(auditStatus == null ? auditStatus2 != null : !auditStatus.equals(auditStatus2))) break block5;
                    AuditStatus auditStatus3 = apply.status();
                    AuditStatus auditStatus4 = AuditStatus$.PassedByDepart;
                    if (auditStatus3 != null ? !auditStatus3.equals(auditStatus4) : auditStatus4 != null) break block6;
                }
                return this.redirect("index", "\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\uff0c\u6682\u65f6\u4e0d\u80fd\u5220\u9664");
            }
            Repository repo = EmsApp$.MODULE$.getBlobRepository(true);
            if (Strings$.MODULE$.isNotEmpty((CharSequence)apply.attachmentPath())) {
                repo.remove(apply.attachmentPath());
            }
            this.entityDao().remove((Object)apply, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbilityCreditApply[0]));
            this.businessLogger().info(std.code() + " " + std.name() + "\u5220\u9664\u4e86" + apply.certificate().name() + "\u8ba4\u5b9a\u7533\u8bf7", apply.id(), (Object)Predef$.MODULE$.Map().empty());
            return this.redirect("index", "\u5220\u9664\u6210\u529f");
        }
        return this.redirect("index", "\u5220\u9664\u6210\u529f");
    }

    private Option<Object> getConvertCredits(Student std, AbilityCreditApply apply, AbilityCreditSetting setting) {
        if (std.grade().beginIn().isAfter(YearMonth.parse("2022-07"))) {
            if (apply.finished()) {
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)1.0f));
            }
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.5f));
        }
        return None$.MODULE$;
    }

    public View save() {
        AbilityCreditSetting setting;
        AbilityCreditApply apply;
        Student std;
        block8: {
            block7: {
                std = this.getStudent();
                apply = (AbilityCreditApply)this.populateEntity(AbilityCreditApply.class, "apply");
                setting = (AbilityCreditSetting)this.entityDao().get(AbilityCreditSetting.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("setting")));
                AuditStatus auditStatus = apply.status();
                AuditStatus auditStatus2 = AuditStatus$.Passed;
                if (!(auditStatus == null ? auditStatus2 != null : !auditStatus.equals(auditStatus2))) break block7;
                AuditStatus auditStatus3 = apply.status();
                AuditStatus auditStatus4 = AuditStatus$.PassedByDepart;
                if (auditStatus3 != null ? !auditStatus3.equals(auditStatus4) : auditStatus4 != null) break block8;
            }
            return this.redirect("index", "\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\uff0c\u6682\u65f6\u4e0d\u80fd\u4fee\u6539");
        }
        if (!setting.config().within(Instant.now())) {
            return this.redirect("index", "\u4e0d\u5728\u7533\u8bf7\u65f6\u95f4\u6bb5\u5185\uff0c\u6682\u65f6\u4e0d\u80fd\u7533\u8bf7");
        }
        apply.std_$eq(std);
        apply.updatedAt_$eq(Instant.now());
        apply.certificate_$eq(setting.certificate());
        apply.semester_$eq(this.getSemester());
        apply.auditDepart_$eq(setting.collegeReviewRequired() ? std.department() : (Department)setting.auditDepart().getOrElse(() -> StdAction.save$$anonfun$1(std)));
        apply.auditOpinion_$eq((Option)None$.MODULE$);
        apply.credits_$eq(this.getConvertCredits(std, apply, setting));
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && parts.head() != null && ((Part)parts.head()).getSize() > 0L) {
            Repository repo = EmsApp$.MODULE$.getBlobRepository(true);
            if (Strings$.MODULE$.isNotEmpty((CharSequence)apply.attachmentPath())) {
                repo.remove(apply.attachmentPath());
            }
            Part part = (Part)parts.head();
            BlobMeta meta = repo.upload("/ability/certificate", part.getInputStream(), std.code() + "_" + part.getSubmittedFileName(), std.code() + " " + std.name());
            apply.attachmentPath_$eq(meta.filePath());
        }
        if (Strings$.MODULE$.isNotBlank((CharSequence)apply.attachmentPath())) {
            apply.status_$eq(AuditStatus$.Submited);
            this.entityDao().saveOrUpdate((Object)apply, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbilityCreditApply[0]));
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"subjects");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)apply.subjects());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"certificateNo");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, apply.certificateNo().getOrElse(StdAction::$anonfun$5));
            Map details = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.businessLogger().info(std.code() + " " + std.name() + "\u63d0\u4ea4\u4e86" + setting.certificate().name() + "\u8ba4\u5b9a\u7533\u8bf7", apply.id(), (Object)details);
            return this.redirect("index", "&projectId=" + std.project().id(), "\u63d0\u4ea4\u6210\u529f");
        }
        return this.redirect("edit", "&settingId=" + setting.id() + "&projectId=" + std.project().id() + "&apply.id=" + apply.id(), "\u7f3a\u5c11\u9644\u4ef6");
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, AbilityCreditApply apply$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)apply$1.std().project()));
        }
        return project;
    }

    private static final Project project$1(LazyRef project$lzy1$2, AbilityCreditApply apply$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : StdAction.project$lzyINIT1$1(project$lzy1$2, apply$2));
    }

    private static final Department save$$anonfun$1(Student std$1) {
        return std$1.department();
    }

    private static final String $anonfun$5() {
        return "--";
    }
}

