/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.ability.service.impl;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.std.model.Student;
import org.openurp.prac.ability.config.AbilityCreditConfig;
import org.openurp.prac.ability.model.AbilityCredit;
import org.openurp.prac.ability.model.AbilityCreditApply;
import org.openurp.prac.ability.service.AbilityCreditApplyService;
import org.openurp.prac.ability.service.ExternCourseGradeSyncService;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class AbilityCreditApplyServiceImpl
implements AbilityCreditApplyService {
    private EntityDao entityDao;
    private Option externCourseGradeSyncService = None$.MODULE$;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public Option<ExternCourseGradeSyncService> externCourseGradeSyncService() {
        return this.externCourseGradeSyncService;
    }

    public void externCourseGradeSyncService_$eq(Option<ExternCourseGradeSyncService> x$1) {
        this.externCourseGradeSyncService = x$1;
    }

    public void accept(AbilityCreditApply apply) {
        apply.status_$eq(AuditStatus$.Passed);
        this.entityDao().saveOrUpdate((Object)apply, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbilityCreditApply[0]));
        Student std = apply.std();
        AbilityCredit credit = this.autoStatCredit(std);
        int requiredCredits = ((AbilityCreditConfig)this.entityDao().getAll(AbilityCreditConfig.class).head()).credits();
        if ((int)credit.credits() >= requiredCredits && credit.courseGradeId().isEmpty()) {
            this.externCourseGradeSyncService().foreach((Function1)(JProcedure1 & Serializable)s -> {
                long courseGradeId = s.add(std, apply.semester(), this.getCourse(std, requiredCredits));
                if (courseGradeId > 0L) {
                    credit.courseGradeId_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)courseGradeId)));
                    this.entityDao().saveOrUpdate((Object)credit, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbilityCredit[0]));
                    return;
                }
            });
            return;
        }
    }

    private Course getCourse(Student std, int requiredCredits) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(Course.class, "c");
        q.where("c.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.project()}));
        q.where("c.department=:depart", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.department()}));
        q.where("c.name=:name", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"\u80fd\u529b\u7d20\u8d28\u62d3\u5c55\u8bfe"}));
        q.where("c.defaultCredits=:credits", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)requiredCredits)}));
        return (Course)this.entityDao().search((QueryBuilder)q).head();
    }

    public void reject(AbilityCreditApply apply) {
        apply.status_$eq(AuditStatus$.Rejected);
        this.entityDao().saveOrUpdate((Object)apply, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbilityCreditApply[0]));
        int requiredCredits = ((AbilityCreditConfig)this.entityDao().getAll(AbilityCreditConfig.class).head()).credits();
        AbilityCredit credit = this.autoStatCredit(apply.std());
        if ((int)credit.credits() < requiredCredits && credit.courseGradeId().nonEmpty()) {
            long existCourseGradeId = BoxesRunTime.unboxToLong((Object)credit.courseGradeId().get());
            credit.courseGradeId_$eq((Option)None$.MODULE$);
            this.entityDao().saveOrUpdate((Object)credit, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbilityCredit[0]));
            this.externCourseGradeSyncService().foreach((Function1)(JProcedure1 & Serializable)s -> s.remove(existCourseGradeId));
            return;
        }
    }

    private AbilityCredit autoStatCredit(Student std) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"std");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)std);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"status");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)AuditStatus$.Passed);
        Seq applies = this.entityDao().findBy(AbilityCreditApply.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        float credits = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)applies.map((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToFloat((Object)_$2.credits().getOrElse(AbilityCreditApplyServiceImpl::$anonfun$1$$anonfun$1)))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        AbilityCredit abilityCredit = (AbilityCredit)this.entityDao().findBy(AbilityCredit.class, "std", (Object)std).headOption().getOrElse(() -> AbilityCreditApplyServiceImpl.$anonfun$2(std));
        abilityCredit.credits_$eq(credits);
        abilityCredit.updatedAt_$eq(Instant.now());
        this.entityDao().saveOrUpdate((Object)abilityCredit, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbilityCredit[0]));
        return abilityCredit;
    }

    private static final float $anonfun$1$$anonfun$1() {
        return 0.0f;
    }

    private static final AbilityCredit $anonfun$2(Student std$2) {
        return new AbilityCredit(std$2);
    }
}

