/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.innovation.web.action.admin;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.pojo.DateRange;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.webmvc.annotation.ignore;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Department;
import org.openurp.prac.innovation.model.Batch;
import org.openurp.prac.innovation.model.LevelJounal;
import org.openurp.prac.innovation.model.Project;
import org.openurp.prac.innovation.model.ProjectCategory;
import org.openurp.prac.innovation.model.ProjectLevel;
import org.openurp.prac.innovation.web.action.helper.ExportProject;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class LevelAction
extends RestfulAction<Project>
implements ExportSupport<Project> {
    public void indexSetting() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(LevelJounal.class, "j");
        query.select("distinct j.awardYear").orderBy("j.awardYear desc");
        this.put("years", this.entityDao().search((QueryBuilder)query));
        Seq batches = this.entityDao().getAll(Batch.class);
        this.put("batches", batches);
        this.put("projectLevels", this.entityDao().getAll(ProjectLevel.class));
        this.put("projectCategories", this.entityDao().getAll(ProjectCategory.class));
        OqlBuilder departQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Department.class, "d").where("d.endOn is null or d.endOn >=:endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((DateRange)batches.head()).beginOn()}));
        this.put("departments", this.entityDao().search((QueryBuilder)departQuery));
    }

    public OqlBuilder<Project> getQueryBuilder() {
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        this.get("student").foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(m))) {
                String[] names = Strings$.MODULE$.split(m);
                if (names.length == 1) {
                    builder.where("exists(from project.members m where m.std.code like :names or m.std.name like :names)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + m + "%"}));
                    return;
                }
                builder.where("exists(from project.members m where m.std.code in(:names) or m.std.name in (:names))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{names}));
                return;
            }
        });
        this.get("instructor").foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(m))) {
                builder.where("exists(from project.instructors i where i.staff.code like :teacherCode or i.name like :teacherName)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + m + "%", "%" + m + "%"}));
                return;
            }
        });
        Option year = this.getInt("year");
        Option levelId = this.getInt("level.id");
        if (year.isDefined() && levelId.isDefined()) {
            builder.where("exists(from project.levels l where l.awardYear=:year and l.level.id=:levelId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{year.get(), levelId.get()}));
        } else if (year.isDefined()) {
            builder.where("exists(from project.levels l where l.awardYear=:year)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{year.get()}));
        } else if (levelId.isDefined()) {
            builder.where("exists(from project.levels l where l.level.id=:levelId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{levelId.get()}));
        }
        return builder;
    }

    public View levelSetting() {
        this.put("projectLevels", this.entityDao().getAll(ProjectLevel.class));
        Seq projects = this.entityDao().find(Project.class, (Iterable)this.getLongIds("project"));
        this.put("projects", projects);
        return this.forward(this.forward$default$1());
    }

    public View updateLevel() {
        Seq projects = this.entityDao().find(Project.class, (Iterable)this.getLongIds("project"));
        Seq levels = this.entityDao().getAll(ProjectLevel.class);
        projects.foreach((Function1)(JProcedure1 & Serializable)p -> levels.foreach((Function1 & Serializable)level -> {
            Option option = this.getInt("year_level_" + level.id());
            if (None$.MODULE$.equals(option)) {
                p.levels().find((Function1 & Serializable)j -> {
                    ProjectLevel projectLevel = j.level();
                    ProjectLevel projectLevel2 = level;
                    return !(projectLevel != null ? !projectLevel.equals(projectLevel2) : projectLevel2 != null);
                }).foreach((Function1 & Serializable)lj -> (Buffer)p.levels().$minus$eq(lj));
                return BoxedUnit.UNIT;
            }
            if (option instanceof Some) {
                int year = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                Option option2 = p.levels().find((Function1 & Serializable)j -> {
                    ProjectLevel projectLevel = j.level();
                    ProjectLevel projectLevel2 = level;
                    return !(projectLevel != null ? !projectLevel.equals(projectLevel2) : projectLevel2 != null);
                });
                if (None$.MODULE$.equals(option2)) {
                    LevelJounal lj2 = new LevelJounal(year, p, level);
                    return p.levels().$plus$eq((Object)lj2);
                }
                if (option2 instanceof Some) {
                    LevelJounal j2 = (LevelJounal)((Some)option2).value();
                    j2.awardYear_$eq(year);
                    j2.updatedAt_$eq(Instant.now());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)option);
        }));
        this.entityDao().saveOrUpdate((Iterable)projects);
        return this.redirect("search", "info.save.success");
    }

    @ignore
    public void configExport(ExportContext context) {
        OqlBuilder<Project> query = this.getQueryBuilder();
        query.limit(null);
        Seq closures = this.entityDao().search(query);
        Seq projects = (Seq)closures.map((Function1 & Serializable)x -> new ExportProject((Project)x));
        context.put("items", (Object)projects);
    }
}

