/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.innovation.web.action.admin.close;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.pojo.DateRange;
import org.beangle.webmvc.annotation.ignore;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.Discipline;
import org.openurp.prac.innovation.model.Batch;
import org.openurp.prac.innovation.model.Closure;
import org.openurp.prac.innovation.model.ClosureReview;
import org.openurp.prac.innovation.model.ClosureReviewDetail;
import org.openurp.prac.innovation.model.ClosureReviewGroup;
import org.openurp.prac.innovation.model.Expert;
import org.openurp.prac.innovation.model.Project;
import org.openurp.prac.innovation.model.ProjectCategory;
import org.openurp.prac.innovation.model.StageType;
import org.openurp.prac.innovation.model.StageType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ClosureReviewAction
extends RestfulAction<ClosureReview>
implements ExportSupport<ClosureReview> {
    @ignore
    public String simpleEntityName() {
        return "review";
    }

    public void indexSetting() {
        Seq batches = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Batch.class, "b").orderBy("b.beginOn desc"));
        this.put("batches", batches);
        this.put("projectCategories", this.entityDao().getAll(ProjectCategory.class));
        OqlBuilder departQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Department.class, "d").where("d.endOn is null or d.endOn >=:endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((DateRange)batches.head()).beginOn()}));
        this.put("departments", this.entityDao().search((QueryBuilder)departQuery));
        this.put("closureStage", new StageType(StageType$.MODULE$.Closure()));
        this.put("disciplines", this.entityDao().getAll(Discipline.class));
    }

    public View generate() {
        List batchId = this.getIntIds("review.project.batch");
        OqlBuilder query = OqlBuilder$.MODULE$.from(Project.class, "p");
        query.where("not exists(from " + ClosureReview.class.getName() + " ir where ir.project=p)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.where("p.batch.id=:batchId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{batchId}));
        Seq projects = this.entityDao().search((QueryBuilder)query);
        Seq crs = (Seq)projects.map((Function1 & Serializable)p -> {
            ClosureReview cr = new ClosureReview();
            cr.project_$eq(p);
            return cr;
        });
        this.entityDao().saveOrUpdate((Iterable)crs);
        return this.redirect("search", "info.save.success");
    }

    public View search() {
        this.put("reviews", this.entityDao().search(this.getQueryBuilder()));
        int batchId = BoxesRunTime.unboxToInt((Object)this.getIntIds("review.project.batch").head());
        this.put("groups", this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(ClosureReviewGroup.class, "crg").where("crg.batch.id=:batchId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batchId)}))));
        OqlBuilder stat = OqlBuilder$.MODULE$.from(ClosureReview.class.getName(), "cr");
        stat.where("cr.project.batch.id=:batchId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batchId)}));
        stat.where("cr.group is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        stat.select("cr.group.id,count(*)");
        stat.groupBy("cr.group.id");
        Map stats = ((IterableOnceOps)this.entityDao().search((QueryBuilder)stat).map((Function1 & Serializable)x -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)ScalaRunTime$.MODULE$.array_apply(x, 0).toString());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, ScalaRunTime$.MODULE$.array_apply(x, 1));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("stats", stats);
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<ClosureReview> getQueryBuilder() {
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        this.get("student").foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (!m.isEmpty()) {
                builder.where("exists(from review.project.members m where m.std.code like :stdCode or m.std.name like :stdName)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + m + "%", "%" + m + "%"}));
                return;
            }
        });
        this.get("expert").foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (!m.isEmpty()) {
                builder.where("exists(from review.details  as m where m.expert.code like :expertCode or m.expert.name like :expertName)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + m + "%", "%" + m + "%"}));
                return;
            }
        });
        this.getBoolean("has_group").foreach((Function1 & Serializable)g -> ClosureReviewAction.getQueryBuilder$$anonfun$3(builder, BoxesRunTime.unboxToBoolean((Object)g)));
        return builder;
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Closure closure = (Closure)this.entityDao().get(Closure.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("closure")));
        this.put("closure", closure);
        return this.forward(this.forward$default$1());
    }

    public View assign() {
        Seq reviews = this.entityDao().find(ClosureReview.class, (Iterable)this.getLongIds("review"));
        ClosureReviewGroup group = (ClosureReviewGroup)this.entityDao().get(ClosureReviewGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("reviewGroup")));
        reviews.foreach((Function1)(JProcedure1 & Serializable)cr -> this.assignExperts((ClosureReview)cr, group));
        return this.redirect("search", "info.save.success");
    }

    private void assignExperts(ClosureReview cr, ClosureReviewGroup group) {
        if (cr.score().isEmpty()) {
            Iterator expertIter = group.experts().iterator();
            cr.details().foreach((Function1)(JProcedure1 & Serializable)r -> {
                if (r.score().isEmpty() && expertIter.hasNext()) {
                    r.expert_$eq((Expert)expertIter.next());
                    r.updatedAt_$eq(Instant.now());
                    return;
                }
            });
            while (group.experts().size() > cr.details().size()) {
                ClosureReviewDetail r2 = new ClosureReviewDetail();
                r2.review_$eq(cr);
                r2.updatedAt_$eq(Instant.now());
                r2.expert_$eq((Expert)expertIter.next());
                cr.details().$plus$eq((Object)r2);
            }
            cr.group_$eq((Option)Some$.MODULE$.apply((Object)group));
            this.entityDao().saveOrUpdate((Object)cr, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClosureReview[0]));
            return;
        }
    }

    public View clear() {
        Seq reviews = this.entityDao().find(ClosureReview.class, (Iterable)this.getLongIds("review"));
        reviews.foreach((Function1)(JProcedure1 & Serializable)cr -> {
            cr.group_$eq((Option)None$.MODULE$);
            cr.details().$minus$minus$eq((IterableOnce)cr.details().filter((Function1 & Serializable)_$1 -> _$1.score().isEmpty()));
            this.entityDao().saveOrUpdate(cr, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClosureReview[0]));
        });
        return this.redirect("search", "info.save.success");
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$3(OqlBuilder builder$3, boolean g) {
        return (OqlBuilder)builder$3.where("review.group is " + (g ? " not " : " ") + " null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }
}

