/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.innovation.web.action.admin.init;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.pojo.DateRange;
import org.beangle.webmvc.annotation.ignore;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.Discipline;
import org.openurp.prac.innovation.model.Batch;
import org.openurp.prac.innovation.model.Expert;
import org.openurp.prac.innovation.model.InitReview;
import org.openurp.prac.innovation.model.InitReviewDetail;
import org.openurp.prac.innovation.model.InitReviewGroup;
import org.openurp.prac.innovation.model.Project;
import org.openurp.prac.innovation.model.ProjectCategory;
import org.openurp.prac.innovation.model.StageType;
import org.openurp.prac.innovation.model.StageType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class InitReviewAction
extends RestfulAction<InitReview> {
    @ignore
    public String simpleEntityName() {
        return "review";
    }

    public void indexSetting() {
        Seq batches = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Batch.class, "b").orderBy("b.beginOn desc"));
        this.put("batches", batches);
        this.put("projectCategories", this.entityDao().getAll(ProjectCategory.class));
        OqlBuilder departQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Department.class, "d").where("d.endOn is null or d.endOn >=:endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((DateRange)batches.head()).beginOn()}));
        this.put("departments", this.entityDao().search((QueryBuilder)departQuery));
        this.put("closureStage", new StageType(StageType$.MODULE$.Initial()));
        this.put("disciplines", this.entityDao().getAll(Discipline.class));
    }

    public View generate() {
        int batchId = BoxesRunTime.unboxToInt((Object)this.getIntIds("review.project.batch").head());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Project.class, "p");
        query.where("not exists(from " + InitReview.class.getName() + " ir where ir.project=p)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.where("p.batch.id=:batchId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batchId)}));
        Seq projects = this.entityDao().search((QueryBuilder)query);
        Seq irs = (Seq)projects.map((Function1 & Serializable)p -> {
            InitReview ir = new InitReview();
            ir.project_$eq(p);
            return ir;
        });
        this.entityDao().saveOrUpdate((Iterable)irs);
        return this.redirect("search", "info.save.success");
    }

    public View search() {
        this.put("reviews", this.entityDao().search(this.getQueryBuilder()));
        this.put("groups", this.entityDao().getAll(InitReviewGroup.class));
        OqlBuilder stat = OqlBuilder$.MODULE$.from(InitReview.class.getName(), "ir");
        stat.where("ir.project.batch.id=:batchId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getIntIds("review.project.batch").head()}));
        stat.where("ir.group is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        stat.select("ir.group.id,count(*)");
        stat.groupBy("ir.group.id");
        Map stats = ((IterableOnceOps)this.entityDao().search((QueryBuilder)stat).map((Function1 & Serializable)x -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)ScalaRunTime$.MODULE$.array_apply(x, 0).toString());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, ScalaRunTime$.MODULE$.array_apply(x, 1));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("stats", stats);
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<InitReview> getQueryBuilder() {
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        this.get("student").foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (!m.isEmpty()) {
                builder.where("exists(from review.project.members m where m.std.code like :stdCode or m.std.name like :stdName)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + m + "%", "%" + m + "%"}));
                return;
            }
        });
        this.get("expert").foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (!m.isEmpty()) {
                builder.where("exists(from review.details  as m where m.expert.code like :expertCode or m.expert.name like :expertName)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + m + "%", "%" + m + "%"}));
                return;
            }
        });
        this.getBoolean("has_group").foreach((Function1 & Serializable)g -> InitReviewAction.getQueryBuilder$$anonfun$3(builder, BoxesRunTime.unboxToBoolean((Object)g)));
        return builder;
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Project project = (Project)this.entityDao().get(Project.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("project")));
        this.put("project", project);
        return this.forward(this.forward$default$1());
    }

    public View assign() {
        Seq reviews = this.entityDao().find(InitReview.class, (Iterable)this.getLongIds("review"));
        InitReviewGroup group = (InitReviewGroup)this.entityDao().get(InitReviewGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("reviewGroup")));
        reviews.foreach((Function1)(JProcedure1 & Serializable)ir -> this.assignExperts((InitReview)ir, group));
        return this.redirect("search", "info.save.success");
    }

    private void assignExperts(InitReview ir, InitReviewGroup group) {
        if (ir.score().isEmpty()) {
            Iterator expertIter = group.experts().iterator();
            ir.details().foreach((Function1)(JProcedure1 & Serializable)r -> {
                if (r.score().isEmpty() && expertIter.hasNext()) {
                    r.expert_$eq((Expert)expertIter.next());
                    r.updatedAt_$eq(Instant.now());
                    return;
                }
            });
            while (group.experts().size() > ir.details().size()) {
                InitReviewDetail r2 = new InitReviewDetail();
                r2.review_$eq(ir);
                r2.updatedAt_$eq(Instant.now());
                r2.expert_$eq((Expert)expertIter.next());
                ir.details().$plus$eq((Object)r2);
            }
            ir.group_$eq((Option)Some$.MODULE$.apply((Object)group));
            this.entityDao().saveOrUpdate((Object)ir, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitReview[0]));
            return;
        }
    }

    public View clear() {
        Seq reviews = this.entityDao().find(InitReview.class, (Iterable)this.getLongIds("review"));
        reviews.foreach((Function1)(JProcedure1 & Serializable)cr -> {
            cr.group_$eq((Option)None$.MODULE$);
            cr.details().$minus$minus$eq((IterableOnce)cr.details().filter((Function1 & Serializable)_$1 -> _$1.score().isEmpty()));
            this.entityDao().saveOrUpdate(cr, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitReview[0]));
        });
        return this.redirect("search", "info.save.success");
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$3(OqlBuilder builder$3, boolean g) {
        return (OqlBuilder)builder$3.where("review.group is " + (g ? " not " : " ") + " null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }
}

