/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.innovation.web.action.helper;

import java.io.Serializable;
import org.openurp.base.std.model.StudentState;
import org.openurp.prac.innovation.model.Member;
import org.openurp.prac.innovation.model.Project;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.Buffer;
import scala.runtime.IntRef;

public class ExportProject {
    private final Project project;

    public ExportProject(Project project) {
        this.project = project;
    }

    public String getYear() {
        return this.project.batch().name();
    }

    public String getSchoolCode() {
        return this.project.batch().school().code();
    }

    public String getSchoolName() {
        return this.project.batch().school().name();
    }

    public String getCode() {
        return (String)this.project.code().getOrElse(ExportProject::getCode$$anonfun$1);
    }

    public String getTitle() {
        return this.project.title();
    }

    public String getCategory() {
        return this.project.category().name();
    }

    public String getManagerName() {
        return ((Member)this.project.manager().get()).std().name();
    }

    public String getManagerCode() {
        return ((Member)this.project.manager().get()).std().code();
    }

    public int getMemberCount() {
        return this.project.members().size();
    }

    public String getMemberNames() {
        IntRef i = IntRef.create((int)0);
        Buffer names = (Buffer)this.project.members().map((Function1 & Serializable)x -> {
            ++i$1.elem;
            return x.std().name() + " " + i$1.elem + "/" + x.std().code();
        });
        return names.mkString(",");
    }

    public String getInstructorNames() {
        return ((IterableOnceOps)this.project.instructors().map((Function1 & Serializable)_$1 -> _$1.name())).mkString(",");
    }

    public String getInstructorTitles() {
        return ((IterableOnceOps)this.project.instructors().map((Function1 & Serializable)_$2 -> (String)_$2.staff().title().map((Function1 & Serializable)_$3 -> _$3.name()).getOrElse(ExportProject::getInstructorTitles$$anonfun$1$$anonfun$2))).mkString(",");
    }

    public String getDiscipline() {
        return this.project.discipline().code() + this.project.discipline().name();
    }

    public String getDepartmentName() {
        return ((StudentState)((Member)this.project.manager().get()).std().state().get()).department().name();
    }

    public String getSummary() {
        return (String)this.project.intro().map((Function1 & Serializable)_$4 -> _$4.summaries()).getOrElse(ExportProject::getSummary$$anonfun$2);
    }

    private static final String getCode$$anonfun$1() {
        return "--";
    }

    private static final String getInstructorTitles$$anonfun$1$$anonfun$2() {
        return "";
    }

    private static final String getSummary$$anonfun$2() {
        return "--";
    }
}

