/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.innovation.web.action.student;

import jakarta.servlet.http.Part;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.LongId;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.security.Securities$;
import org.beangle.webmvc.support.ActionSupport;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentState;
import org.openurp.code.edu.model.Discipline;
import org.openurp.code.service.CodeService;
import org.openurp.prac.innovation.model.Batch;
import org.openurp.prac.innovation.model.InitReviewDetail;
import org.openurp.prac.innovation.model.Intro;
import org.openurp.prac.innovation.model.Material;
import org.openurp.prac.innovation.model.Member;
import org.openurp.prac.innovation.model.Member$;
import org.openurp.prac.innovation.model.Project;
import org.openurp.prac.innovation.model.ProjectCategory;
import org.openurp.prac.innovation.model.ProjectLevel;
import org.openurp.prac.innovation.model.ProjectLevel$;
import org.openurp.prac.innovation.model.ProjectState;
import org.openurp.prac.innovation.model.ProjectState$;
import org.openurp.prac.innovation.model.StageType;
import org.openurp.prac.innovation.model.StageType$;
import org.openurp.prac.innovation.web.action.student.MyProject;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class ProjectAction
extends ActionSupport
implements EntityAction<Project>,
ProjectSupport,
MyProject {
    private Class entityClass;
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private EntityDao entityDao;

    public ProjectAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public View index() {
        String user = Securities$.MODULE$.user();
        StageType initialStage = new StageType(StageType$.MODULE$.Initial());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Batch.class, "b");
        query.where("exists(from b.stages s where :now <= s.endAt and s.stageType=:init)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Instant.now(), initialStage}));
        Seq batches = this.entityDao().search((QueryBuilder)query);
        Seq projects = null;
        if (batches.nonEmpty()) {
            OqlBuilder query2 = OqlBuilder$.MODULE$.from(Project.class, "p");
            query2.where("p.manager.std.code=:code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{user}));
            query2.where("p.batch=:batch", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{batches.head()}));
            projects = this.entityDao().search((QueryBuilder)query2);
            this.put("initialStage", ((Batch)batches.head()).getStage(initialStage));
        }
        OqlBuilder q = OqlBuilder$.MODULE$.from(Project.class, "p");
        q.where("p.manager.std.code=:code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{user}));
        projects = this.entityDao().search((QueryBuilder)q);
        if (projects.nonEmpty()) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"review.project");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)projects);
            this.put("initReviewDetails", this.entityDao().findBy(InitReviewDetail.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).groupBy((Function1 & Serializable)_$2 -> _$2.review().project()));
        } else {
            this.put("initReviewDetails", Predef$.MODULE$.Map().empty());
        }
        this.put("projects", projects);
        this.put("projectCategories", this.entityDao().getAll(ProjectCategory.class));
        this.put("batches", batches);
        return this.forward(this.forward$default$1());
    }

    public View edit() {
        Project project = (Project)this.getEntity(Project.class, "project");
        if (!project.persisted()) {
            project.batch_$eq((Batch)this.entityDao().get(Batch.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("project.batch"))));
            project.category_$eq((ProjectCategory)this.entityDao().get(ProjectCategory.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("project.category"))));
        }
        this.put("projectStates", this.entityDao().getAll(ProjectState.class));
        this.put("disciplines", this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Discipline.class, "d").where("length(d.code)=3", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).orderBy("d.code")));
        this.put("initialStage", project.batch().getStage(new StageType(StageType$.MODULE$.Initial())));
        this.put("managerCode", Securities$.MODULE$.user());
        Option student = this.entityDao().findBy(Student.class, "code", (Object)Securities$.MODULE$.user()).headOption();
        this.put("student", student);
        this.put("project", project);
        return this.forward(this.forward$default$1());
    }

    public View save() {
        Project project = (Project)this.populateEntity(Project.class, "project");
        project.state_$eq(new ProjectState(ProjectState$.MODULE$.Intial()));
        Batch batch = (Batch)this.entityDao().get(Batch.class, project.batch().id());
        project.batch_$eq(batch);
        StageType initialStageType = new StageType(StageType$.MODULE$.Initial());
        if (!this.isIntime(project, StageType$.MODULE$.Initial())) {
            return this.redirect("index", "\u4e0d\u5728\u65f6\u95f4\u8303\u56f4\u5185");
        }
        OqlBuilder stdQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Student.class, "s").where("s.code=:code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        Seq stds = this.entityDao().search((QueryBuilder)stdQuery);
        Student me = (Student)stds.head();
        project.department_$eq(((StudentState)me.state().get()).department());
        project.level_$eq(new ProjectLevel(ProjectLevel$.MODULE$.School()));
        this.entityDao().saveOrUpdate((Object)project, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Project[0]));
        project.instructors().clear();
        Seq instructors = this.entityDao().findBy(Teacher.class, "id", this.getAll("instructorId").map((Function1 & Serializable)_$3 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$3.toString()))));
        project.instructors().$plus$plus$eq((IterableOnce)instructors);
        Member manager = (Member)this.populateEntity(Member.class, "manager");
        if (!manager.persisted()) {
            if (manager.duty() == null) {
                String string = manager.duty();
                String string2 = "\u9879\u76ee\u8d1f\u8d23\u4eba";
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
            if (manager.phone() == null) {
                manager.phone_$eq("--");
            }
        }
        manager.std_$eq((Student)stds.head());
        manager.project_$eq(project);
        project.manager_$eq((Option)Some$.MODULE$.apply((Object)manager));
        boolean inMember = project.members().exists((Function1 & Serializable)_$4 -> {
            Student student = _$4.std();
            Student student2 = manager.std();
            return !(student != null ? !student.equals(student2) : student2 != null);
        });
        if (!inMember) {
            project.members().$plus$eq((Object)manager);
        }
        Set students = this.entityDao().findBy(Student.class, "id", this.getAll("studentId").map((Function1 & Serializable)_$5 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$5.toString())))).toSet();
        students.foreach((Function1)(JProcedure1 & Serializable)s -> {
            boolean exists = project.members().exists((Function1 & Serializable)_$6 -> {
                Student student = _$6.std();
                Student student2 = s;
                return !(student != null ? !student.equals(student2) : student2 != null);
            });
            if (!exists) {
                project.members().$plus$eq((Object)Member$.MODULE$.apply(project, s));
                return;
            }
        });
        Buffer removed = (Buffer)project.members().filter((Function1 & Serializable)a -> {
            Student student = a.std();
            Student student2 = manager.std();
            return (student == null ? student2 != null : !student.equals(student2)) && !students.contains((Object)a.std());
        });
        project.members().$minus$minus$eq((IterableOnce)removed);
        Intro intro = (Intro)this.populateEntity(Intro.class, "intro");
        intro.project_$eq(project);
        project.intro_$eq((Option)Some$.MODULE$.apply((Object)intro));
        this.entityDao().saveOrUpdate((Object)intro, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{manager, project}));
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.size() > 0 && ((Part)parts.head()).getSize() > 0L) {
            Material material;
            Option option = project.materials().find((Function1 & Serializable)_$7 -> {
                StageType stageType = _$7.stageType();
                StageType stageType2 = initialStageType;
                return !(stageType != null ? !stageType.equals(stageType2) : stageType2 != null);
            });
            if (None$.MODULE$.equals(option)) {
                material = new Material(project, initialStageType);
            } else if (option instanceof Some) {
                Material m;
                material = m = (Material)((Some)option).value();
            } else {
                throw new MatchError((Object)option);
            }
            Material material2 = material;
            Part part = (Part)this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class)).head();
            String fileName = part.getSubmittedFileName();
            Instant now = Instant.now();
            material2.fileName_$eq(fileName);
            material2.updatedAt_$eq(now);
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            if (material2.filePath() != null) {
                blob.remove(material2.filePath());
            }
            BlobMeta meta = blob.upload("/innovation/" + BoxesRunTime.boxToInteger((int)project.batch().beginOn().getYear()).toString() + "/" + project.id().toString(), part.getInputStream(), part.getSubmittedFileName(), me.code() + " " + me.name());
            material2.fileSize_$eq(meta.fileSize());
            material2.sha_$eq(meta.sha());
            material2.filePath_$eq(meta.filePath());
            this.entityDao().saveOrUpdate((Object)material2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Material[0]));
        }
        return this.redirect("index", "&batch.id=" + project.batch().id(), "info.save.success");
    }

    public View teacher() {
        String codeOrName = (String)this.get("q").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Teacher.class, "teacher");
        query.where(":project in elements(teacher.projects)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        this.populateConditions(query);
        if (Strings$.MODULE$.isNotEmpty((CharSequence)codeOrName)) {
            query.where("(teacher.name like :name or teacher.staff.code like :code)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + codeOrName + "%", "%" + codeOrName + "%"}));
        }
        LocalDate now = LocalDate.now();
        query.where(":now1 >= teacher.beginOn and (teacher.endOn is null or :now2 <= teacher.endOn)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{now, now})).orderBy("teacher.name");
        PageLimit pageLimit = this.getPageLimit();
        query.limit(pageLimit);
        this.put("teachers", this.entityDao().search((QueryBuilder)query));
        this.put("pageLimit", pageLimit);
        return this.forward(this.forward$default$1());
    }

    public View student() {
        String codeOrName = (String)this.get("q").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Student.class, "student");
        query.where("student.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        this.populateConditions(query);
        if (Strings$.MODULE$.isNotEmpty((CharSequence)codeOrName)) {
            query.where("(student.name like :name or student.code like :code)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + codeOrName + "%", "%" + codeOrName + "%"}));
        }
        query.orderBy("student.name");
        PageLimit pageLimit = this.getPageLimit();
        query.limit(pageLimit);
        this.put("students", this.entityDao().search((QueryBuilder)query));
        this.put("pageLimit", pageLimit);
        return this.forward(this.forward$default$1());
    }

    public View savePromotion() {
        long projectId = this.getLongId("project");
        Project project = (Project)this.entityDao().get(Project.class, (Object)BoxesRunTime.boxToLong((long)projectId));
        int levelId = this.getInt("promotion_level_id", 0);
        int stageTypeId = levelId == ProjectLevel$.MODULE$.Nation() ? StageType$.MODULE$.PromotionNation() : StageType$.MODULE$.PromotionState();
        StageType promotionStage = new StageType(stageTypeId);
        Iterable parts = this.getAll("promotion_report", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Material material;
            Option option = project.materials().find((Function1 & Serializable)_$8 -> {
                StageType stageType = _$8.stageType();
                StageType stageType2 = promotionStage;
                return !(stageType != null ? !stageType.equals(stageType2) : stageType2 != null);
            });
            if (None$.MODULE$.equals(option)) {
                material = new Material(project, promotionStage);
            } else if (option instanceof Some) {
                Material m;
                material = m = (Material)((Some)option).value();
            } else {
                throw new MatchError((Object)option);
            }
            Material material2 = material;
            Part part = (Part)this.getAll("promotion_report", Part.class, ClassTag$.MODULE$.apply(Part.class)).head();
            String fileName = part.getSubmittedFileName();
            Instant now = Instant.now();
            material2.fileName_$eq(fileName);
            material2.updatedAt_$eq(now);
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            if (material2.filePath() != null) {
                blob.remove(material2.filePath());
            }
            Student me = ((Member)project.manager().get()).std();
            BlobMeta meta = blob.upload("/innovation/" + BoxesRunTime.boxToInteger((int)project.batch().beginOn().getYear()).toString() + "/" + project.id().toString(), part.getInputStream(), part.getSubmittedFileName(), me.code() + " " + me.name());
            material2.fileSize_$eq(meta.fileSize());
            material2.sha_$eq(meta.sha());
            material2.filePath_$eq(meta.filePath());
            this.entityDao().saveOrUpdate((Object)material2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Material[0]));
        }
        return this.redirect("index", "\u4fdd\u5b58\u6210\u529f");
    }
}

