/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.innovation.web.action.admin;

import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.DateRange;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.Repository;
import org.beangle.webmvc.annotation.ignore;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Department;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.Discipline;
import org.openurp.code.service.CodeService;
import org.openurp.prac.innovation.model.Batch;
import org.openurp.prac.innovation.model.Intro;
import org.openurp.prac.innovation.model.Material;
import org.openurp.prac.innovation.model.Member;
import org.openurp.prac.innovation.model.Member$;
import org.openurp.prac.innovation.model.Project;
import org.openurp.prac.innovation.model.ProjectCategory;
import org.openurp.prac.innovation.model.ProjectLevel;
import org.openurp.prac.innovation.model.ProjectState;
import org.openurp.prac.innovation.web.action.helper.ExportProject;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ProjectAction
extends RestfulAction<Project>
implements ProjectSupport,
ExportSupport<Project> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public ProjectAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public void indexSetting() {
        Seq batches = this.entityDao().getAll(Batch.class);
        this.put("batches", (Object)batches);
        this.put("projectCategories", (Object)this.entityDao().getAll(ProjectCategory.class));
        OqlBuilder departQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Department.class, "d").where("d.endOn is null or d.endOn >=:endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((DateRange)batches.head()).beginOn()}));
        this.put("departments", (Object)this.entityDao().search((QueryBuilder)departQuery));
        this.put("projectLevels", (Object)this.entityDao().getAll(ProjectLevel.class));
        this.put("projectStates", (Object)this.entityDao().getAll(ProjectState.class));
    }

    public OqlBuilder<Project> getQueryBuilder() {
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        this.get("student").foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (!m.isEmpty()) {
                builder.where("exists(from project.members m where m.std.code like :stdCode or m.std.name like :stdName)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + m + "%", "%" + m + "%"}));
                return;
            }
        });
        this.get("instructor").foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (!m.isEmpty()) {
                builder.where("exists(from project.instructors i where i.staff.code like :teacherCode or i.name like :teacherName)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + m + "%", "%" + m + "%"}));
                return;
            }
        });
        return builder;
    }

    public void editSetting(Project project) {
        if (!project.persisted()) {
            project.batch_$eq((Batch)this.entityDao().get(Batch.class, this.getInt("project.batch.id").get()));
        }
        this.put("projectCategories", (Object)this.entityDao().getAll(ProjectCategory.class));
        this.put("projectLevels", (Object)this.entityDao().getAll(ProjectLevel.class));
        this.put("projectStates", (Object)this.entityDao().getAll(ProjectState.class));
        this.put("disciplines", (Object)this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Discipline.class, "d").where("length(d.code)=3", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).orderBy("d.code")));
        OqlBuilder departQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Department.class, "d").where("d.endOn is null or d.endOn >=:endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project.batch().beginOn()}));
        this.put("departments", (Object)this.entityDao().search((QueryBuilder)departQuery));
    }

    public View saveAndRedirect(Project project) {
        this.entityDao().saveOrUpdate((Object)project, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Project[0]));
        project.instructors().clear();
        Seq instructors = this.entityDao().findBy(Teacher.class, "id", this.getAll("instructorId").map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$1.toString()))));
        project.instructors().$plus$plus$eq((IterableOnce)instructors);
        OqlBuilder stdQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Student.class, "s").where("s.code=:code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.get("managerCode").get()}));
        Seq stds = this.entityDao().search((QueryBuilder)stdQuery);
        Member manager = (Member)this.populateEntity(Member.class, "manager");
        if (!manager.persisted()) {
            if (manager.duty() == null) {
                manager.duty_$eq("\u9879\u76ee\u8d1f\u8d23\u4eba");
            }
            if (manager.phone() == null) {
                manager.phone_$eq("--");
            }
        }
        manager.std_$eq((Student)stds.head());
        manager.project_$eq(project);
        project.manager_$eq((Option)Some$.MODULE$.apply((Object)manager));
        boolean inMember = project.members().exists((Function1 & Serializable)_$2 -> {
            Student student = _$2.std();
            Student student2 = manager.std();
            return !(student != null ? !student.equals(student2) : student2 != null);
        });
        if (!inMember) {
            project.members().$plus$eq((Object)manager);
        }
        Set students = this.entityDao().findBy(Student.class, "id", this.getAll("studentId").map((Function1 & Serializable)_$3 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$3.toString())))).toSet();
        students.foreach((Function1)(JProcedure1 & Serializable)s -> {
            boolean exists = project.members().exists((Function1 & Serializable)_$4 -> {
                Student student = _$4.std();
                Student student2 = s;
                return !(student != null ? !student.equals(student2) : student2 != null);
            });
            if (!exists) {
                project.members().$plus$eq((Object)Member$.MODULE$.apply(project, s));
                return;
            }
        });
        Buffer removed = (Buffer)project.members().filter((Function1 & Serializable)a -> {
            Student student = a.std();
            Student student2 = manager.std();
            return (student == null ? student2 != null : !student.equals(student2)) && !students.contains((Object)a.std());
        });
        project.members().$minus$minus$eq((IterableOnce)removed);
        Intro intro = (Intro)this.populateEntity(Intro.class, "intro");
        intro.project_$eq(project);
        project.intro_$eq((Option)Some$.MODULE$.apply((Object)intro));
        this.entityDao().saveOrUpdate((Object)intro, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{manager, project}));
        return super.saveAndRedirect((Entity)project);
    }

    public View teacher() {
        String codeOrName = (String)this.get("q").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Teacher.class, "teacher");
        query.where(":project in elements(teacher.projects)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        this.populateConditions(query);
        if (Strings$.MODULE$.isNotEmpty((CharSequence)codeOrName)) {
            String codeNameParam = "%" + codeOrName + "%";
            query.where("(teacher.name like :name or teacher.staff.code like :code)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{codeNameParam, codeNameParam}));
        }
        LocalDate now = LocalDate.now();
        query.where(":now1 >= teacher.beginOn and (teacher.endOn is null or :now2 <= teacher.endOn)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{now, now})).orderBy("teacher.name");
        PageLimit pageLimit = this.getPageLimit();
        query.limit(pageLimit);
        this.put("teachers", (Object)this.entityDao().search((QueryBuilder)query));
        this.put("pageLimit", (Object)pageLimit);
        return this.forward(this.forward$default$1());
    }

    public View student() {
        String codeOrName = (String)this.get("q").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Student.class, "student");
        query.where("student.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        this.populateConditions(query);
        if (Strings$.MODULE$.isNotEmpty((CharSequence)codeOrName)) {
            String codeNameParam = "%" + codeOrName + "%";
            query.where("(student.name like :name or student.code like :code)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{codeNameParam, codeNameParam}));
        }
        query.orderBy("student.name");
        PageLimit pageLimit = this.getPageLimit();
        query.limit(pageLimit);
        this.put("students", (Object)this.entityDao().search((QueryBuilder)query));
        this.put("pageLimit", (Object)pageLimit);
        return this.forward(this.forward$default$1());
    }

    @ignore
    public void configExport(ExportContext context) {
        OqlBuilder query = this.getQueryBuilder();
        query.limit(null);
        Seq closures = this.entityDao().search((QueryBuilder)query);
        Seq projects = (Seq)closures.map((Function1 & Serializable)x -> new ExportProject(x));
        context.put("items", (Object)projects);
    }

    public View attachment() {
        Material material = (Material)this.entityDao().get(Material.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("material")));
        Option path = EmsApp$.MODULE$.getBlobRepository(true).url(material.filePath());
        this.response().sendRedirect(((URL)path.get()).toString());
        return null;
    }

    public View removeAndRedirect(Seq<Project> projects) {
        Repository repo = EmsApp$.MODULE$.getBlobRepository(true);
        projects.foreach((Function1)(JProcedure1 & Serializable)project -> project.materials().foreach((Function1 & Serializable)material -> repo.remove(material.filePath())));
        return super.removeAndRedirect(projects);
    }
}

