/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.innovation.web.action.expert;

import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.codec.digest.Digests$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.ems.app.EmsApp$;
import org.beangle.web.servlet.util.CookieUtils$;
import org.beangle.web.servlet.util.RequestUtils$;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.ActionSupport;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.ServletSupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.view.View;
import org.openurp.prac.innovation.model.ClosureReview;
import org.openurp.prac.innovation.model.ClosureReviewDetail;
import org.openurp.prac.innovation.model.Expert;
import org.openurp.prac.innovation.model.Material;
import org.openurp.prac.innovation.model.ProjectLevel;
import org.openurp.prac.innovation.model.Stage;
import org.openurp.prac.innovation.model.StageType;
import org.openurp.prac.innovation.model.StageType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ClosureReviewAction
extends ActionSupport
implements EntityAction<ClosureReviewDetail>,
ServletSupport {
    private Class entityClass;
    private EntityDao entityDao;

    public ClosureReviewAction() {
        EntitySupport.$init$((EntitySupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public View index() {
        return this.forward(this.forward$default$1());
    }

    public View login(@param(value="code") String code, @param(value="password") String password) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(Expert.class, "expert");
        builder.where("expert.code=:code and expert.password=:password", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code, password}));
        Seq experts = this.entityDao().search((QueryBuilder)builder);
        if (experts.isEmpty()) {
            this.addFlashMessage("\u7528\u6237\u548c\u5bc6\u7801\u9519\u8bef", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.redirect("index", null);
        }
        Expert expert = (Expert)experts.head();
        if (!expert.within(LocalDate.now())) {
            this.addFlashMessage("\u8d26\u53f7\u8fc7\u671f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.redirect("index", null);
        }
        this.addCredential(expert);
        return this.redirect("project", null);
    }

    public View logout() {
        CookieUtils$.MODULE$.deleteCookieByName(this.request(), this.response(), "expert_code");
        CookieUtils$.MODULE$.deleteCookieByName(this.request(), this.response(), "expert_credential");
        return this.redirect("index", null);
    }

    public View project() {
        Option expert2 = this.getExpert();
        if (expert2.isEmpty()) {
            return this.redirect("index", null);
        }
        Expert expert = (Expert)Option$.MODULE$.option2Iterable(expert2).head();
        this.put("expert", (Object)expert);
        OqlBuilder s = OqlBuilder$.MODULE$.from(Stage.class, "s");
        s.where("s.stageType =:stageType", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StageType(StageType$.MODULE$.Closure())}));
        s.where("s.endAt < :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Instant.now()}));
        s.orderBy("s.endAt desc");
        Option option = this.entityDao().first((QueryBuilder)s);
        if (None$.MODULE$.equals(option)) {
            return this.forward("no-project");
        }
        if (option instanceof Some) {
            Stage stage = (Stage)((Some)option).value();
            OqlBuilder builder = OqlBuilder$.MODULE$.from(ClosureReviewDetail.class, "detail");
            builder.where("detail.expert = :expert", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{expert}));
            builder.orderBy("detail.review.project.title");
            builder.where("detail.review.project.batch=:batch", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{stage.batch()}));
            Seq details = this.entityDao().search((QueryBuilder)builder);
            if (details.nonEmpty()) {
                ObjectRef detail = ObjectRef.create((Object)((ClosureReviewDetail)details.head()));
                this.getLong("review.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> details.find((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToLong((Object)_$2.id()) == id).foreach((Function1)(JProcedure1 & Serializable)r -> {
                    detail$2.elem = r;
                }));
                this.put("review", (Object)((ClosureReviewDetail)detail.elem).review());
                this.put("reviewDetail", (Object)((ClosureReviewDetail)detail.elem));
                this.put("details", (Object)details);
                this.put("ClosureStageId", (Object)BoxesRunTime.boxToInteger((int)StageType$.MODULE$.Closure()));
                this.put("levels", (Object)this.entityDao().getAll(ProjectLevel.class));
                return this.forward(this.forward$default$1());
            }
            return this.forward("no-project");
        }
        throw new MatchError((Object)option);
    }

    public View info(@param(value="id") String id) {
        Option expert2 = this.getExpert();
        if (expert2.isEmpty()) {
            return this.redirect("index", null);
        }
        this.put("review", (Object)this.getClosureReviewDetail(id, (Expert)Option$.MODULE$.option2Iterable(expert2).head()));
        return this.forward(this.forward$default$1());
    }

    public View save(@param(value="id") String id) {
        Option expert2 = this.getExpert();
        if (expert2.isEmpty()) {
            return this.redirect("index", null);
        }
        ClosureReviewDetail reviewDetail = this.getClosureReviewDetail(id, (Expert)Option$.MODULE$.option2Iterable(expert2).head());
        this.populate((Entity)reviewDetail, "reviewDetail");
        reviewDetail.updatedAt_$eq(Instant.now());
        this.entityDao().saveOrUpdate((Object)reviewDetail, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClosureReviewDetail[0]));
        BooleanRef allReviewed = BooleanRef.create((boolean)true);
        FloatRef sum = FloatRef.create((float)0.0f);
        reviewDetail.review().details().foreach((Function1)(JProcedure1 & Serializable)r -> {
            Option option = r.score();
            if (option instanceof Some) {
                float s = BoxesRunTime.unboxToFloat((Object)((Some)option).value());
                sum$1.elem += s;
                return;
            }
            if (None$.MODULE$.equals(option)) {
                allReviewed$1.elem = false;
                return;
            }
            throw new MatchError((Object)option);
        });
        if (allReviewed.elem) {
            reviewDetail.review().score_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)(sum.elem / (float)reviewDetail.review().details().size()))));
            this.entityDao().saveOrUpdate((Object)reviewDetail.review(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClosureReview[0]));
        }
        return this.redirect("project", "&id=" + reviewDetail.id(), "info.save.success");
    }

    public View attachment(@param(value="id") String id) {
        Option expert2 = this.getExpert();
        if (expert2.isEmpty()) {
            return this.redirect("index", null);
        }
        ClosureReviewDetail reviewDetail = this.getClosureReviewDetail(id, (Expert)Option$.MODULE$.option2Iterable(expert2).head());
        Seq materials = this.entityDao().findBy(Material.class, "project", (Object)new .colon.colon((Object)reviewDetail.review().project(), (List)Nil$.MODULE$));
        if (materials.isEmpty()) {
            return null;
        }
        Option option = materials.find((Function1 & Serializable)_$3 -> BoxesRunTime.unboxToInt((Object)_$3.stageType().id()) == StageType$.MODULE$.Closure());
        if (option instanceof Some) {
            Material material = (Material)((Some)option).value();
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(material.filePath());
            this.response().sendRedirect(((URL)path.get()).toString());
            return null;
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError((Object)option);
    }

    private ClosureReviewDetail getClosureReviewDetail(String id, Expert expert) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(ClosureReviewDetail.class, "detail");
        builder.where("detail.expert=:expert", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{expert}));
        builder.where("detail.id=:id", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id)))}));
        return (ClosureReviewDetail)this.entityDao().search((QueryBuilder)builder).head();
    }

    private String decideContentType(String fileName) {
        return MediaTypes$.MODULE$.get(Strings$.MODULE$.substringAfterLast(fileName, "."), MediaTypes$.MODULE$.ApplicationOctetStream()).toString();
    }

    private void addCredential(Expert expert) {
        CookieUtils$.MODULE$.addCookie(this.request(), this.response(), "expert_code", expert.code(), -1);
        CookieUtils$.MODULE$.addCookie(this.request(), this.response(), "expert_credential", this.genCredential(expert), -1);
    }

    private String genCredential(Expert expert) {
        return Digests$.MODULE$.md5Hex(expert.code() + "_" + expert.password() + "_" + RequestUtils$.MODULE$.getIpAddr(this.request()));
    }

    private Option<Expert> getExpert() {
        String expertCode = CookieUtils$.MODULE$.getCookieValue(this.request(), "expert_code");
        String expertCredential = CookieUtils$.MODULE$.getCookieValue(this.request(), "expert_credential");
        Seq experts = this.entityDao().findBy(Expert.class, "code", (Object)new .colon.colon((Object)expertCode, (List)Nil$.MODULE$));
        if (experts.nonEmpty()) {
            Expert expert = (Expert)experts.head();
            String string = expertCredential;
            String string2 = this.genCredential(expert);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return Some$.MODULE$.apply((Object)expert);
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }
}

