/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.la.web.action.admin;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import org.beangle.commons.bean.orderings.PropertyOrdering$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.concurrent.Workers$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.Repository;
import org.beangle.web.action.annotation.ignore;
import org.beangle.web.action.view.Status$;
import org.beangle.web.action.view.Stream$;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.code.service.CodeService;
import org.openurp.prac.la.model.LaCorporation;
import org.openurp.prac.la.model.LaOption;
import org.openurp.prac.la.model.LaSession;
import org.openurp.prac.la.model.LaVolunteer;
import org.openurp.prac.la.web.action.admin.StdNamePurifier$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class OptionAction
extends RestfulAction<LaOption>
implements ProjectSupport,
ExportSupport<LaOption> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public OptionAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        this.put("project", this.project$1(lazyRef));
        Semester semester = this.getSemester(this.project$1(lazyRef));
        this.put("currentSemester", this.getSemester(this.project$1(lazyRef)));
        this.put("sessions", this.entityDao().findBy(LaSession.class, "semester", package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Semester[]{semester}))));
        super.indexSetting();
    }

    public void editSetting(LaOption entity) {
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("laOption.semester")));
        this.put("semester", semester);
        scala.collection.immutable.Seq sessions = this.entityDao().findBy(LaSession.class, "semester", package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Semester[]{semester})));
        this.put("sessions", sessions);
        OqlBuilder coQuery = OqlBuilder$.MODULE$.from(LaCorporation.class, "co");
        this.getLong("laOption.session.id").foreach((Function1 & Serializable)sessionId -> OptionAction.editSetting$$anonfun$1(coQuery, BoxesRunTime.unboxToLong((Object)sessionId)));
        scala.collection.immutable.Seq corporations = this.entityDao().search((QueryBuilder)coQuery);
        if (entity.corporation() != null && entity.corporation().persisted() && !corporations.contains((Object)entity.corporation())) {
            Buffer c = corporations.toBuffer();
            c.$plus$eq((Object)entity.corporation());
            this.put("corporations", c);
        } else {
            this.put("corporations", corporations);
        }
        super.editSetting((Entity)entity);
    }

    public View report() {
        scala.collection.immutable.Seq options = this.entityDao().find(LaOption.class, (Iterable)this.getLongIds("laOption"));
        this.put("options", options);
        return this.forward(this.forward$default$1());
    }

    public View autoEnroll() {
        LaSession session = (LaSession)this.entityDao().get(LaSession.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("laOption.session")));
        OqlBuilder builder = OqlBuilder$.MODULE$.from(LaOption.class, "laOption");
        builder.where("laOption.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        builder.where("laOption.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{session.semester()}));
        builder.where("laOption.session=:session", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{session}));
        builder.where("size(laOption.volunteers) < laOption.capacity", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        scala.collection.immutable.Seq options = this.entityDao().search((QueryBuilder)builder);
        options.foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.enrollRank((LaOption)((Object)_$1), 1));
        options.foreach((Function1)(JProcedure1 & Serializable)_$2 -> this.enrollRank((LaOption)((Object)_$2), 2));
        return this.redirect("search", "info.save.success");
    }

    private void enrollRank(LaOption option, int rank) {
        int remained = option.capacity() - option.volunteers().size();
        if (remained > 0) {
            Set volunteerStds = ((IterableOnceOps)option.volunteers().map((Function1 & Serializable)_$3 -> _$3.std())).toSet();
            Buffer takers = (Buffer)option.takers().filter((Function1 & Serializable)x -> !volunteerStds.contains((Object)x.volunteer().std()) && x.volunteer().enrolledOption().isEmpty() && x.rank() == rank);
            takers = (Buffer)takers.sorted(PropertyOrdering$.MODULE$.by("rank,volunteer.gpa desc,updatedAt"));
            Buffer enrolled = (Buffer)takers.take(remained);
            enrolled.foreach((Function1)(JProcedure1 & Serializable)taker -> {
                taker.enrolled_$eq(true);
                taker.volunteer().enrolledOption_$eq((Option<LaOption>)Some$.MODULE$.apply((Object)taker.option()));
                taker.volunteer().enrolledRank_$eq((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)taker.rank())));
            });
            Buffer volunteers = (Buffer)enrolled.map((Function1 & Serializable)_$4 -> _$4.volunteer());
            option.volunteers().$plus$plus$eq((IterableOnce)volunteers);
            this.entityDao().saveOrUpdate((Iterable)volunteers);
            return;
        }
    }

    @ignore
    public View removeAndRedirect(scala.collection.immutable.Seq<LaOption> entities) {
        this.remove(entities);
        return this.redirect("search", "info.remove.success");
    }

    public OqlBuilder<LaOption> getQueryBuilder() {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(LaOption.class, "laOption");
        this.get("signup_status").foreach((Function1 & Serializable)x$1 -> {
            String string = x$1;
            if ("0".equals(string)) {
                return builder.where("size(laOption.takers)<option.capacity", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            if ("1".equals(string)) {
                return builder.where("size(laOption.takers)>=option.capacity", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            return BoxedUnit.UNIT;
        });
        this.get("enroll_status").foreach((Function1 & Serializable)x$1 -> {
            String string = x$1;
            if ("0".equals(string)) {
                return builder.where("size(laOption.volunteers)<option.capacity", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            if ("1".equals(string)) {
                return builder.where("size(laOption.volunteers)>=option.capacity", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            return BoxedUnit.UNIT;
        });
        this.populateConditions(builder);
        return (OqlBuilder)builder.orderBy((String)this.get(Order$.MODULE$.OrderStr()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).limit(this.getPageLimit());
    }

    public View corporation() {
        String name = (String)this.get("term").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        OqlBuilder query = OqlBuilder$.MODULE$.from(LaCorporation.class, "corporation");
        this.populateConditions(query);
        if (Strings$.MODULE$.isNotEmpty((CharSequence)name)) {
            query.where("corporation.name like :name ", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + name + "%"}));
        }
        PageLimit pageLimit = this.getPageLimit();
        query.limit(pageLimit);
        this.put("corporations", this.entityDao().search((QueryBuilder)query));
        this.put("pageLimit", pageLimit);
        return this.forward(this.forward$default$1());
    }

    public View saveAndRedirect(LaOption option) {
        option.project_$eq(this.getProject());
        return super.saveAndRedirect((Entity)option);
    }

    public View takers() {
        long optionId = this.getLongId("laOption");
        LaOption option = (LaOption)this.entityDao().get(LaOption.class, (Object)BoxesRunTime.boxToLong((long)optionId));
        Buffer takers = Collections$.MODULE$.newBuffer(option.takers());
        takers = (Buffer)takers.sorted(PropertyOrdering$.MODULE$.by("rank,volunteer.gpa desc,updatedAt"));
        this.put("laOption", (Object)option);
        this.put("takers", takers);
        return this.forward(this.forward$default$1());
    }

    public View volunteers() {
        long optionId = this.getLongId("laOption");
        LaOption option = (LaOption)this.entityDao().get(LaOption.class, (Object)BoxesRunTime.boxToLong((long)optionId));
        this.put("laOption", (Object)option);
        return this.forward(this.forward$default$1());
    }

    public View download() {
        LaOption option = (LaOption)this.entityDao().get(LaOption.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("laOption")));
        File dir = new File(System.getProperty("java.io.tmpdir") + ("option" + option.id()) + Files$.MODULE$.$div());
        if (dir.exists()) {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        }
        dir.mkdirs();
        Buffer innerFiles = Collections$.MODULE$.newBuffer();
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        Workers$.MODULE$.work(option.takers(), (Function1)(JProcedure1 & Serializable)t -> t.volunteer().attachmentPath().foreach((Function1)(JProcedure1 & Serializable)path -> {
            Student std = t.volunteer().std();
            String stdName = StdNamePurifier$.MODULE$.purify(std.name());
            blob.url(path).foreach((Function1)(JProcedure1 & Serializable)url -> {
                String fileName = std.code() + "_" + stdName + "." + Strings$.MODULE$.substringAfterLast(path, ".");
                File localFile = new File(dir.getAbsolutePath() + Files$.MODULE$.$div() + fileName);
                HttpUtils$.MODULE$.download(url.openConnection(), localFile);
                if (localFile.exists()) {
                    innerFiles.addOne((Object)localFile);
                    return;
                }
            });
        }), Runtime.getRuntime().availableProcessors());
        if (innerFiles.isEmpty()) {
            return Status$.MODULE$.NotFound();
        }
        File zipFile = new File(dir.getAbsolutePath() + Files$.MODULE$.$div() + (option.corporation().name() + ".zip"));
        Zipper$.MODULE$.zip(dir, (Seq)innerFiles, zipFile, "utf-8");
        return Stream$.MODULE$.apply(zipFile, "application/zip", option.corporation().name() + "\u62a5\u540d\u6750\u6599.zip").cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
            dir.delete();
        });
    }

    @ignore
    public void configExport(ExportContext context) {
        long optionId = this.getLongId("laOption");
        LaOption option = (LaOption)this.entityDao().get(LaOption.class, (Object)BoxesRunTime.boxToLong((long)optionId));
        Buffer<LaVolunteer> volunteers = option.orderedVolunteers();
        context.put("option", (Object)option);
        context.put("volunteers", volunteers);
        context.put("remark", option.remark().getOrElse(OptionAction::configExport$$anonfun$1));
        context.put("requirement", option.requirement().getOrElse(OptionAction::configExport$$anonfun$2));
        HashMap states = new HashMap();
        HashMap indexes = new HashMap();
        IntRef i = IntRef.create((int)1);
        volunteers.foreach((Function1)(JProcedure1 & Serializable)v -> {
            int n;
            states.put(v.std().id(), v.std().state().get());
            indexes.put(v.std().id(), BoxesRunTime.boxToInteger((int)i$1.elem));
            i$1.elem = n = i$1.elem + 1;
        });
        context.put("states", states);
        context.put("indexes", indexes);
        context.fileName_$eq(option.semester().schoolYear() + "\u5e74\u5ea6" + option.corporation().name() + "\u9762\u8bd5\u540d\u5355.xls");
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final /* synthetic */ OqlBuilder editSetting$$anonfun$1(OqlBuilder coQuery$1, long sessionId) {
        coQuery$1.where("not exists(from " + LaOption.class.getName() + " lo where lo.corporation=co and lo.session.id=:sessionId)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sessionId)}));
        return (OqlBuilder)coQuery$1.orderBy("co.name");
    }

    private static final String configExport$$anonfun$1() {
        return "";
    }

    private static final String configExport$$anonfun$2() {
        return "";
    }
}

