/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.la.web.action.student;

import jakarta.servlet.http.Part;
import java.io.Serializable;
import java.time.Instant;
import javax.sql.DataSource;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.ems.app.datasource.AppDataSourceFactory;
import org.beangle.jdbc.query.JdbcExecutor;
import org.beangle.web.action.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentState;
import org.openurp.prac.la.model.LaOption;
import org.openurp.prac.la.model.LaSession;
import org.openurp.prac.la.model.LaTaker;
import org.openurp.prac.la.model.LaVolunteer;
import org.openurp.starter.web.support.StudentSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

/*
 * Exception performing whole class analysis ignored.
 */
public class EnrollAction
extends StudentSupport
implements Initializing {
    private DataSource eamsDataSource;

    public DataSource eamsDataSource() {
        return this.eamsDataSource;
    }

    public void eamsDataSource_$eq(DataSource x$1) {
        this.eamsDataSource = x$1;
    }

    public void init() {
        AppDataSourceFactory ds = new AppDataSourceFactory();
        ds.name_$eq("eams");
        ds.init();
        this.eamsDataSource_$eq(ds.result());
    }

    public View projectIndex(Student student) {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder volunteerBuilder = OqlBuilder$.MODULE$.from(LaVolunteer.class, "volunteer");
        volunteerBuilder.where("volunteer.std=:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{student}));
        volunteerBuilder.where("volunteer.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getSemester()}));
        Seq volunteers = this.entityDao().search((QueryBuilder)volunteerBuilder);
        this.put("volunteers", (Object)volunteers);
        OqlBuilder sessionBuilder = OqlBuilder$.MODULE$.from(LaSession.class, "session");
        sessionBuilder.where("session.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{EnrollAction.project$1((LazyRef)lazyRef, (Student)student)}));
        sessionBuilder.where("session.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getSemester()}));
        sessionBuilder.where("session.beginAt<:now and session.endAt>:now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Instant.now()}));
        Seq sessions = (Seq)this.entityDao().search((QueryBuilder)sessionBuilder).filter((Function1 & Serializable)s -> s.grades().contains(((StudentState)student.state().get()).grade().code()));
        this.put("sessions", (Object)sessions);
        return this.forward(this.forward$default$1());
    }

    public View signup() {
        Student student = this.getStudent();
        LaSession session = (LaSession)this.entityDao().find(LaSession.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("session"))).get();
        Project project = this.getProject();
        LaVolunteer volunteer = this.getVolunteer(student, session);
        Option gpa = new JdbcExecutor(this.eamsDataSource()).unique("select gpa from edu.std_gpas where std_id=?", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{student.id()}));
        volunteer.gpa_$eq(BoxesRunTime.unboxToFloat((Object)gpa.map((Function1 & Serializable)_$2 -> _$2.floatValue()).getOrElse(EnrollAction::signup$$anonfun$2)));
        if (Float.compare(volunteer.gpa(), session.minGpa()) < 0) {
            this.put("gpa", (Object)BoxesRunTime.boxToFloat((float)volunteer.gpa()));
            this.put("session", (Object)session);
            return this.forward("lowgpa");
        }
        Seq takers = this.getTakers(student, project, session);
        Seq chooseOptions = (Seq)takers.map((Function1 & Serializable)_$3 -> _$3.option());
        this.put("chooseOptions", (Object)chooseOptions);
        OqlBuilder optionBuilder = OqlBuilder$.MODULE$.from(LaOption.class, "option");
        optionBuilder.where("option.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        optionBuilder.where("option.session=:session", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{session}));
        optionBuilder.where("size(option.volunteers) < option.capacity", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.put("options", (Object)this.entityDao().search((QueryBuilder)optionBuilder));
        this.put("student", (Object)student);
        this.put("session", (Object)session);
        this.put("volunteer", (Object)volunteer);
        return this.forward(this.forward$default$1());
    }

    private LaVolunteer getVolunteer(Student std, LaSession session) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(LaVolunteer.class, "volunteer");
        builder.where("volunteer.std=:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        builder.where("volunteer.session=:session", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{session}));
        Seq volunteers = this.entityDao().search((QueryBuilder)builder);
        LaVolunteer volunteer = null;
        if (volunteers.isEmpty()) {
            volunteer = new LaVolunteer();
            volunteer.std_$eq(std);
            volunteer.semester_$eq(session.semester());
            volunteer.session_$eq(session);
            volunteer.updatedAt_$eq(Instant.now());
        } else {
            volunteer = (LaVolunteer)volunteers.head();
        }
        return volunteer;
    }

    private Seq<LaTaker> getTakers(Student std, Project project, LaSession session) {
        OqlBuilder takerBuilder = OqlBuilder$.MODULE$.from(LaTaker.class, "taker");
        takerBuilder.where("taker.volunteer.std=:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        takerBuilder.where("taker.option.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        takerBuilder.where("taker.option.session=:session", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{session}));
        return this.entityDao().search((QueryBuilder)takerBuilder);
    }

    public View choose() {
        Student student = this.getStudent();
        LaSession session = (LaSession)this.entityDao().find(LaSession.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("session"))).get();
        LaVolunteer volunteer = this.getVolunteer(student, session);
        volunteer.updatedAt_$eq(Instant.now());
        volunteer.mobile_$eq((String)this.get("volunteer.mobile").get());
        volunteer.gpa_$eq(BoxesRunTime.unboxToFloat((Object)this.getFloat("volunteer.gpa").get()));
        Project project = this.getProject();
        Buffer saved = Collections$.MODULE$.newBuffer();
        saved.$plus$eq((Object)volunteer);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), session.optionCount()).foreach((Function1 & Serializable)rank -> this.choose$$anonfun$1(volunteer, saved, BoxesRunTime.unboxToInt((Object)rank)));
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Part part = (Part)parts.head();
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            String storeName = student.code() + " \u7b80\u5386." + Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), ".");
            String existPath = (String)volunteer.attachmentPath().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (existPath != null && existPath.startsWith("/")) {
                blob.remove(existPath);
            }
            BlobMeta meta = blob.upload("/la/" + session.id().toString() + "/", part.getInputStream(), storeName, student.code() + " " + student.name());
            volunteer.attachmentPath_$eq((Option)Some$.MODULE$.apply((Object)meta.filePath()));
        }
        this.entityDao().saveOrUpdate((Iterable)saved);
        return this.redirect("index", "\u62a5\u540d\u6210\u529f");
    }

    public View cancel() {
        LaSession session;
        Student student = this.getStudent();
        LaVolunteer volunteer = this.getVolunteer(student, session = (LaSession)this.entityDao().find(LaSession.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("session"))).get());
        if (volunteer.enrolledOption().isEmpty()) {
            Seq takers = this.getTakers(student, this.getProject(), session);
            this.entityDao().remove((Iterable)takers);
            this.entityDao().remove((Object)volunteer, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LaVolunteer[0]));
            return this.redirect("index", "\u53d6\u6d88\u6210\u529f");
        }
        return this.redirect("index", "\u5df2\u7ecf\u786e\u5b9a\u9762\u8bd5\uff0c\u6682\u4e0d\u80fd\u53d6\u6d88");
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, Student student$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)student$1.project()));
        }
        return project;
    }

    private static final Project project$1(LazyRef project$lzy1$2, Student student$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : EnrollAction.project$lzyINIT1$1((LazyRef)project$lzy1$2, (Student)student$2));
    }

    private static final float signup$$anonfun$2() {
        return 0.0f;
    }

    private final /* synthetic */ Object choose$$anonfun$1(LaVolunteer volunteer$1, Buffer saved$1, int rank) {
        Option option = this.get("option" + rank, Long.TYPE);
        if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            LaOption option2 = (LaOption)this.entityDao().get(LaOption.class, (Object)BoxesRunTime.boxToLong((long)id));
            Option option3 = volunteer$1.getTaker((Number)Predef$.MODULE$.int2Integer(rank));
            if (option3 instanceof Some) {
                LaTaker t = (LaTaker)((Some)option3).value();
                LaOption laOption = t.option();
                LaOption laOption2 = option2;
                if (laOption == null ? laOption2 != null : !laOption.equals(laOption2)) {
                    t.option().takers().$minus$eq((Object)t);
                    saved$1.$plus$eq((Object)t.option());
                    t.option_$eq(option2);
                    option2.takers().$plus$eq((Object)t);
                }
                t.updatedAt_$eq(Instant.now());
                v1 = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option3)) {
                LaTaker nt = new LaTaker(volunteer$1, rank, option2);
                volunteer$1.takers().$plus$eq((Object)nt);
                v1 = option2.takers().$plus$eq((Object)nt);
            } else {
                throw new MatchError((Object)option3);
            }
            return saved$1.$plus$eq((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            volunteer$1.getTaker((Number)Predef$.MODULE$.int2Integer(rank)).foreach((Function1 & Serializable)taker -> {
                volunteer$1.takers().$minus$eq(taker);
                taker.option().takers().$minus$eq(taker);
                return (Buffer)saved$1.$plus$eq((Object)taker.option());
            });
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }
}

