/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.activity.model;

import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.reflect.Reflections$;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.DateRange;
import org.beangle.data.model.pojo.Remark;
import org.openurp.base.model.User;
import org.openurp.code.edu.model.TeachingMethod;
import scala.None$;
import scala.Option;
import scala.collection.mutable.Buffer;

public abstract class AbstractPracSchedule
extends LongId
implements DateRange,
Remark {
    private LocalDate beginOn;
    private LocalDate endOn;
    private Option remark;
    private WeekTime weekTime;
    private Option topic;
    private Option times;
    private String places;
    private TeachingMethod teachingMethod;
    private Buffer teachers;
    private Option externTeacher;

    public AbstractPracSchedule() {
        DateRange.$init$((DateRange)this);
        Remark.$init$((Remark)this);
        this.topic = None$.MODULE$;
        this.times = None$.MODULE$;
        this.teachers = Collections$.MODULE$.newBuffer();
        this.externTeacher = None$.MODULE$;
    }

    public LocalDate beginOn() {
        return this.beginOn;
    }

    public LocalDate endOn() {
        return this.endOn;
    }

    public void beginOn_$eq(LocalDate x$1) {
        this.beginOn = x$1;
    }

    public void endOn_$eq(LocalDate x$1) {
        this.endOn = x$1;
    }

    public Option remark() {
        return this.remark;
    }

    public void remark_$eq(Option x$1) {
        this.remark = x$1;
    }

    public WeekTime weekTime() {
        return this.weekTime;
    }

    public void weekTime_$eq(WeekTime x$1) {
        this.weekTime = x$1;
    }

    public Option<String> topic() {
        return this.topic;
    }

    public void topic_$eq(Option<String> x$1) {
        this.topic = x$1;
    }

    public Option<String> times() {
        return this.times;
    }

    public void times_$eq(Option<String> x$1) {
        this.times = x$1;
    }

    public String places() {
        return this.places;
    }

    public void places_$eq(String x$1) {
        this.places = x$1;
    }

    public TeachingMethod teachingMethod() {
        return this.teachingMethod;
    }

    public void teachingMethod_$eq(TeachingMethod x$1) {
        this.teachingMethod = x$1;
    }

    public Buffer<User> teachers() {
        return this.teachers;
    }

    public void teachers_$eq(Buffer<User> x$1) {
        this.teachers = x$1;
    }

    public Option<String> externTeacher() {
        return this.externTeacher;
    }

    public void externTeacher_$eq(Option<String> x$1) {
        this.externTeacher = x$1;
    }

    public void mergeWith(AbstractPracSchedule ns) {
        WeekTime nwt = ns.weekTime();
        if (nwt.firstDay().isBefore(this.beginOn())) {
            this.beginOn_$eq(nwt.firstDay());
        }
        if (nwt.lastDay().isAfter(this.endOn())) {
            this.endOn_$eq(nwt.lastDay());
        }
        WeekTime weekTime = this.weekTime();
        weekTime.weekstate_$eq(weekTime.weekstate().$bar(nwt.weekstate()));
    }

    public AbstractPracSchedule copyOn(WeekTime newTime) {
        AbstractPracSchedule newer = (AbstractPracSchedule)((Object)Reflections$.MODULE$.newInstance(this.getClass()));
        newer.topic_$eq(this.topic());
        newer.updateTime(newTime);
        newer.times_$eq(this.times());
        newer.places_$eq(this.places());
        newer.teachingMethod_$eq(this.teachingMethod());
        newer.teachers().$plus$plus$eq(this.teachers());
        newer.externTeacher_$eq(this.externTeacher());
        return newer;
    }

    public void updateTime(WeekTime newTime) {
        this.weekTime_$eq(newTime);
        this.beginOn_$eq(newTime.firstDay());
        this.endOn_$eq(newTime.lastDay());
    }
}

