/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.activity.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.time.WeekTime;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

public class PracSession {
    private LocalDate beginOn;
    private LocalDate endOn;
    private Set dates;
    private HourMinute beginAt;
    private HourMinute endAt;
    private Option times;
    private String places;

    public PracSession(LocalDate beginOn, LocalDate endOn) {
        this.beginOn = beginOn;
        this.endOn = endOn;
        this.dates = Collections$.MODULE$.newSet();
        this.times = None$.MODULE$;
    }

    public LocalDate beginOn() {
        return this.beginOn;
    }

    public void beginOn_$eq(LocalDate x$1) {
        this.beginOn = x$1;
    }

    public LocalDate endOn() {
        return this.endOn;
    }

    public void endOn_$eq(LocalDate x$1) {
        this.endOn = x$1;
    }

    public Set<LocalDate> dates() {
        return this.dates;
    }

    public void dates_$eq(Set<LocalDate> x$1) {
        this.dates = x$1;
    }

    public HourMinute beginAt() {
        return this.beginAt;
    }

    public void beginAt_$eq(HourMinute x$1) {
        this.beginAt = x$1;
    }

    public HourMinute endAt() {
        return this.endAt;
    }

    public void endAt_$eq(HourMinute x$1) {
        this.endAt = x$1;
    }

    public Option<String> times() {
        return this.times;
    }

    public void times_$eq(Option<String> x$1) {
        this.times = x$1;
    }

    public String places() {
        return this.places;
    }

    public void places_$eq(String x$1) {
        this.places = x$1;
    }

    public void add(WeekTime wt) {
        if (wt.weekstate().value() != 0L) {
            if (wt.firstDay().isBefore(this.beginOn())) {
                this.beginOn_$eq(wt.firstDay());
            }
            if (wt.lastDay().isAfter(this.endOn())) {
                this.endOn_$eq(wt.lastDay());
            }
            this.dates().$plus$plus$eq((IterableOnce)wt.dates());
            this.beginAt_$eq(wt.beginAt());
            this.endAt_$eq(wt.endAt());
            return;
        }
    }

    public String toString() {
        StringBuilder contents = new StringBuilder();
        if (this.beginAt() != null && this.beginAt().value() > 0) {
            List dates = (List)this.dates().toList().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            IntRef thisMonth = IntRef.create((int)-1);
            DateTimeFormatter pattern1 = DateTimeFormatter.ofPattern("M-d");
            DateTimeFormatter pattern2 = DateTimeFormatter.ofPattern("d");
            String datesb = dates.map((Function1 & Serializable)date -> {
                if (date.getMonthValue() != thisMonth$1.elem) {
                    thisMonth$1.elem = date.getMonthValue();
                    return date.format(pattern1);
                }
                return date.format(pattern2);
            }).mkString(",");
            contents.append(datesb);
            contents.append(" ");
            v0 = contents.append(this.beginAt().toString()).append("~").append(this.endAt().toString());
        } else {
            DateTimeFormatter pattern3 = DateTimeFormatter.ofPattern("MM-dd");
            contents.append(this.beginOn().format(pattern3));
            contents.append("~").append(this.endOn().format(pattern3));
            this.times().foreach((Function1 & Serializable)t -> contents.append(" ").append(t));
            v0 = BoxedUnit.UNIT;
        }
        contents.append(" ").append(this.places());
        return contents.mkString();
    }
}

