/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.prac.paper.web.action.admin;

import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.data.dao.Condition;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.Repository;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.service.CodeService;
import org.openurp.prac.paper.model.Paper;
import org.openurp.prac.paper.web.helper.StdNamePurifier$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class PaperAction
extends RestfulAction<Paper>
implements ProjectSupport,
ExportSupport<Paper> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public PaperAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        this.put("project", (Object)this.project$1(lazyRef));
        this.put("semester", (Object)this.getSemester(this.project$1(lazyRef)));
    }

    public View download() {
        List ids = this.getLongIds("paper");
        if (ids.length() == 1) {
            Paper paper2 = (Paper)this.entityDao().get(Paper.class, ids.head());
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(paper2.filePath());
            HttpServletResponse response = ActionContext$.MODULE$.current().response();
            response.sendRedirect(((URL)path.get()).toString());
            return null;
        }
        scala.collection.immutable.Seq papers = this.entityDao().find(Paper.class, (Iterable)ids);
        Semester semester = ((Paper)papers.head()).semester();
        File dir = new File(SystemInfo$.MODULE$.tmpDir() + "/paper/" + semester.id());
        Files$.MODULE$.remove(dir);
        dir.mkdirs();
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        papers.foreach((Function1)(JProcedure1 & Serializable)paper -> {
            if (paper.filePath().startsWith("/")) {
                blob.url(paper.filePath()).foreach((Function1)(JProcedure1 & Serializable)url -> {
                    String stdName = StdNamePurifier$.MODULE$.purify(paper.writerNames());
                    String fileName = paper.writerCodes() + "_" + stdName + "." + Strings$.MODULE$.substringAfterLast(paper.filePath(), ".");
                    Object subjectName = paper.subject().name();
                    String subSubjectName = (String)paper.subSubjectName().getOrElse(PaperAction::$anonfun$1);
                    if (Strings$.MODULE$.isNotBlank((CharSequence)subSubjectName)) {
                        subjectName = (String)subjectName + ("-" + subSubjectName);
                    }
                    File subjectDir = new File(dir.getAbsolutePath() + ("/" + Files$.MODULE$.purify((String)subjectName)));
                    subjectDir.mkdirs();
                    String filePath = subjectDir.getAbsolutePath() + Files$.MODULE$.$div() + fileName;
                    this.downloading(url.openConnection(), new File(filePath));
                });
                return;
            }
        });
        File targetZip = new File(SystemInfo$.MODULE$.tmpDir() + "/paper/paper.zip");
        Zipper$.MODULE$.zip(dir, targetZip, Zipper$.MODULE$.zip$default$3());
        String fileName = semester.schoolYear() + "_" + semester.name() + " \u5b66\u672f\u8bba\u6587\u7ade\u8d5b" + (papers.size() + "\u7bc7.zip");
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    private void downloading(URLConnection c, File location) {
        HttpURLConnection conn = HttpUtils$.MODULE$.followRedirect(c, "GET");
        InputStream input = null;
        FileOutputStream output = null;
        try {
            try {
                File file = new File(location.toString() + ".part");
                file.delete();
                byte[] buffer = new byte[4096];
                input = conn.getInputStream();
                output = new FileOutputStream(file);
                int n = input.read(buffer);
                while (-1 != n) {
                    ((OutputStream)output).write(buffer, 0, n);
                    n = input.read(buffer);
                }
                IOs$.MODULE$.close((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
                input = null;
                output = null;
                file.renameTo(location);
            }
            catch (Throwable e) {
                Logger$.MODULE$.warn$extension(this.logger(), () -> PaperAction.downloading$$anonfun$1(location));
            }
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
            throw throwable;
        }
        IOs$.MODULE$.close((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
    }

    public OqlBuilder<Paper> getQueryBuilder() {
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        Option code = this.get("writer.std.code");
        Option name = this.get("writer.std.name");
        Option departId = this.getInt("writer.std.state.department.id");
        if (code.nonEmpty() || name.nonEmpty() || departId.nonEmpty()) {
            Buffer params = Collections$.MODULE$.newBuffer();
            Buffer q = Collections$.MODULE$.newBuffer();
            if (code.nonEmpty() && !((String)code.get()).isBlank()) {
                code.foreach((Function1 & Serializable)c -> {
                    String[] codes = Strings$.MODULE$.split(c);
                    if (codes.length == 0) {
                        q.addOne((Object)"w.std.code like :code");
                        return (Buffer)params.addOne((Object)("%" + code.get() + "%"));
                    }
                    q.addOne((Object)"w.std.code in (:codes)");
                    return (Buffer)params.addOne((Object)codes);
                });
            }
            if (name.nonEmpty() && !((String)name.get()).isBlank()) {
                q.addOne((Object)"w.std.name like :name");
                params.addOne((Object)("%" + name.get() + "%"));
            }
            if (departId.nonEmpty()) {
                q.addOne((Object)"w.std.state.department.id =:departId");
                params.addOne((Object)departId);
            }
            if (q.nonEmpty()) {
                Condition condition = new Condition("exists(from paper.writers as w where " + q.mkString(" and ") + ")", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                condition.params((Seq)params);
                query.where(condition);
            }
        }
        return query;
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final String $anonfun$1() {
        return "";
    }

    private static final String downloading$$anonfun$1(File location$1) {
        return "Cannot download file " + location$1;
    }
}

