/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.starter.web.support;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.security.Securities$;
import org.beangle.security.authc.Profile;
import org.beangle.security.authc.Profile$;
import org.beangle.web.action.annotation.ignore;
import org.beangle.web.action.support.ParamSupport;
import org.beangle.web.action.support.ServletSupport;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectPropertyService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.Code;
import org.openurp.code.service.CodeService;
import org.openurp.starter.web.helper.EmsCookieHelper;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface ProjectSupport
extends ParamSupport,
ServletSupport {
    public static void $init$(ProjectSupport $this) {
    }

    public EntityDao entityDao();

    public CodeService codeService();

    public void codeService_$eq(CodeService var1);

    public ProjectPropertyService projectPropertyService();

    public void projectPropertyService_$eq(ProjectPropertyService var1);

    public SemesterService semesterService();

    public void semesterService_$eq(SemesterService var1);

    public static Object getProjectProperty$(ProjectSupport $this, String name, Object defaultValue, Project project) {
        return $this.getProjectProperty(name, defaultValue, project);
    }

    default public <T> T getProjectProperty(String name, T defaultValue, Project project) {
        return (T)this.projectPropertyService().get(project, name, defaultValue);
    }

    public static Seq getCodes$(ProjectSupport $this, Class clazz, Project project) {
        return $this.getCodes(clazz, project);
    }

    default public <T extends Code> Seq<T> getCodes(Class<T> clazz, Project project) {
        return this.codeService().get(clazz);
    }

    public static scala.collection.immutable.Seq findInSchool$(ProjectSupport $this, Class clazz, Project project) {
        return $this.findInSchool(clazz, project);
    }

    default public <T extends Entity<?>> scala.collection.immutable.Seq<T> findInSchool(Class<T> clazz, Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(clazz, "aa");
        query.where("aa.school=:school", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project.school()}));
        query.orderBy("code");
        return this.entityDao().search((QueryBuilder)query);
    }

    public static Project getProject$(ProjectSupport $this) {
        return $this.getProject();
    }

    @ignore
    default public Project getProject() {
        return new EmsCookieHelper(this.entityDao()).getProject(this.request(), this.response());
    }

    public static scala.collection.immutable.Seq findInProject$(ProjectSupport $this, Class clazz, String orderBy, Project project) {
        return $this.findInProject(clazz, orderBy, project);
    }

    default public <T extends Entity<?>> scala.collection.immutable.Seq<T> findInProject(Class<T> clazz, String orderBy, Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(clazz, "aa");
        query.where("aa.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.orderBy(orderBy);
        return this.entityDao().search((QueryBuilder)query);
    }

    public static String findInProject$default$2$(ProjectSupport $this) {
        return $this.findInProject$default$2();
    }

    default public <T extends Entity<?>> String findInProject$default$2() {
        return "code";
    }

    public static void addDepart$(ProjectSupport $this, OqlBuilder query, String departPath) {
        $this.addDepart(query, departPath);
    }

    default public void addDepart(OqlBuilder<?> query, String departPath) {
        Option<String> option = this.getProfileDepartIds();
        if (None$.MODULE$.equals(option)) {
            query.where("1=2", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            return;
        }
        if (option instanceof Some) {
            String d;
            String string = d = (String)((Some)option).value();
            String string2 = Profile$.MODULE$.AllValue();
            if (string == null ? string2 != null : !string.equals(string2)) {
                scala.collection.immutable.Seq departIds = Strings$.MODULE$.splitToInt(d);
                if (departPath.endsWith(".id")) {
                    query.where(departPath + " in(:profile_depart_ids)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departIds}));
                    return;
                }
                query.where(departPath + ".id in(:profile_depart_ids)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departIds}));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public static List getDeparts$(ProjectSupport $this, Project project) {
        return $this.getDeparts(project);
    }

    default public List<Department> getDeparts(Project project) {
        Option<String> option = this.getProfileDepartIds();
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        if (option instanceof Some) {
            String d2;
            String string = d2 = (String)((Some)option).value();
            String string2 = Profile$.MODULE$.AllValue();
            scala.collection.immutable.Seq departs = !(string != null ? !string.equals(string2) : string2 != null) ? this.entityDao().getAll(Department.class) : this.entityDao().find(Department.class, (Iterable)Strings$.MODULE$.splitToInt(d2));
            Set pds = project.departments().toSet();
            LocalDate now = LocalDate.now();
            scala.collection.immutable.Seq rs = (scala.collection.immutable.Seq)departs.filter((Function1 & Serializable)d -> pds.contains(d) && (d.endOn().isEmpty() || !((LocalDate)d.endOn().get()).isAfter(now)));
            return rs.toList();
        }
        throw new MatchError(option);
    }

    private Option<String> getProfileDepartIds() {
        Option<Profile> option = new EmsCookieHelper(this.entityDao()).getProfile(this.request(), this.response());
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Profile p = (Profile)((Some)option).value();
            return p.getProperty("department");
        }
        throw new MatchError(option);
    }

    public static Semester getSemester$(ProjectSupport $this, Project project) {
        return $this.getSemester(project);
    }

    default public Semester getSemester(Project project) {
        Option option = this.getInt("semester.id");
        if (None$.MODULE$.equals(option)) {
            return this.semesterService().get(project, LocalDate.now());
        }
        if (option instanceof Some) {
            int id = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)id));
        }
        throw new MatchError((Object)option);
    }

    public static Object getUser$(ProjectSupport $this, Class clazz) {
        return $this.getUser(clazz);
    }

    default public <A> A getUser(Class<A> clazz) {
        Option option = this.getInt("project.id");
        if (None$.MODULE$.equals(option)) {
            OqlBuilder builder = OqlBuilder$.MODULE$.from(clazz, "s");
            builder.where("s.code=:code", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
            scala.collection.immutable.Seq stds = this.entityDao().search((QueryBuilder)builder);
            if (stds.size() == 1) {
                return (A)stds.head();
            }
            throw new RuntimeException("find more than one user for:" + Securities$.MODULE$.user() + ", project param needed.");
        }
        if (option instanceof Some) {
            int projectId = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            OqlBuilder builder = OqlBuilder$.MODULE$.from(clazz, "s");
            builder.where("s.project.id=:projectId and s.code=:code", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)projectId), Securities$.MODULE$.user()}));
            return (A)this.entityDao().search((QueryBuilder)builder).head();
        }
        throw new MatchError((Object)option);
    }
}

