/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.starter.web.support;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.model.NumId;
import org.beangle.security.Securities$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.ServletSupport;
import org.beangle.web.action.view.PathView;
import org.beangle.web.action.view.PathView$;
import org.beangle.web.action.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectPropertyService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.code.Code;
import org.openurp.code.service.CodeService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class StudentSupport
extends ActionSupport
implements ServletSupport {
    private EntityDao entityDao;
    private SemesterService semesterService;
    private CodeService codeService;
    private ProjectPropertyService projectPropertyService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public ProjectPropertyService projectPropertyService() {
        return this.projectPropertyService;
    }

    public void projectPropertyService_$eq(ProjectPropertyService x$1) {
        this.projectPropertyService = x$1;
    }

    public View index() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        scala.collection.immutable.Seq stds = this.entityDao().findBy(Student.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (stds.isEmpty()) {
            return this.forward("not-student");
        }
        if (stds.size() == 1) {
            return this.toProject((Student)stds.head());
        }
        Option option = this.getInt("projectId");
        if (None$.MODULE$.equals(option)) {
            scala.collection.immutable.Seq projects = (scala.collection.immutable.Seq)stds.map((Function1 & Serializable)_$5 -> _$5.project());
            this.put("projects", projects);
            this.request().setAttribute("defaultProjectId", ((NumId)projects.head()).id());
            return this.forward(this.forward$default$1());
        }
        if (option instanceof Some) {
            int pid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            Option option2 = stds.find((Function1 & Serializable)_$6 -> BoxesRunTime.unboxToInt((Object)_$6.project().id()) == pid);
            if (option2 instanceof Some) {
                Student s = (Student)((Some)option2).value();
                return this.toProject(s);
            }
            if (None$.MODULE$.equals(option2)) {
                return this.forward(this.forward$default$1());
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public View projectIndex(Student student) {
        return null;
    }

    public final Semester getSemester() {
        Option option = this.getInt("semester.id");
        if (None$.MODULE$.equals(option)) {
            return this.semesterService().get(this.getProject(), LocalDate.now());
        }
        if (option instanceof Some) {
            int id = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)id));
        }
        throw new MatchError((Object)option);
    }

    public final Project getProject() {
        Object project = this.request().getAttribute("project");
        if (project != null) {
            return (Project)project;
        }
        Option option = this.getInt("projectId");
        if (option instanceof Some) {
            int projectId = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            Project project2 = (Project)this.entityDao().get(Project.class, (Object)BoxesRunTime.boxToInteger((int)projectId));
            this.request().setAttribute("project", (Object)project2);
            return project2;
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError((Object)option);
    }

    public final Student getStudent() {
        Object std = this.request().getAttribute("student");
        if (std != null) {
            return (Student)std;
        }
        Project project = this.getProject();
        if (project == null) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
            return this.updateRequest((Option<Student>)this.entityDao().findBy(Student.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption());
        }
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)project);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Securities$.MODULE$.user());
        return this.updateRequest((Option<Student>)this.entityDao().findBy(Student.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption());
    }

    private Student updateRequest(Option<Student> stds) {
        Option<Student> option = stds;
        if (option instanceof Some) {
            Student std = (Student)((Some)option).value();
            this.request().setAttribute("student", (Object)std);
            this.request().setAttribute("project", (Object)std.project());
            return std;
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError(option);
    }

    private View toProject(Student student) {
        this.request().setAttribute("student", (Object)student);
        this.request().setAttribute("project", (Object)student.project());
        View view = this.projectIndex(student);
        if (view == null) {
            return this.forward("projectIndex");
        }
        if (view instanceof PathView) {
            String string;
            PathView pathView = (PathView)view;
            PathView pathView2 = PathView$.MODULE$.unapply(pathView);
            String p = string = pathView2._1();
            PathView v = pathView;
            if (p == null) {
                return this.forward("projectIndex");
            }
            return v;
        }
        if (view != null) {
            View r = view;
            return r;
        }
        throw new MatchError((Object)view);
    }

    public <T extends Code> Seq<T> getCodes(Class<T> clazz, Project project) {
        return this.codeService().get(clazz);
    }

    public <T extends Code> T getCode(Class<T> clazz, int id) {
        return (T)this.codeService().get(clazz, id);
    }

    public <T> T getProjectProperty(String name, T defaultValue, Project project) {
        return (T)this.projectPropertyService().get(project, name, defaultValue);
    }
}

