/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.starter.web.support;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.model.NumId;
import org.beangle.security.Securities$;
import org.beangle.web.action.context.Params$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.ServletSupport;
import org.beangle.web.action.view.PathView;
import org.beangle.web.action.view.PathView$;
import org.beangle.web.action.view.View;
import org.openurp.base.edu.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectPropertyService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.Code;
import org.openurp.code.service.CodeService;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class TeacherSupport
extends ActionSupport
implements ServletSupport {
    private EntityDao entityDao;
    private CodeService codeService;
    private SemesterService semesterService;
    private ProjectPropertyService projectPropertyService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public ProjectPropertyService projectPropertyService() {
        return this.projectPropertyService;
    }

    public void projectPropertyService_$eq(ProjectPropertyService x$1) {
        this.projectPropertyService = x$1;
    }

    public View index() {
        Teacher teacher = this.getTeacher();
        if (teacher == null) {
            return this.forward("not-teacher");
        }
        if (teacher.projects().isEmpty()) {
            return this.forward("empty-project");
        }
        if (teacher.projects().size() == 1) {
            LazyRef lazyRef = new LazyRef();
            return this.toProject(teacher, TeacherSupport.project$1(teacher, lazyRef));
        }
        Option option = Params$.MODULE$.getId("project", Integer.TYPE);
        if (None$.MODULE$.equals(option)) {
            this.request().setAttribute("defaultProjectId", ((NumId)teacher.projects().head()).id());
            return this.forward(this.forward$default$1());
        }
        if (option instanceof Some) {
            int pid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            Option option2 = teacher.projects().find((Function1 & Serializable)_$5 -> BoxesRunTime.unboxToInt((Object)_$5.id()) == pid);
            if (option2 instanceof Some) {
                Project p = (Project)((Some)option2).value();
                return this.toProject(teacher, TeacherSupport.project$2(p));
            }
            if (None$.MODULE$.equals(option2)) {
                return this.forward(this.forward$default$1());
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public View projectIndex(Teacher teacher, Project project) {
        return null;
    }

    public final Semester getSemester() {
        Option option = Params$.MODULE$.getId("semester", Integer.TYPE);
        if (None$.MODULE$.equals(option)) {
            return this.semesterService().get(this.getProject(), LocalDate.now());
        }
        if (option instanceof Some) {
            int id = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)id));
        }
        throw new MatchError((Object)option);
    }

    public final Project getProject() {
        Object project = this.request().getAttribute("project");
        if (project != null) {
            return (Project)project;
        }
        Option option = Params$.MODULE$.getId("project", Integer.TYPE);
        if (option instanceof Some) {
            int projectId = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            Project project2 = (Project)this.entityDao().get(Project.class, (Object)BoxesRunTime.boxToInteger((int)projectId));
            this.request().setAttribute("project", (Object)project2);
            return project2;
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError((Object)option);
    }

    public final Teacher getTeacher() {
        Object teacher = this.request().getAttribute("teacher");
        if (teacher != null) {
            return (Teacher)teacher;
        }
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"staff.code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        scala.collection.immutable.Seq teachers = this.entityDao().findBy(Teacher.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        teachers.foreach((Function1)(JProcedure1 & Serializable)t -> this.request().setAttribute("teacher", t));
        return (Teacher)teachers.headOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private View toProject(Teacher teacher, Project p) {
        this.request().setAttribute("project", (Object)p);
        this.request().setAttribute("teacher", (Object)teacher);
        View view = this.projectIndex(teacher, p);
        if (view == null) {
            return this.forward("projectIndex");
        }
        if (view instanceof PathView) {
            String string;
            PathView pathView = (PathView)view;
            PathView pathView2 = PathView$.MODULE$.unapply(pathView);
            String p2 = string = pathView2._1();
            PathView v = pathView;
            if (p2 == null) {
                return this.forward("projectIndex");
            }
            return v;
        }
        if (view != null) {
            View r = view;
            return r;
        }
        throw new MatchError((Object)view);
    }

    public <T extends Code> Seq<T> getCodes(Class<T> clazz, Project project) {
        return this.codeService().get(clazz);
    }

    public <T extends Code> T getCode(Class<T> clazz, int id) {
        return (T)this.codeService().get(clazz, id);
    }

    public <T> T getProjectProperty(String name, T defaultValue, Project project) {
        return (T)this.projectPropertyService().get(project, name, defaultValue);
    }

    private static final Project project$lzyINIT1$1(Teacher teacher$1, LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)((Project)teacher$1.projects().head())));
        }
        return project;
    }

    private static final Project project$1(Teacher teacher$2, LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : TeacherSupport.project$lzyINIT1$1(teacher$2, project$lzy1$2));
    }

    private static final Project project$2(Project p$1) {
        return p$1;
    }
}

