/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.starter.web.support;

import java.io.Serializable;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.model.NumId;
import org.beangle.security.Securities$;
import org.beangle.web.action.context.Params$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.ServletSupport;
import org.beangle.web.action.view.View;
import org.openurp.base.hr.model.Mentor;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.base.service.Feature;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.Code;
import org.openurp.code.service.CodeService;
import org.openurp.starter.web.support.SemesterHelper$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class MentorSupport
extends ActionSupport
implements ServletSupport {
    private EntityDao entityDao;
    private CodeService codeService;
    private SemesterService semesterService;
    private ProjectConfigService configService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public View index() {
        Mentor mentor = this.getMentor();
        if (mentor == null) {
            return this.forward("not-mentor");
        }
        if (mentor.projects().isEmpty()) {
            return this.forward("empty-project");
        }
        LazyRef lazyRef = new LazyRef();
        List projects = (List)mentor.projects().toList().sortBy((Function1 & Serializable)_$5 -> _$5.code(), (Ordering)Ordering.String$.MODULE$);
        int projectId = this.getInt("projectId", BoxesRunTime.unboxToInt((Object)((NumId)projects.head()).id()));
        this.put("projects", projects);
        this.put("project", MentorSupport.project$1(lazyRef, mentor, projectId, projects));
        this.put("mentor", mentor);
        return this.projectIndex(mentor, MentorSupport.project$1(lazyRef, mentor, projectId, projects));
    }

    public View projectIndex(Mentor mentor, Project project) {
        return this.forward(this.forward$default$1());
    }

    public final Semester getSemester() {
        return SemesterHelper$.MODULE$.getSemester(this.entityDao(), this.semesterService(), this.getProject(), this.request(), this.response());
    }

    public final Project getProject() {
        Object project = this.request().getAttribute("project");
        if (project != null) {
            return (Project)project;
        }
        Option option = Params$.MODULE$.getId("project", Integer.TYPE);
        if (option instanceof Some) {
            int projectId = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            Project project2 = (Project)this.entityDao().get(Project.class, (Object)BoxesRunTime.boxToInteger((int)projectId));
            this.request().setAttribute("project", (Object)project2);
            return project2;
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError((Object)option);
    }

    public final Mentor getMentor() {
        Object mentor = this.request().getAttribute("mentor");
        if (mentor != null) {
            return (Mentor)mentor;
        }
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"staff.code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        scala.collection.immutable.Seq mentors = this.entityDao().findBy(Mentor.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        mentors.foreach((Function1)(JProcedure1 & Serializable)t -> this.request().setAttribute("mentor", t));
        return (Mentor)mentors.headOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public final User getUser() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        return (User)this.entityDao().findBy(User.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head();
    }

    public <T extends Code> Seq<T> getCodes(Class<T> clazz, Project project) {
        return this.codeService().get(clazz);
    }

    public <T extends Code> T getCode(Class<T> clazz, int id) {
        return (T)this.codeService().get(clazz, id);
    }

    public <T> T getConfig(String name, T defaultValue, Project project) {
        return (T)this.configService().get(project, name, defaultValue);
    }

    public Object getConfig(Feature f, Project project) {
        return this.configService().get(project, f);
    }

    private static final Project project$lzyINIT1$1$$anonfun$2(List projects$2) {
        return (Project)projects$2.head();
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, Mentor mentor$1, int projectId$1, List projects$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)((Project)mentor$1.projects().find((Function1 & Serializable)_$6 -> BoxesRunTime.unboxToInt((Object)_$6.id()) == projectId$1).getOrElse(() -> MentorSupport.project$lzyINIT1$1$$anonfun$2(projects$1)))));
        }
        return project;
    }

    private static final Project project$1(LazyRef project$lzy1$2, Mentor mentor$2, int projectId$3, List projects$3) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : MentorSupport.project$lzyINIT1$1(project$lzy1$2, mentor$2, projectId$3, projects$3));
    }
}

