/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.starter.web.helper;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.web.EmsCookie;
import org.beangle.ems.app.web.EmsCookie$;
import org.beangle.security.Securities$;
import org.beangle.security.authc.DefaultAccount;
import org.beangle.security.authc.Profile;
import org.beangle.security.session.Session;
import org.openurp.base.model.Project;
import org.openurp.base.model.School;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class EmsCookieHelper {
    private final EntityDao entityDao;

    public EmsCookieHelper(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public School getSchool(HttpServletRequest req, HttpServletResponse res) {
        Option<School> option = this.findSchoolByServerName(req);
        if (option instanceof Some) {
            School s = (School)((Some)option).value();
            return s;
        }
        if (None$.MODULE$.equals(option)) {
            EmsCookie cookie = EmsCookie$.MODULE$.get(req, res);
            Option option2 = Securities$.MODULE$.session();
            if (option2 instanceof Some) {
                Session s = (Session)((Some)option2).value();
                DefaultAccount account = (DefaultAccount)s.principal();
                Profile profile = null;
                if (account.profiles() != null && account.profiles().length > 0) {
                    if (cookie.profile() == 0L) {
                        profile = account.profiles()[0];
                    } else {
                        Object object = Predef$.MODULE$.refArrayOps((Object[])account.profiles());
                        profile = (Profile)ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)p -> p.id() == cookie.profile()).getOrElse(() -> EmsCookieHelper.getSchool$$anonfun$2(account));
                    }
                    if (profile.id() != cookie.profile()) {
                        cookie.profile_$eq(profile.id());
                        EmsCookie$.MODULE$.update(req, res, cookie, true);
                    }
                }
                if (profile == null) {
                    return this.getFirstSchool();
                }
                String pstr = (String)profile.getProperty("school").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                if (pstr != null) {
                    String string = pstr;
                    String string2 = "*";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return this.getFirstSchool();
                    }
                    if (Numbers$.MODULE$.isDigits(pstr)) {
                        return (School)this.entityDao.get(School.class, (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(pstr))));
                    }
                    return null;
                }
                return this.getFirstSchool();
            }
            if (None$.MODULE$.equals(option2)) {
                return null;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    private Option<School> findSchoolByServerName(HttpServletRequest request) {
        OqlBuilder oqlBuilder = (OqlBuilder)OqlBuilder$.MODULE$.from(School.class, "p").where("p.code =:pcode", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{request.getServerName()}));
        OqlBuilder builder = (OqlBuilder)oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        return this.entityDao.search((QueryBuilder)builder).headOption();
    }

    private School getFirstSchool() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(School.class, "p");
        query.where("p.endOn is null or p.endOn > :today", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        OqlBuilder oqlBuilder = (OqlBuilder)query.orderBy("p.code");
        oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        return (School)this.entityDao.search((QueryBuilder)query).head();
    }

    public Project getProject(HttpServletRequest req, HttpServletResponse res) {
        Option<Profile> option = this.getProfile(req, res);
        if (option instanceof Some) {
            Profile p = (Profile)((Some)option).value();
            String pstr = (String)p.getProperty("project").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (pstr != null) {
                String string = pstr;
                String string2 = "*";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return this.getFirstProject();
                }
                if (Numbers$.MODULE$.isDigits(pstr)) {
                    return (Project)this.entityDao.get(Project.class, (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(pstr))));
                }
                return null;
            }
            return this.getFirstProject();
        }
        if (None$.MODULE$.equals(option)) {
            if (Securities$.MODULE$.session().isDefined()) {
                return this.getFirstProject();
            }
            return null;
        }
        throw new MatchError(option);
    }

    public Option<Profile> getProfile(HttpServletRequest req, HttpServletResponse res) {
        Option option = Securities$.MODULE$.session();
        if (option instanceof Some) {
            Session s = (Session)((Some)option).value();
            DefaultAccount account = (DefaultAccount)s.principal();
            Profile profile = null;
            if (account.profiles() != null && account.profiles().length > 0) {
                EmsCookie cookie = EmsCookie$.MODULE$.get(req, res);
                if (cookie.profile() == 0L) {
                    profile = account.profiles()[0];
                } else {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])account.profiles());
                    profile = (Profile)ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)p -> p.id() == cookie.profile()).getOrElse(() -> EmsCookieHelper.getProfile$$anonfun$2(account));
                }
                if (profile.id() != cookie.profile()) {
                    cookie.profile_$eq(profile.id());
                    EmsCookie$.MODULE$.update(req, res, cookie, true);
                }
            }
            return Option$.MODULE$.apply(profile);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private Project getFirstProject() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Project.class, "p");
        query.where("p.endOn is null or p.endOn > :today", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        OqlBuilder oqlBuilder = (OqlBuilder)query.orderBy("p.code");
        oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        return (Project)this.entityDao.search((QueryBuilder)query).head();
    }

    private static final Profile getSchool$$anonfun$2(DefaultAccount account$1) {
        return account$1.profiles()[0];
    }

    private static final Profile getProfile$$anonfun$2(DefaultAccount account$2) {
        return account$2.profiles()[0];
    }
}

