/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.starter.web.support;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.security.Securities$;
import org.beangle.security.authc.DefaultAccount;
import org.beangle.security.authc.Profile;
import org.beangle.security.authc.Profile$;
import org.beangle.security.session.Session;
import org.beangle.web.action.annotation.ignore;
import org.beangle.web.action.support.ParamSupport;
import org.beangle.web.action.support.ServletSupport;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.ProjectBased;
import org.openurp.base.model.Semester;
import org.openurp.base.service.Feature;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.code.Code;
import org.openurp.code.service.CodeService;
import org.openurp.starter.web.helper.EmsCookieHelper;
import org.openurp.starter.web.support.SemesterHelper$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface ProjectSupport
extends ParamSupport,
ServletSupport {
    public static void $init$(ProjectSupport $this) {
    }

    public EntityDao entityDao();

    public CodeService codeService();

    public void codeService_$eq(CodeService var1);

    public ProjectConfigService configService();

    public void configService_$eq(ProjectConfigService var1);

    public SemesterService semesterService();

    public void semesterService_$eq(SemesterService var1);

    public static Object getConfig$(ProjectSupport $this, String name, Object defaultValue, Project project) {
        return $this.getConfig(name, defaultValue, project);
    }

    default public <T> T getConfig(String name, T defaultValue, Project project) {
        return (T)this.configService().get(project, name, defaultValue);
    }

    public static Object getConfig$(ProjectSupport $this, Feature f, Project project) {
        return $this.getConfig(f, project);
    }

    default public Object getConfig(Feature f, Project project) {
        return this.configService().get(project, f, ClassTag$.MODULE$.Any());
    }

    public static Seq getCodes$(ProjectSupport $this, Class clazz, Project project) {
        return $this.getCodes(clazz, project);
    }

    default public <T extends Code> Seq<T> getCodes(Class<T> clazz, Project project) {
        return this.codeService().get(clazz);
    }

    public static scala.collection.immutable.Seq findInSchool$(ProjectSupport $this, Class clazz, Project project) {
        return $this.findInSchool(clazz, project);
    }

    default public <T extends Entity<?>> scala.collection.immutable.Seq<T> findInSchool(Class<T> clazz, Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(clazz, "aa");
        query.where("aa.school=:school", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project.school()}));
        query.orderBy("code");
        return this.entityDao().search((QueryBuilder)query);
    }

    public static Project getProject$(ProjectSupport $this) {
        return $this.getProject();
    }

    @ignore
    default public Project getProject() {
        Option option = Securities$.MODULE$.session();
        if (option instanceof Some) {
            Session s = (Session)((Some)option).value();
            DefaultAccount account = (DefaultAccount)s.principal();
            if (account.profiles() != null && account.profiles().length > 0) {
                return new EmsCookieHelper(this.entityDao()).getProject(this.request(), this.response());
            }
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
            scala.collection.immutable.Seq stds = this.entityDao().findBy(Student.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            if (stds.nonEmpty()) {
                return ((ProjectBased)stds.head()).project();
            }
            Object[] objectArray2 = new Tuple2[1];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"staff.code");
            objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Securities$.MODULE$.user());
            scala.collection.immutable.Seq teachers = this.entityDao().findBy(Teacher.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            if (teachers.nonEmpty()) {
                if (((Teacher)teachers.head()).projects().nonEmpty()) {
                    return (Project)((Teacher)teachers.head()).projects().head();
                }
                return this.getFirstProject();
            }
            return this.getFirstProject();
        }
        if (None$.MODULE$.equals(option)) {
            return this.getFirstProject();
        }
        throw new MatchError((Object)option);
    }

    public static scala.collection.immutable.Seq findInProject$(ProjectSupport $this, Class clazz, String orderBy, Project project) {
        return $this.findInProject(clazz, orderBy, project);
    }

    default public <T extends Entity<?>> scala.collection.immutable.Seq<T> findInProject(Class<T> clazz, String orderBy, Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(clazz, "aa");
        query.where("aa.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.orderBy(orderBy);
        return this.entityDao().search((QueryBuilder)query);
    }

    public static String findInProject$default$2$(ProjectSupport $this) {
        return $this.findInProject$default$2();
    }

    default public <T extends Entity<?>> String findInProject$default$2() {
        return "code";
    }

    public static OqlBuilder queryByDepart$(ProjectSupport $this, OqlBuilder query, String departPath) {
        return $this.queryByDepart(query, departPath);
    }

    default public <T> OqlBuilder<T> queryByDepart(OqlBuilder<T> query, String departPath) {
        Option<String> option = this.getProfileDepartIds();
        if (None$.MODULE$.equals(option)) {
            v0 = query.where("1=2", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        } else if (option instanceof Some) {
            String d;
            String string = d = (String)((Some)option).value();
            String string2 = Profile$.MODULE$.AllValue();
            if (string == null ? string2 != null : !string.equals(string2)) {
                scala.collection.immutable.Seq departIds = Strings$.MODULE$.splitToInt(d);
                if (departPath.endsWith(".id")) {
                    query.where(departPath + " in(:profile_depart_ids)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departIds}));
                    v0 = BoxedUnit.UNIT;
                } else {
                    query.where(departPath + ".id in(:profile_depart_ids)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departIds}));
                    v0 = BoxedUnit.UNIT;
                }
            } else {
                v0 = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError(option);
        }
        return query;
    }

    public static scala.collection.immutable.Seq getDeparts$(ProjectSupport $this, Project project) {
        return $this.getDeparts(project);
    }

    default public scala.collection.immutable.Seq<Department> getDeparts(Project project) {
        Option<String> option = this.getProfileDepartIds();
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        if (option instanceof Some) {
            String d2 = (String)((Some)option).value();
            OqlBuilder q = OqlBuilder$.MODULE$.from(Department.class, "d");
            q.where("d.school=:school", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project.school()}));
            q.cacheable(q.cacheable$default$1());
            scala.collection.immutable.Seq departs = this.entityDao().search((QueryBuilder)q);
            String string = d2;
            String string2 = Profile$.MODULE$.AllValue();
            Set ids = !(string != null ? !string.equals(string2) : string2 != null) ? Predef$.MODULE$.Set().empty() : Strings$.MODULE$.splitToInt(d2).toSet();
            LocalDate now = LocalDate.now();
            Set pds = project.departments().toSet();
            return (scala.collection.immutable.Seq)departs.filter((Function1 & Serializable)d -> !(!pds.contains(d) || !ids.isEmpty() && !ids.contains(d.id()) || !d.endOn().isEmpty() && ((LocalDate)d.endOn().get()).isAfter(now)));
        }
        throw new MatchError(option);
    }

    public static scala.collection.immutable.Seq getSchoolDeparts$(ProjectSupport $this, Project project) {
        return $this.getSchoolDeparts(project);
    }

    default public scala.collection.immutable.Seq<Department> getSchoolDeparts(Project project) {
        Option<String> option = this.getProfileDepartIds();
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        if (option instanceof Some) {
            String d2 = (String)((Some)option).value();
            OqlBuilder q = OqlBuilder$.MODULE$.from(Department.class, "d");
            q.where("d.school=:school", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project.school()}));
            q.cacheable(q.cacheable$default$1());
            scala.collection.immutable.Seq departs = this.entityDao().search((QueryBuilder)q);
            String string = d2;
            String string2 = Profile$.MODULE$.AllValue();
            Set ids = !(string != null ? !string.equals(string2) : string2 != null) ? Predef$.MODULE$.Set().empty() : Strings$.MODULE$.splitToInt(d2).toSet();
            LocalDate now = LocalDate.now();
            return (scala.collection.immutable.Seq)departs.filter((Function1 & Serializable)d -> !(!ids.isEmpty() && !ids.contains(d.id()) || !d.endOn().isEmpty() && ((LocalDate)d.endOn().get()).isAfter(now)));
        }
        throw new MatchError(option);
    }

    private Option<String> getProfileDepartIds() {
        Option<Profile> option = new EmsCookieHelper(this.entityDao()).getProfile(this.request(), this.response());
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Profile p = (Profile)((Some)option).value();
            return p.getProperty("department");
        }
        throw new MatchError(option);
    }

    public static Semester getSemester$(ProjectSupport $this, Project project) {
        return $this.getSemester(project);
    }

    default public Semester getSemester(Project project) {
        return SemesterHelper$.MODULE$.getSemester(this.entityDao(), this.semesterService(), project, this.request(), this.response());
    }

    public static Object getUser$(ProjectSupport $this, Class clazz) {
        return $this.getUser(clazz);
    }

    default public <A> A getUser(Class<A> clazz) {
        Option option = this.getInt("project.id");
        if (None$.MODULE$.equals(option)) {
            OqlBuilder builder = OqlBuilder$.MODULE$.from(clazz, "s");
            builder.where("s.code=:code", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
            scala.collection.immutable.Seq stds = this.entityDao().search((QueryBuilder)builder);
            if (stds.size() == 1) {
                return (A)stds.head();
            }
            throw new RuntimeException("find more than one user for:" + Securities$.MODULE$.user() + ", project param needed.");
        }
        if (option instanceof Some) {
            int projectId = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            OqlBuilder builder = OqlBuilder$.MODULE$.from(clazz, "s");
            builder.where("s.project.id=:projectId and s.code=:code", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)projectId), Securities$.MODULE$.user()}));
            return (A)this.entityDao().search((QueryBuilder)builder).head();
        }
        throw new MatchError((Object)option);
    }

    private Project getFirstProject() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Project.class, "p");
        query.where("p.endOn is null or p.endOn > :today", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        OqlBuilder oqlBuilder = (OqlBuilder)query.orderBy("p.code");
        oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        return (Project)this.entityDao().search((QueryBuilder)query).head();
    }
}

