/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.starter.web.support;

import java.io.Serializable;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.model.NumId;
import org.beangle.security.Securities$;
import org.beangle.webmvc.support.ActionSupport;
import org.beangle.webmvc.support.ServletSupport;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.base.service.Feature;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.code.Code;
import org.openurp.code.service.CodeService;
import org.openurp.starter.web.support.SemesterHelper$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public abstract class StudentSupport
extends ActionSupport
implements ServletSupport {
    private EntityDao entityDao;
    private SemesterService semesterService;
    private CodeService codeService;
    private ProjectConfigService configService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public final View index() {
        ObjectRef stds = ObjectRef.create(this.getStudents());
        if (((scala.collection.immutable.Seq)stds.elem).isEmpty()) {
            return this.forward("not-student");
        }
        long stdId = BoxesRunTime.unboxToLong((Object)this.getLong("studentId").getOrElse(() -> StudentSupport.$anonfun$1(stds)));
        Student student = (Student)((scala.collection.immutable.Seq)stds.elem).find((Function1 & Serializable)_$5 -> BoxesRunTime.unboxToLong((Object)_$5.id()) == stdId).getOrElse(() -> StudentSupport.$anonfun$3(stds));
        this.put("students", (scala.collection.immutable.Seq)stds.elem);
        this.put("student", student);
        this.put("project", student.project());
        return this.projectIndex(student);
    }

    public View projectIndex(Student student) {
        return this.forward(this.forward$default$1());
    }

    public final Semester getSemester() {
        return SemesterHelper$.MODULE$.getSemester(this.entityDao(), this.semesterService(), this.getProject(), this.request(), this.response());
    }

    public final Project getProject() {
        Object project = this.request().getAttribute("project");
        if (project != null) {
            return (Project)project;
        }
        return this.getStudent().project();
    }

    public final scala.collection.immutable.Seq<Student> getStudents() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        Option option = this.entityDao().findBy(User.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption();
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        if (option instanceof Some) {
            User user = (User)((Some)option).value();
            Object[] objectArray2 = new Tuple2[1];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"user");
            objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)user);
            scala.collection.immutable.Seq stds = this.entityDao().findBy(Student.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            if (stds.size() > 1) {
                scala.collection.immutable.Seq actives = (scala.collection.immutable.Seq)stds.filter((Function1 & Serializable)_$6 -> _$6.project().active());
                if (actives.nonEmpty()) {
                    stds = actives;
                }
                stds = (scala.collection.immutable.Seq)((SeqOps)stds.sortBy((Function1 & Serializable)_$7 -> _$7.beginOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse();
            }
            return stds;
        }
        throw new MatchError((Object)option);
    }

    public final Student getStudent() {
        Student student;
        Object std = this.request().getAttribute("student");
        if (std != null) {
            return (Student)std;
        }
        scala.collection.immutable.Seq<Student> stds = this.getStudents();
        if (stds.isEmpty()) {
            throw new RuntimeException(Securities$.MODULE$.user() + " is not a student");
        }
        Option option = this.getLong("projectId");
        if (None$.MODULE$.equals(option)) {
            long stdId = BoxesRunTime.unboxToLong((Object)this.getLong("studentId").getOrElse(() -> StudentSupport.$anonfun$5(stds)));
            student = (Student)stds.find((Function1 & Serializable)_$8 -> BoxesRunTime.unboxToLong((Object)_$8.id()) == stdId).getOrElse(() -> StudentSupport.$anonfun$7(stds));
        } else if (option instanceof Some) {
            long projectId = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            student = (Student)stds.find((Function1 & Serializable)_$9 -> (long)BoxesRunTime.unboxToInt((Object)_$9.project().id()) == projectId).getOrElse(() -> StudentSupport.$anonfun$9(stds));
        } else {
            throw new MatchError((Object)option);
        }
        Student student2 = student;
        this.request().setAttribute("student", (Object)student2);
        this.request().setAttribute("project", (Object)student2.project());
        return student2;
    }

    public final User getUser() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        return (User)this.entityDao().findBy(User.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head();
    }

    public <T extends Code> Seq<T> getCodes(Class<T> clazz, Project project) {
        return this.codeService().get(clazz);
    }

    public <T extends Code> T getCode(Class<T> clazz, int id) {
        return (T)this.codeService().get(clazz, id);
    }

    public <T> T getConfig(String name, T defaultValue, Project project) {
        return (T)this.configService().get(project, name, defaultValue);
    }

    public Object getConfig(Feature f, Project project) {
        return this.configService().get(project, f, ClassTag$.MODULE$.Any());
    }

    private static final long $anonfun$1(ObjectRef stds$1) {
        return BoxesRunTime.unboxToLong((Object)((NumId)((scala.collection.immutable.Seq)stds$1.elem).head()).id());
    }

    private static final Student $anonfun$3(ObjectRef stds$2) {
        return (Student)((scala.collection.immutable.Seq)stds$2.elem).head();
    }

    private static final long $anonfun$5(scala.collection.immutable.Seq stds$3) {
        return BoxesRunTime.unboxToLong((Object)((NumId)stds$3.head()).id());
    }

    private static final Student $anonfun$7(scala.collection.immutable.Seq stds$4) {
        return (Student)stds$4.head();
    }

    private static final Student $anonfun$9(scala.collection.immutable.Seq stds$5) {
        return (Student)stds$5.head();
    }
}

