/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractService.java 2587 2006-05-09 09:15:59Z jmettraux $
 */

//
// AbstractService.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org;

import openwfe.org.state.ServiceState;
import openwfe.org.state.ServiceStateHelper;


/**
 * A classical service, Service with particular needs should extend
 * this class.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-05-09 11:15:59 +0200 (Tue, 09 May 2006) $
 * <br>$Id: AbstractService.java 2587 2006-05-09 09:15:59Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractService

    implements RunnableService

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractService.class.getName());

    //
    // CONSTANTS (definitions)

    //
    // FIELDS

    private String name = null;
    private ApplicationContext context = null;
    private java.util.Map serviceParams = null;

    private ServiceStateHelper serviceStateHelper = null;

    //
    // CONSTRUCTORS

    //
    // METHODS from Service

    /**
     * will get overriden by child RemoteService
     */
    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        this.name = serviceName;
        this.context = context;
        this.serviceParams = serviceParams;

        this.serviceStateHelper = new ServiceStateHelper(serviceName);
    }

    /**
     * If the service is not running, will start it.
     */
    public void play ()
        throws ServiceException
    {
        this.serviceStateHelper.play();
    }

    /**
     * If the service is running, will pause it.
     */
    public void pause ()
        throws ServiceException
    {
        this.serviceStateHelper.pause();
    }

    /**
     * Stops the service
     */
    public void stop ()
        throws ServiceException
    {
        this.serviceStateHelper.stop();
    }

    /**
     * Tells the service to update
     */
    public void update ()
        throws ServiceException
    {
        this.serviceStateHelper.update();
    }

    /**
     * Returns a ServiceState instance which tells if the service is running,
     * paused or stopped and since when. Other ServiceState implementations
     * may also be returned of course.
     */
    public ServiceState getState () 
    {
        return this.serviceStateHelper.getState();
    }

    /**
     * Protected : sets the state of the service.
     */
    protected void setState (final ServiceState state)
    {
        this.serviceStateHelper.setState(state);
    }

    /**
     * Returns the name associated to this service (usually found in the
     * XML configuration file describing the services).
     */
    public String getName ()
    {
        return this.name;
    }

    /**
     * Returns the context to which this service belongs.
     */
    public ApplicationContext getContext ()
    {
        return this.context;
    }

    /**
     * Returns the params passed to this service for its initialization.
     */
    public java.util.Map getParams ()
    {
        return java.util.Collections.unmodifiableMap(this.serviceParams);
    }

    /**
     * Returns the status (not the state) of this service.
     */
    public org.jdom.Element getStatus ()
    {
        String sName = this.name.replaceAll(":", "_");
        return new org.jdom.Element(sName);
    }

    /**
     * Returns true if the service is in the RunningState ServiceState.
     */
    public boolean isRunning ()
    {
        return this.serviceStateHelper.isRunning();
    }

    //
    // METHODS

}
