/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Grant.java 2494 2006-04-15 21:15:08Z jmettraux $
 */

//
// Grant.java
//
// jmettraux@openwfe.org
//
// made in the CreveCoeur
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//
// un bout a t fait au "Petit Ble" de Payerne
//

package openwfe.org.auth;

import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.PermissionCollection;
import java.security.cert.Certificate;

import openwfe.org.Utils;


/**
 * A domain is the association between a codebase and a set of permissions
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-04-15 23:15:08 +0200 (Sat, 15 Apr 2006) $
 * <br>$Id: Grant.java 2494 2006-04-15 21:15:08Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class Grant

    implements java.io.Serializable

{

    static final long serialVersionUID = -5673871754297625108L;

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Grant.class.getName());

    //
    // CONSTANTS & co

    public final static String NAME = "name";
    public final static String LOCATION = "location";
    public final static String CODE_SOURCE = "codeSource";

    //
    // FIELDS

    protected String name = null;
    protected String url = null;
    protected CodeSource codeSource = null;
    protected java.util.Map permissionMap = null;

    //
    // CONSTRUCTORS

    public Grant ()
    {
        this.permissionMap = new java.util.HashMap(7);
    }

    public Grant 
        (final String name, 
         final String url) 
    throws
        java.net.MalformedURLException
    {
        this(name, url, new java.util.HashSet(7));
    }

    public Grant 
        (final String name, 
         final String url, 
         final java.util.Set permissions)
    throws
        java.net.MalformedURLException
    {
        this.name = name;
        this.url = url;

        final Certificate[] certs = null;

        //log.debug("() url was  >"+this.url+"<");

        this.url = openwfe.org.misc.Text
            .substitute(this.url, System.getProperties());

        //log.debug("() url is   >"+this.url+"<");

        this.codeSource = 
            new CodeSource(new java.net.URL(Utils.expandUrl(this.url)), certs);

        this.permissionMap = new java.util.HashMap(permissions.size());
        java.util.Iterator it = permissions.iterator();
        while (it.hasNext()) addPermission((Permission)it.next());
    }

    public void init (final java.util.Map initParams)
        throws AuthException
    {
        this.name = (String)initParams.get(NAME);

        if (this.name == null)
        {
            throw new AuthException
                ("Parameter '"+NAME+"' is mandatory");
        }

        try
        {
            this.url = (String)initParams.get(CODE_SOURCE);

            if (this.url == null)
                this.url = (String)initParams.get(LOCATION);

            log.debug("init() url is >"+this.url+"<");

            final Certificate[] certs = null;

            this.codeSource = new CodeSource
                (new java.net.URL(Utils.expandUrl(this.url)), certs);
        }
        catch (Exception e)
        {
            throw new AuthException
                ("Failed to determine '"+CODE_SOURCE+"'", e);
        }
    }

    //
    // METHODS

    public String getName () 
    { 
        return this.name; 
    }

    public String getUrl () 
    { 
        return this.url;
    }

    public String getLocation ()
    {
        return this.codeSource.getLocation().toString();
    }

    public boolean codeSourceImplies (CodeSource cs)
    {
        return this.codeSource.implies(cs);
    }

    public PermissionCollection getPermissions ()
    {
        PermissionCollection result = new Permissions();
        java.util.Iterator it = this.permissionMap.values().iterator();
        while (it.hasNext())
        {
            java.security.Permission p = (java.security.Permission)it.next();

            //log.debug("getPermissions() adding "+p.toString());

            result.add(p);
        }
        return result;
    }

    /*
     * for our dear jsp hackers
     */
    public java.util.Collection getPermissionValues ()
    {
        return this.permissionMap.values();
    }

    public CodeSource getCodeSource ()
    {
        return this.codeSource;
    }

    public void addPermission (Permission p)
    {
        this.permissionMap.put(computeKey(p), p);

        //log.debug("addPermission() added key "+computeKey(p)+" --> "+p);
    }

    public void removePermission (String key)
    {
        Object p = this.permissionMap.remove(key);

        //log.debug("\nRemoved key\n"+key+"\n"+p);
    }

    public Permission getPermission (String key)
    {
        return 
            (Permission)this.permissionMap.get(key);
    }

    /**
     * Computes a key for any Permission instance
     */
    public static String computeKey (Permission p)
    {
        StringBuffer sb = new StringBuffer();

        sb.append(p.getClass().getName());
        sb.append("::");
        sb.append(p.hashCode());

        return sb.toString();
    }

}
