/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: TrivialLoginModule.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// TrivialLoginModule.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.auth;

import javax.security.auth.login.LoginException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;


/**
 * A login module for TrivialCallbackHandler, so a login module
 * that doesn't care about the password of the user 
 * (Password is a zero-length string)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: TrivialLoginModule.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class TrivialLoginModule

    extends LoginModule

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(TrivialLoginModule.class.getName());

    //
    // CONSTANTS and definitions

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    public boolean login () 
        throws LoginException
    {
        if (this.policyService == null)
        {
            throw new LoginException
                ("No policy service. "+
                 "Check application log for details");
        }

        //
        // prompt for username and password
        
        NameCallback nameCb = new NameCallback("username");

        try
        {
            this.handler.handle(new Callback[] { nameCb });
        }
        catch (Exception e)
        {
            log.debug
                ("Failed to gather user credentials", e);
            throw new LoginException
                ("Failed to gather user credentials");
        }

        //
        // get name and pass
        
        String userName = nameCb.getName();
        String pass = "";

        //
        // allow or deny

        this.principal = null;
        try
        {
            this.principal = this.policyService.authentify(userName, pass);

            //log.debug("Login success for\n"+this.principal.toString());
        }
        catch (AuthException ae)
        {
            log.info
                ("LoginException : Failed to authentify user", ae);
            throw new LoginException
                ("Failed to authentify user because of \""+ae+"\"");
        }

        this.succeeded = (this.principal != null);

        return this.succeeded;
    }

}
