/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlPrincipalCodec.java 2247 2005-11-30 09:19:53Z jmettraux $
 */

//
// XmlPrincipalCodec.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.auth.xml;

import openwfe.org.Parameters;
import openwfe.org.ReflectionUtils;
import openwfe.org.ApplicationContext;
import openwfe.org.auth.Principal;
import openwfe.org.auth.PrincipalCodec;
import openwfe.org.auth.AuthException;


/**
 * A unique PrincipalCodec for the standard passwd.xml 
 * (and for all openwfe Principal derived classes)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlPrincipalCodec.java 2247 2005-11-30 09:19:53Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlPrincipalCodec

    implements PrincipalCodec

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlPrincipalCodec.class.getName());
    */

    //
    // CONSTANTS & co

    public final static String E_PRINCIPAL = "principal";

    public final static String A_CLASS = "class";
    public final static String A_NAME = "name";

    public final static String E_GRANT = "grant";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from PrincipalCodec

    /**
     * Turns a principal into an XML element (org.jdom.Element)
     */
    public Object encodePrincipal 
        (final Principal p,
         final ApplicationContext context,
         final java.util.Map serviceParams)
    throws 
        AuthException
    {
        //
        // encode principal

        final org.jdom.Element ePrincipal = new org.jdom.Element(E_PRINCIPAL);

        //java.util.Map params = new java.util.HashMap
        //    (p.getInitParameters().size()+1);
        final java.util.Map params = new java.util.HashMap();

        if (p.getInitParameters() != null)
            params.putAll(p.getInitParameters());

        params.put(A_CLASS, p.getClass().getName());

        Parameters.encodeAsAttributes(ePrincipal, params);

        //
        // encode grants

        final java.util.Iterator it = p.getGrants().iterator();
        while (it.hasNext())
        {
            String grantName = (String)it.next();
            org.jdom.Element eGrant = new org.jdom.Element(E_GRANT);
            eGrant.setAttribute(A_NAME, grantName);

            ePrincipal.addContent(eGrant);
        }

        return ePrincipal;
    }

    /**
     * Turns something (Object o) into a Principal instance
     */
    public Principal decodePrincipal 
        (ApplicationContext context,
         Object o)
    throws 
        AuthException
    {
        //
        // initial controls

        org.jdom.Element elt = null;
        try
        {
            elt = (org.jdom.Element)o;
        }
        catch (ClassCastException cce)
        {
            throw new AuthException
                ("Cannot decode Principal from class "+o.getClass(), cce);
        }

        if (elt == null || !elt.getName().equals(E_PRINCIPAL))
        {
            throw new AuthException
                ("null XML element or not a <"+E_PRINCIPAL+">");
        }

        //
        // OK, let's do the job
        
        Principal principal = null;

        final java.util.Map params = Parameters.extractAttributes(elt);

        final String className = (String)params.get(A_CLASS);

        // decode principal

        try
        {
            principal = (Principal)ReflectionUtils
                .initObjectOfClass(className, params);
        }
        catch (final Exception e)
        {
            throw new AuthException
                ("failed to build Principal of class "+className, e);
        }

        // decode grants

        final java.util.Iterator it = elt.getChildren(E_GRANT).iterator();
        while (it.hasNext())
        {
            final org.jdom.Element eGrant = (org.jdom.Element)it.next();

            principal.addGrant(eGrant.getAttributeValue(A_NAME));
        }

        // done.

        return principal;
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
