/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlUtils.java 2587 2006-05-09 09:15:59Z jmettraux $
 */

//
// XmlUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.xml;

import openwfe.org.Utils;
import openwfe.org.Service;
import openwfe.org.OpenWfeException;


/**
 * Utility methods for XML stuff
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlUtils.java 2587 2006-05-09 09:15:59Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class XmlUtils
{

    //
    // TODO : clean this utility class !
    //

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlUtils.class.getName());

    //
    // CONSTANTS

    //
    // METHODS

    /**
     * extractXml() methods for fetching XML out of various sources.
     */
    public static org.jdom.Element extractXml 
        (String docUrl, final boolean validate)
    throws 
        org.jdom.JDOMException, java.io.IOException
    {
        log.debug("extractXml(sUrl) docUrl is >"+docUrl+"<");

        if (docUrl.startsWith("resource:"))
        {
            final java.io.InputStream is = 
                XmlUtils.class.getResourceAsStream(docUrl.substring(9));

            return extractXml(is, validate);
        }

        docUrl = Utils.ensureProtocol(docUrl);

        log.debug("extractXml(sUrl) docUrl is >"+docUrl+"<");

        return extractXml(new java.net.URL(docUrl), validate);
    }

    /**
     * extractXml() methods for fetching XML out of various sources.
     */
    public static org.jdom.Element extractXml 
        (final java.io.InputStream is, final boolean validate)
    throws 
        org.jdom.JDOMException, java.io.IOException
    {
        log.debug("extractXml(is)");

        final org.jdom.input.SAXBuilder builder = getSAXBuilder(validate);

        final org.jdom.Document doc = builder.build(is);

        return doc.getRootElement();
    }

    /**
     * extractXml() methods for fetching XML out of various sources.
     */
    public static org.jdom.Element extractXml 
        (final java.io.File file, final boolean validate)
    throws 
        org.jdom.JDOMException, java.io.IOException
    {
        log.debug("extractXml(file) "+file.getName());

        org.jdom.input.SAXBuilder builder = getSAXBuilder(validate);

        //org.jdom.Document doc = builder.build(new java.io.FileReader(file));
        org.jdom.Document doc = 
            builder.build(new java.io.FileInputStream(file));

        return doc.getRootElement();
    }

    /**
     * extractXml() methods for fetching XML out of various sources.
     */
    public static org.jdom.Element extractXml 
        (final java.net.URL docUrl, final boolean validate)
    throws 
        org.jdom.JDOMException, java.io.IOException
    {
        log.debug("extractXml(url) "+docUrl.toString());

        org.jdom.input.SAXBuilder builder = getSAXBuilder(validate);

        //log.debug("extractXml(url) sax builder ready");

        org.jdom.Document doc = builder.build(docUrl);

        //log.debug("extractXml(url) doc built.");

        return doc.getRootElement();
    }

    /**
     * extractXml() methods for fetching XML out of various sources.
     */
    public static org.jdom.Element extractXml 
        (final java.net.URLConnection uc, final boolean validate)
    throws 
        org.jdom.JDOMException, java.io.IOException
    {
        log.debug("extractXml(uc) "+uc.getURL().toString());

        org.jdom.input.SAXBuilder builder = getSAXBuilder(validate);

        org.jdom.Document doc = builder.build(uc.getInputStream());

        return doc.getRootElement();
    }

    /**
     * extractXml() methods for fetching XML out of various sources.
     */
    public static org.jdom.Document extractXmlDocument 
        (final String xmlDocument, final boolean validate)
    throws 
        org.jdom.JDOMException, java.io.IOException
    {
        org.jdom.input.SAXBuilder builder = getSAXBuilder(validate);

        java.io.StringReader sReader = new java.io.StringReader(xmlDocument);

        return builder.build(sReader);
    }

    /**
     * extractXml() methods for fetching XML out of various sources.
     */
    public static org.jdom.Element extractXmlElement
        (final String rawXml)
    throws 
        org.jdom.JDOMException, java.io.IOException
    {
        final org.jdom.Document doc = extractXmlDocument(rawXml, false);

        final org.jdom.Element elt = doc.getRootElement();

        elt.detach();

        return elt;
    }

    /**
     * Turns the attributes of an xml element into a map
     */
    public static java.util.Map fetchAttributes (final org.jdom.Element elt)
    {
        java.util.Map result = new java.util.HashMap();

        java.util.Iterator it = elt.getAttributes().iterator();
        while (it.hasNext())
        {
            org.jdom.Attribute att = (org.jdom.Attribute)it.next();
            result.put(att.getName(), att.getValue());
        }

        return result;
    }

    /**
     * Turns a detached JDOM element into a byte array (makes sure it comes back
     * detached afterwards).
     */
    public static byte[] toByteArray (final org.jdom.Element elt)
        throws OpenWfeException
    {
        final byte[] result = toByteArray(new org.jdom.Document(elt));

        elt.detach();

        return result;
    }

    /**
     * turns a jdom document into a byte array
     */
    public static byte[] toByteArray (final org.jdom.Document doc)
        throws OpenWfeException
    {
        final org.jdom.output.XMLOutputter out = getXMLOutputter();

        final java.io.ByteArrayOutputStream baos = 
            new java.io.ByteArrayOutputStream();

        try
        {
            out.output(doc, baos);
            baos.write('\n');
            baos.flush();
        }
        catch (final java.io.IOException ie)
        {
            throw new OpenWfeException
                ("Failed to encode workitem as xml", ie);
        }

        return baos.toByteArray();
    }

    /**
     * A convenience method for setting up a pretty print XMLOutputter
     * with a given encoding.
     */
    public static org.jdom.output.XMLOutputter getXMLOutputter 
        (String encoding)
    {
        final org.jdom.output.Format format = 
            org.jdom.output.Format.getPrettyFormat();

        if (encoding == null) encoding = Utils.getEncoding();

        format.setEncoding(encoding);

        return new org.jdom.output.XMLOutputter(format);
    }

    /**
     * A convenience method for setting up a pretty print XMLOutputter
     * with the default encoding.
     */
    public static org.jdom.output.XMLOutputter getXMLOutputter ()
    {
        return getXMLOutputter(null);
    }

    /**
     * Saving an XML element to a file.
     */
    public static void save (final String fileName, final org.jdom.Element elt)
        throws java.io.IOException
    {
        java.io.FileOutputStream fos = null;
        try
        {
            elt.detach();

            final org.jdom.Document doc = new org.jdom.Document(elt);

            fos = new java.io.FileOutputStream(fileName);

            XmlUtils.getXMLOutputter().output(doc, fos);

            fos.flush();
        }
        finally
        {
            try
            {
                fos.close();
            }
            catch (final Throwable t)
            {
                // ignore
            }
        }
    }

    /**
     * Turns a JDOM document into a String.
     */
    public static String toString 
        (final org.jdom.Document doc)
    {
        return toString(doc, null);
    }

    /**
     * Turns a JDOM document into a String.
     */
    public static String toString 
        (final org.jdom.Document doc, String encoding)
    {
        if (encoding == null)
            encoding = Utils.getEncoding();

        final org.jdom.output.XMLOutputter out = getXMLOutputter(encoding);

        java.io.ByteArrayOutputStream baos = 
            new java.io.ByteArrayOutputStream();

        try
        {
            out.output(doc, baos);
            baos.write('\n');
            baos.flush();

            return baos.toString(encoding);
        }
        catch (java.io.IOException ie)
        {
            log.warn
                ("Failed to encode workitem as xml", ie);

            return "";
        }
    }

    /**
     * Turns a JDOM content instance into a String 
     * (with the application encoding).
     */
    public static String toString (final org.jdom.Content c)
    {
        if (c instanceof org.jdom.Text) 
            return ((org.jdom.Text)c).getTextTrim();

        org.jdom.Element elt = (org.jdom.Element)c;

        final boolean hasParent = (elt.getParent() != null);

        if (hasParent) elt = (org.jdom.Element)elt.clone();

        final String result = toString(new org.jdom.Document(elt), null);

        if ( ! hasParent) elt.detach();

        return result;
    }

    /**
     * This method is used by the implementation of the getStatus
     * methods to have a 'class' jdom element
     */
    public static org.jdom.Element getClassElt (final Service s)
    {
        org.jdom.Element result = new org.jdom.Element("class");

        if (s == null) 
            result.addContent("null");
        else
            result.addContent(s.getClass().getName());

        return result;
    }

    /**
     * This method is used by the implementation of the getStatus
     * methods to have a 'revision' jdom element
     */
    public static org.jdom.Element getRevisionElt (String revId)
    {
        org.jdom.Element result = new org.jdom.Element("revision");

        if (revId == null) 
            result.addContent("null");
        else
            result.addContent(revId);

        return result;
    }

    /**
     * Adds a map of attributes to an org.jdom.Element
     */
    public static void setAttributes 
        (org.jdom.Element elt, java.util.Map attributes)
    {
        if (elt == null) return;
        if (attributes == null) return;

        java.util.Iterator it = attributes.keySet().iterator();
        while (it.hasNext())
        {
            String key = it.next().toString();
            String value = attributes.get(key).toString();

            //log.debug("setting attribute '"+key+"' = '"+value+"'");

            elt.setAttribute(key, value);
        }
    }

    /**
     * A debug method : dumps as a string a view of an XML element.
     */
    public static String dumpContent (final org.jdom.Element elt)
    {
        final StringBuffer sb = new StringBuffer();

        sb.append("  --"+elt.getName()+"--\n");

        java.util.Iterator it = elt.getAttributes().iterator();
        while (it.hasNext())
        {
            final org.jdom.Attribute at = (org.jdom.Attribute)it.next();
            sb.append("     - "+at.getName()+"='"+at.getValue()+"'\n");
        }

        it = elt.getContent().iterator();
        while (it.hasNext())
        {
            final Object c = it.next();

            if (c instanceof org.jdom.Element)
            {
                final org.jdom.Element e = (org.jdom.Element)c;

                sb.append("   * --"+e.getName()+"--\n");
                continue;
            }
            
            sb.append("   * "+c.getClass().getName()+"\n");
        }

        return sb.toString();
    }

    /**
     * Returns a SAXBuilder with XSD schema validation on.
     */
    public static org.jdom.input.SAXBuilder getSAXBuilder 
        (final boolean validate)
    {
        if (validate == false) 
            return new org.jdom.input.SAXBuilder(false);

        final org.jdom.input.SAXBuilder builder = new org.jdom.input.SAXBuilder
            ("org.apache.xerces.parsers.SAXParser", true);
            //("javax.xml.parsers.SAXParser", true);

        builder.setFeature
            ("http://apache.org/xml/features/validation/schema", true);

        return builder;
    }

    //
    // (methods coming from WicUtils (workitem coder utils)

    /**
     * Returns among the child of the given elt the first that is an 
     * instance of of org.jdom.Element itself.
     */
    public static org.jdom.Element getFirstChild (final org.jdom.Element elt)
    {
        return getChild(elt, 0);
    }

    /**
     * Among the org.jdom.Element children of the given element, returns the one
     * located at the given index.
     */
    public static org.jdom.Element getChild 
        (final org.jdom.Element elt, final int childIndex)
    {
        if (elt == null) return null;

        int pos = 0;

        final java.util.Iterator it = elt.getContent().iterator();
        while (it.hasNext())
        {
            final Object o = it.next();

            if (o instanceof org.jdom.Element)
            {
                if (pos == childIndex)
                    return (org.jdom.Element)o;

                pos++;
            }
        }

        return null;
    }

    /**
     * Returns the first text or cdata child of the given elt.
     */
    public static String fetchTextContent (final org.jdom.Element elt)
        //throws CodingException
    {
        if (elt.getContent().size() < 1)
        {
            //throw new CodingException 
            //  ("Element without any content. Cannot turn into an attribute.");

            //log.debug("fetchTextContent() returning ''");

            return "";
        }

        //log.debug("fetchTextContent() size : "+elt.getContent().size());
        //java.util.Iterator iit = elt.getContent().iterator();
        //while (iit.hasNext())
        //{
        //    final Object o = iit.next();
        //    log.debug("fetchTextContent()     - "+o.getClass().getName());
        //}

        java.util.Iterator it = elt.getContent().iterator();
        while (it.hasNext())
        {
            Object content = it.next();
            if (content instanceof org.jdom.Text)
            {
                //log.debug
                //    ("fetchTextContent() returning text >"+
                //     ((org.jdom.Text)content).getTextTrim()+"<");

                return ((org.jdom.Text)content).getTextTrim();
            }
            else if (content instanceof org.jdom.CDATA)
            {
                //log.debug
                //    ("fetchTextContent() returning cdata >"+
                //     ((org.jdom.CDATA)content).getTextTrim()+"<");

                return ((org.jdom.CDATA)content).getTextTrim();
            }
        }

        //throw new CodingException
        //    ("Element doesn't contain any textual info "+
        //     "which may be used to build an attribute");

        return null;
    }

    /**
     * Returns the first CDATA section held in the given elt as a String.
     */
    public static String fetchCdataContent (final org.jdom.Element elt)
        //throws CodingException
    {
        if (elt.getContent().size() < 1)
        {
            return "";
        }

        final java.util.Iterator it = elt.getContent().iterator();
        while (it.hasNext())
        {
            final Object o = it.next();

            if (o instanceof org.jdom.CDATA)
                return ((org.jdom.CDATA)o).getTextTrim();
        }

        //throw new CodingException
        //    ("Element doesn't contain a CDATA section");

        return null;
    }

    public static String dump 
        (final String prefix, final org.jdom.Element elt)
    {
        try
        {
            return Utils.dump(prefix, toByteArray(elt));
        }
        catch (final Throwable t)
        {
            log.debug("dump() failure", t);
        }

        return null;
    }

    public static String dump 
        (final String prefix, final org.jdom.Document doc)
    {
        try
        {
            return Utils.dump(prefix, toByteArray(doc));
        }
        catch (final Throwable t)
        {
            log.debug("dump() failure", t);
        }

        return null;
    }

    /* *
     * If something else than an instance of Element is passed to this
     * method it will get untouched, for an Element instance, trailing
     * empty Text element will get removed.
     * /
    public static org.jdom.Content clean (final org.jdom.Content c)
    {
        if ( ! (c instanceof org.jdom.Element)) return c;

        final org.jdom.Element e = (org.jdom.Element)c;

        final org.jdom.Element 
    }
     */

    /**
     * If the first line of sXml is a &lt;?xml &gt; declaration, the
     * returned string will be sXml without this first line else sXml
     * will be returned.
     */
    public static String removeHeaderLine (final String sXml)
    {
        if ( ! sXml.startsWith("<?xml")) return sXml;

        final int i = sXml.indexOf(">");

        String s = sXml.substring(i+1);

        return s.trim();
    }

    /**
     * It's the same method as toString(c), but it returns a String without
     * the &lt;?xml &gt; declaration.
     */
    public static String xmlToString (final org.jdom.Content c)
    {
        return removeHeaderLine(toString(c));
    }

}
