/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openwfe.org.MapUtils;
import openwfe.org.OwfeRunnable;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.SharedApplicationContext;
import openwfe.org.state.PausedState;
import openwfe.org.state.RunningState;
import openwfe.org.state.ServiceState;
import openwfe.org.state.StoppedState;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class ApplicationContext
implements OwfeRunnable {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$ApplicationContext == null ? (class$openwfe$org$ApplicationContext = ApplicationContext.class$("openwfe.org.ApplicationContext")) : class$openwfe$org$ApplicationContext).getName());
    protected static final String SHARED = "shared";
    public static final String P_SERVICE_ITERATOR = "serviceIterator";
    public static final String P_APPLICATION_DIRECTORY = "applicationDirectory";
    public static final String K_LAST_MODIFIED = "__last_modified__";
    public static final Map contextMap = new HashMap();
    private ApplicationContext parentContext = null;
    private String applicationName = null;
    private Map map = new HashMap();
    private Map serviceIterators = new HashMap();
    private ServiceState contextState = new RunningState();
    static /* synthetic */ Class class$openwfe$org$ApplicationContext;

    public long getLastModified() {
        Long l = (Long)this.map.get(K_LAST_MODIFIED);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public void setLastModified(long l) {
        this.map.put(K_LAST_MODIFIED, new Long(l));
    }

    public void setApplicationName(String s) {
        this.applicationName = s;
    }

    public Map asMap() {
        return this.map;
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public void put(String key, Object o) {
        this.map.put(key, o);
    }

    public void add(Service s) {
        this.put(s.getName(), s);
    }

    public void putAll(Map m) {
        this.map.putAll(m);
    }

    public Object get(String key) {
        return this.lookup(key);
    }

    protected ApplicationContext getRootContext() {
        if (this.parentContext == null) {
            return this;
        }
        return this.parentContext.getRootContext();
    }

    public Object lookup(String key) {
        if (key == null) {
            return null;
        }
        int i = key.indexOf("/");
        if (i < 0) {
            return this.map.get(key);
        }
        if (key.startsWith("./")) {
            return this.lookup(key.substring(2));
        }
        if (key.startsWith("../")) {
            return this.getParentContext().lookup(key.substring(3));
        }
        if (key.startsWith("/")) {
            return this.getRootContext().lookup(key.substring(1));
        }
        String subContextName = key.substring(0, i);
        log.debug((Object)("lookup() subContextName is '" + subContextName + "'"));
        ApplicationContext subContext = (ApplicationContext)this.map.get(subContextName);
        if (subContext == null) {
            return null;
        }
        return subContext.lookup(key.substring(i + 1));
    }

    public long getTime(String key) throws NumberFormatException {
        return MapUtils.getAsTime(this.map, key);
    }

    public long getLong(String key) throws NumberFormatException {
        return MapUtils.getAsLong(this.map, key);
    }

    public long getLong(String key, long defaultValue) {
        return MapUtils.getAsLong(this.map, key, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return MapUtils.getAsInt(this.map, key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return MapUtils.getAsBoolean(this.map, key, defaultValue);
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public List itemsOfClass(Class theClass) {
        ArrayList result = new ArrayList(this.map.size());
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!theClass.isAssignableFrom(item.getClass())) continue;
            result.add(item);
        }
        return result;
    }

    public String getApplicationDirectory() {
        String applicationDirectory = (String)this.map.get(P_APPLICATION_DIRECTORY);
        if (applicationDirectory == null) {
            applicationDirectory = "./";
            this.map.put(P_APPLICATION_DIRECTORY, applicationDirectory);
        } else if (!applicationDirectory.endsWith(File.separator)) {
            applicationDirectory = applicationDirectory + File.separator;
            this.map.put(P_APPLICATION_DIRECTORY, applicationDirectory);
        }
        return applicationDirectory;
    }

    public void setApplicationDirectory(String path) {
        this.map.put(P_APPLICATION_DIRECTORY, path);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getName() {
        return this.applicationName;
    }

    public Iterator serviceIterator() {
        ArrayList result = new ArrayList(this.map.size());
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Service)) continue;
            result.add(o);
        }
        return result.iterator();
    }

    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(ApplicationContext ac) {
        this.parentContext = ac;
    }

    public void outputStatus(Element rootElt) {
        Iterator it = this.serviceIterator();
        while (it.hasNext()) {
            Service s = (Service)it.next();
            Element sStatus = s.getStatus();
            if (sStatus == null) {
                sStatus = new Element("service");
                sStatus.setAttribute("name", s.getName());
                Element eNullStatus = new Element("null-status");
                sStatus.addContent((Content)eNullStatus);
            }
            rootElt.addContent((Content)sStatus);
        }
        it = this.map.values().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof ApplicationContext)) continue;
            ApplicationContext subContext = (ApplicationContext)o;
            Element subRootElt = new Element(subContext.getApplicationName());
            subContext.outputStatus(subRootElt);
            rootElt.addContent((Content)subRootElt);
        }
        Element efm = new Element("free-memory");
        efm.addContent("" + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + " MB");
        Element emm = new Element("max-memory");
        emm.addContent("" + (double)Runtime.getRuntime().maxMemory() / 1000000.0 + " MB");
        rootElt.addContent((Content)efm);
        rootElt.addContent((Content)emm);
    }

    public void stop() throws ServiceException {
        this.setState(new StoppedState());
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof OwfeRunnable)) continue;
            OwfeRunnable runnable = (OwfeRunnable)item;
            try {
                runnable.stop();
            }
            catch (ServiceException e) {
                log.info((Object)("stop() had trouble when stopping '" + runnable.getName() + "'"), (Throwable)e);
            }
        }
        log.info((Object)("stop() context '" + this.applicationName + "' stopped."));
    }

    public void play() throws ServiceException {
        log.info((Object)("play() requested for service '" + this.getName() + "'"));
        if (this.isRunning()) {
            return;
        }
        this.setState(new RunningState());
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof OwfeRunnable)) continue;
            OwfeRunnable runnable = (OwfeRunnable)item;
            try {
                runnable.play();
            }
            catch (ServiceException se) {
                log.info((Object)("play() had trouble when playing '" + runnable.getName() + "'"), (Throwable)se);
            }
        }
    }

    public void pause() throws ServiceException {
        log.info((Object)("pause() requested for service '" + this.getName() + "'"));
        if (!this.isRunning()) {
            return;
        }
        this.setState(new PausedState());
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof OwfeRunnable)) continue;
            OwfeRunnable runnable = (OwfeRunnable)item;
            try {
                runnable.pause();
            }
            catch (ServiceException e) {
                log.info((Object)("pause() had trouble when pausing '" + runnable.getName() + "'"), (Throwable)e);
            }
        }
    }

    public void update() throws ServiceException {
        log.info((Object)("update() requested for service '" + this.getName() + "'"));
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof OwfeRunnable)) continue;
            OwfeRunnable runnable = (OwfeRunnable)item;
            try {
                runnable.update();
            }
            catch (ServiceException e) {
                log.info((Object)("pause() had trouble when 'updating' '" + runnable.getName() + "'"), (Throwable)e);
            }
        }
    }

    public ServiceState getState() {
        return this.contextState;
    }

    protected void setState(ServiceState state) {
        this.contextState = state;
    }

    public boolean isRunning() {
        return this.getState() instanceof RunningState;
    }

    public static ApplicationContext lookupContext(String contextName) {
        return (ApplicationContext)contextMap.get(contextName);
    }

    public static SharedApplicationContext lookupSharedContext() {
        return (SharedApplicationContext)contextMap.get(SHARED);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SharedApplicationContext sac = new SharedApplicationContext();
        contextMap.put(SHARED, sac);
    }
}

