/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import openwfe.org.ApplicationContext;
import openwfe.org.auth.PolicyService;
import openwfe.org.auth.Principal;
import org.apache.log4j.Logger;

public abstract class LoginModule
implements javax.security.auth.spi.LoginModule {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$LoginModule == null ? (class$openwfe$org$auth$LoginModule = LoginModule.class$("openwfe.org.auth.LoginModule")) : class$openwfe$org$auth$LoginModule).getName());
    public static final String APPLICATION = "application";
    public static final String POLICY_SERVICE = "policyService";
    protected Subject subject = null;
    protected CallbackHandler handler = null;
    protected Map sharedState = null;
    protected Map options = null;
    protected Principal principal = null;
    protected boolean succeeded = false;
    protected boolean commitSucceeded = false;
    protected PolicyService policyService = null;
    static /* synthetic */ Class class$openwfe$org$auth$LoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        ApplicationContext context;
        this.subject = subject;
        this.handler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        String applicationName = (String)this.options.get(APPLICATION);
        String policyService = (String)this.options.get(POLICY_SERVICE);
        if (applicationName == null || policyService == null) {
            log.warn((Object)"login module parameters 'application' and 'policyService' are mandatory");
        }
        if ((context = ApplicationContext.lookupContext(applicationName)) == null) {
            log.warn((Object)("Application context named '" + applicationName + "' not found. No login possible."));
        }
        this.policyService = PolicyService.lookupPolicyService(context);
        if (this.policyService == null || !(this.policyService instanceof PolicyService)) {
            log.warn((Object)"Application 'application' doesn't contain a policy service named 'policyService'");
        }
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            log.debug((Object)"Login hasn't succeeded");
            return false;
        }
        log.debug((Object)"Login has succeeded");
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        this.succeeded = false;
        if (false) {
            return false;
        }
        if (this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.principal = null;
        this.succeeded = false;
        this.commitSucceeded = false;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

