/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Grant;
import openwfe.org.auth.Principal;
import org.apache.log4j.Logger;

public class Passwd {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$Passwd == null ? (class$openwfe$org$auth$Passwd = Passwd.class$("openwfe.org.auth.Passwd")) : class$openwfe$org$auth$Passwd).getName());
    private String name = null;
    private Map grantMap = null;
    private Map principalMap = null;
    static /* synthetic */ Class class$openwfe$org$auth$Passwd;
    static /* synthetic */ Class class$openwfe$org$auth$Principal;

    public Passwd(String name, Map principalMap, Map grantMap) {
        this.name = name;
        this.principalMap = principalMap;
        this.grantMap = grantMap;
    }

    public String getName() {
        return this.name;
    }

    public Map getPrincipalMap() {
        return this.principalMap;
    }

    public Map getGrantMap() {
        return this.grantMap;
    }

    public Principal authentify(String principalName, Object credentials) throws AuthException {
        Principal p = (Principal)this.principalMap.get(principalName);
        if (p == null) {
            throw new AuthException("No principal named '" + principalName + "'");
        }
        log.debug((Object)("authentify() is p a copy ? " + p.isCopy()));
        if (!p.authentify(credentials)) {
            log.debug((Object)"authentify() authentication failed.");
            return null;
        }
        return p.getWorkCopy();
    }

    private Principal extractsEffectivePrincipal(ProtectionDomain domain) throws AuthException {
        java.security.Principal[] principals = domain.getPrincipals();
        for (int i = 0; i < principals.length; ++i) {
            Principal principal;
            Class<?> pClass;
            if (!(class$openwfe$org$auth$Principal == null ? Passwd.class$("openwfe.org.auth.Principal") : class$openwfe$org$auth$Principal).isAssignableFrom(pClass = (principal = (Principal)principals[i]).getClass())) continue;
            return principal;
        }
        return null;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) throws AuthException {
        Principal principal = this.extractsEffectivePrincipal(domain);
        Permissions permissions = new Permissions();
        if (principal == null) {
            return permissions;
        }
        Iterator it = principal.getGrants().iterator();
        while (it.hasNext()) {
            String grantName = (String)it.next();
            Grant g = (Grant)this.grantMap.get(grantName);
            if (g == null || !g.codeSourceImplies(domain.getCodeSource())) continue;
            Enumeration<Permission> en = g.getPermissions().elements();
            while (en.hasMoreElements()) {
                Permission p = en.nextElement();
                ((PermissionCollection)permissions).add(p);
            }
        }
        return permissions;
    }

    public PermissionCollection getPermissions(Subject s) throws AuthException {
        Set principals = s.getPrincipals(class$openwfe$org$auth$Principal == null ? (class$openwfe$org$auth$Principal = Passwd.class$("openwfe.org.auth.Principal")) : class$openwfe$org$auth$Principal);
        if (principals.size() < 1) {
            return new Permissions();
        }
        Principal principal = (Principal)principals.iterator().next();
        Permissions permissions = new Permissions();
        Iterator it = principal.getGrants().iterator();
        while (it.hasNext()) {
            String grantName = (String)it.next();
            Grant g = (Grant)this.grantMap.get(grantName);
            if (g == null) continue;
            Enumeration<Permission> en = g.getPermissions().elements();
            while (en.hasMoreElements()) {
                Permission p = en.nextElement();
                ((PermissionCollection)permissions).add(p);
            }
        }
        return permissions;
    }

    public Map getPrincipals() {
        return this.principalMap;
    }

    public Map getGrants() {
        return this.grantMap;
    }

    public void updatePrincipals(Map principals) {
        this.principalMap = principals;
    }

    public void updateGrants(Map grants) {
        this.grantMap = grants;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

