/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class WebUtils {
    public static void log(HttpServletRequest req, String message) {
        WebUtils.log(req, message, null);
    }

    public static void log(HttpServletRequest req, String message, Throwable t) {
        HttpSession hs = req.getSession();
        if (hs == null) {
            return;
        }
        WebUtils.log(hs, message, t);
    }

    public static void log(HttpSession ses, String message) {
        WebUtils.log(ses, message, null);
    }

    public static void log(HttpSession ses, String message, Throwable t) {
        if (t == null) {
            ses.getServletContext().log(message);
        } else {
            ses.getServletContext().log(message, t);
        }
    }

    public static void forward(HttpServletRequest req, HttpServletResponse res, String url) throws IOException, ServletException {
        RequestDispatcher rd = req.getRequestDispatcher(url);
        rd.forward((ServletRequest)req, (ServletResponse)res);
    }

    public static void include(PrintWriter out, String fileName) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((line = br.readLine()) != null) {
                out.println(line);
            }
            br.close();
        }
        catch (Exception e) {
            File f = new File(fileName);
            out.println("<font color=red>Failed to include file '" + f.getAbsolutePath() + "'");
            out.println("<br>" + e);
            out.println("</font>");
        }
    }

    public static void include(PrintWriter out, URL url) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            while ((line = br.readLine()) != null) {
                out.println(line);
            }
            br.close();
        }
        catch (Exception e) {
            out.println("<font color=red>Failed to include URL " + url);
            out.println("<br>" + e);
            out.println("</font>");
        }
    }
}

