/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.sql.SqlUtils;
import org.apache.log4j.Logger;

public class SqlParameters {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$sql$SqlParameters == null ? (class$openwfe$org$sql$SqlParameters = SqlParameters.class$("openwfe.org.sql.SqlParameters")) : class$openwfe$org$sql$SqlParameters).getName());
    private final String paramTableName;
    private final String idColName;
    private final String groupColName;
    private final String keyColName;
    private final String valueColName;
    static /* synthetic */ Class class$openwfe$org$sql$SqlParameters;

    public SqlParameters(String paramTableName, String idColName, String groupColName, String keyColName, String valueColName) {
        this.paramTableName = paramTableName;
        this.idColName = idColName;
        this.groupColName = groupColName;
        this.keyColName = keyColName;
        this.valueColName = valueColName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List extractParameters(Connection con, String group, String key) {
        ArrayList<Map> result = new ArrayList<Map>();
        int id = -1;
        String query = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            query = this.buildQuery(group, key, null);
            st = con.createStatement();
            rs = st.executeQuery(query);
            while (rs.next()) {
                id = rs.getInt(1);
                result.add(this.extractParameters(con, id));
            }
        }
        catch (SQLException se) {
            ArrayList<Map> arrayList;
            try {
                log.warn((Object)("Failed to extract parameters from the database with query\n" + query), (Throwable)se);
                arrayList = result;
            }
            catch (Throwable throwable) {
                SqlUtils.closeStatement(st, rs);
                throw throwable;
            }
            SqlUtils.closeStatement(st, rs);
            return arrayList;
        }
        SqlUtils.closeStatement(st, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map extractParameters(Connection con, String group, String key, String value) {
        ResultSet rs;
        Statement st;
        String query;
        int id;
        block5: {
            id = -1;
            query = null;
            st = null;
            rs = null;
            query = this.buildQuery(group, key, value);
            st = con.createStatement();
            rs = st.executeQuery(query);
            if (rs.next()) break block5;
            log.debug((Object)"extracParameters() no id found");
            Map map = null;
            SqlUtils.closeStatement(st, rs);
            return map;
        }
        try {
            id = rs.getInt(1);
        }
        catch (SQLException se) {
            try {
                log.warn((Object)("Failed to extract parameters from the database with query\n" + query), (Throwable)se);
            }
            catch (Throwable throwable) {
                SqlUtils.closeStatement(st, rs);
                throw throwable;
            }
            SqlUtils.closeStatement(st, rs);
        }
        SqlUtils.closeStatement(st, rs);
        return this.extractParameters(con, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map extractParameters(Connection con, int id) {
        Map map;
        String query = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            query = this.buildQuery(id);
            st = con.createStatement();
            rs = st.executeQuery(query);
            HashMap<String, String> result = new HashMap<String, String>();
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                result.put(key, value);
            }
            map = Collections.unmodifiableMap(result);
        }
        catch (SQLException se) {
            Map map2;
            try {
                log.warn((Object)("Failed to extract parameters from the database with query\n" + query), (Throwable)se);
                map2 = null;
            }
            catch (Throwable throwable) {
                SqlUtils.closeStatement(st, rs);
                throw throwable;
            }
            SqlUtils.closeStatement(st, rs);
            return map2;
        }
        SqlUtils.closeStatement(st, rs);
        return map;
    }

    public long insertParams(Connection con, String group, Map params) throws SQLException {
        long id = SqlUtils.getNewInsertId(con, this.paramTableName, this.idColName);
        Iterator it = params.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String val = (String)params.get(key);
            this.insertParam(con, id, group, key, val);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertParam(Connection con, long id, String group, String key, String value) throws SQLException {
        String sInsert = null;
        Statement st = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("INSERT INTO ");
            sb.append(this.paramTableName);
            sb.append(" ( ");
            sb.append(this.idColName);
            sb.append(", ");
            sb.append(this.groupColName);
            sb.append(", ");
            sb.append(this.keyColName);
            sb.append(", ");
            sb.append(this.valueColName);
            sb.append(" ) VALUES ( ");
            sb.append(id);
            sb.append(", ");
            sb.append(SqlUtils.prepareString(group));
            sb.append(", ");
            sb.append(SqlUtils.prepareString(key));
            sb.append(", ");
            sb.append(SqlUtils.prepareString(value));
            sb.append(");");
            sInsert = sb.toString();
            st = con.createStatement();
            st.execute(sInsert);
        }
        catch (Throwable throwable) {
            SqlUtils.closeStatement(st);
            throw throwable;
        }
        SqlUtils.closeStatement(st);
    }

    private String buildQuery(String group, String key, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append(this.idColName);
        sb.append(" FROM ");
        sb.append(this.paramTableName);
        sb.append(" WHERE ");
        sb.append(this.groupColName);
        sb.append(" = ");
        sb.append(SqlUtils.prepareString(group));
        sb.append(" AND ");
        sb.append(this.keyColName);
        sb.append(" = ");
        sb.append(SqlUtils.prepareString(key));
        if (value != null) {
            sb.append(" AND ");
            sb.append(this.valueColName);
            sb.append(" = ");
            sb.append(SqlUtils.prepareString(value));
        }
        sb.append(";");
        return sb.toString();
    }

    private String buildQuery(int id) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append(this.keyColName);
        sb.append(", ");
        sb.append(this.valueColName);
        sb.append(" FROM ");
        sb.append(this.paramTableName);
        sb.append(" WHERE ");
        sb.append(this.idColName);
        sb.append(" = ");
        sb.append(id);
        sb.append(";");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

