/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.time;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.time.CronLine;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Scheduler;
import org.apache.log4j.Logger;

public class CronService
extends AbstractService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$time$CronService == null ? (class$openwfe$org$time$CronService = CronService.class$("openwfe.org.time.CronService")) : class$openwfe$org$time$CronService).getName());
    public static final String CRON_PREFIX = "cron:";
    private Scheduler scheduler = null;
    static /* synthetic */ Class class$openwfe$org$time$CronService;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.scheduler = new Scheduler(serviceName);
        this.scheduler.setDaemon(false);
        this.scheduler.start();
        Iterator it = serviceParams.keySet().iterator();
        while (it.hasNext()) {
            String paramName = (String)it.next();
            if (!paramName.startsWith(CRON_PREFIX)) continue;
            String cronLine = paramName.substring(CRON_PREFIX.length());
            Object o = serviceParams.get(paramName);
            if (o instanceof List) {
                Iterator iit = ((List)o).iterator();
                while (iit.hasNext()) {
                    this.schedule(cronLine, (String)iit.next());
                }
                continue;
            }
            this.schedule(cronLine, (String)o);
        }
    }

    protected void schedule(String cronLine, String schedulableServiceName) throws ServiceException {
        Object o = this.getContext().lookup(schedulableServiceName);
        if (o == null) {
            throw new ServiceException("'" + this.getName() + "' did not find schedulable service '" + schedulableServiceName + "'");
        }
        if (!(o instanceof Schedulable)) {
            throw new ServiceException("service '" + schedulableServiceName + "' is not Schedulable");
        }
        this.scheduler.schedule(CronLine.parse(cronLine), (Schedulable)o, null);
        log.info((Object)("scheduled '" + schedulableServiceName + "' for '" + cronLine + "'"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

