/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Principal;
import org.apache.log4j.Logger;

public class BasicPrincipal
implements Principal {
    static final long serialVersionUID = -3421084984894408642L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$BasicPrincipal == null ? (class$openwfe$org$auth$BasicPrincipal = BasicPrincipal.class$("openwfe.org.auth.BasicPrincipal")) : class$openwfe$org$auth$BasicPrincipal).getName());
    public static final String NAME = "name";
    public static final String CLASS = "class";
    public static final String PASSWORD = "password";
    public static final String GRANTS = "grants";
    private String name = null;
    private Set grants = new HashSet(0);
    private String hashedPassword = null;
    private Map initParameters = null;
    static /* synthetic */ Class class$openwfe$org$auth$BasicPrincipal;

    public void init(Map initParams) throws AuthException {
        HashMap<String, String> m = new HashMap<String, String>(initParams);
        m.put(CLASS, this.getClass().getName());
        this.initParameters = Collections.unmodifiableMap(m);
        try {
            this.name = (String)initParams.get(NAME);
            this.hashedPassword = (String)initParams.get(PASSWORD);
            Object o = initParams.get(GRANTS);
            if (o != null) {
                this.grants = (Set)o;
            }
        }
        catch (ClassCastException cce) {
            throw new AuthException("init failed", cce);
        }
        log.debug((Object)("init() initted '" + this.name + "'"));
        if (this.name == null) {
            throw new AuthException("Parameter 'name' is missing for Principal building");
        }
        if (this.grants == null) {
            this.grants = new HashSet();
        }
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        BasicPrincipal other = null;
        try {
            other = (BasicPrincipal)another;
        }
        catch (Exception e) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.grants.size() != other.grants.size()) {
            return false;
        }
        Iterator it = this.grants.iterator();
        while (it.hasNext()) {
            String grantName = (String)it.next();
            if (other.grants.contains(grantName)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.getClass().getName());
        sb.append("\n");
        sb.append("  name=\"");
        sb.append(this.name);
        sb.append("\" \n");
        sb.append("> \n");
        Iterator it = this.grants.iterator();
        while (it.hasNext()) {
            String grantName = (String)it.next();
            sb.append("  <grant name=\"");
            sb.append(grantName);
            sb.append("\" /> \n");
        }
        sb.append("</");
        sb.append(this.getClass().getName());
        sb.append(">");
        return sb.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setHashedPassword(String hashedPassword) {
        this.hashedPassword = hashedPassword;
    }

    public boolean isCopy() {
        return this.hashedPassword == null;
    }

    public boolean authentify(Object credentials) throws AuthException {
        if (this.hashedPassword == null) {
            throw new AuthException("Cannot authentify Principal against a principal copy");
        }
        return this.hashedPassword.equals(credentials);
    }

    public Set getGrants() {
        return this.grants;
    }

    public Principal getWorkCopy() {
        BasicPrincipal bp = new BasicPrincipal();
        this.fill(bp);
        bp.hashedPassword = null;
        return bp;
    }

    public void addGrant(String grantName) {
        if (!this.grants.contains(grantName)) {
            this.grants.add(grantName);
        }
    }

    public void removeGrant(String grantName) {
        this.grants.remove(grantName);
    }

    public Map getInitParameters() {
        return this.initParameters;
    }

    public void fill(BasicPrincipal other) {
        other.name = this.name;
        other.hashedPassword = this.hashedPassword;
        other.grants = this.grants;
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public static BasicPrincipal getBasicPrincipal(Subject s) {
        Set set = s.getPrincipals(class$openwfe$org$auth$BasicPrincipal == null ? (class$openwfe$org$auth$BasicPrincipal = BasicPrincipal.class$("openwfe.org.auth.BasicPrincipal")) : class$openwfe$org$auth$BasicPrincipal);
        Iterator it = set.iterator();
        BasicPrincipal principal = (BasicPrincipal)it.next();
        return principal;
    }

    public static BasicPrincipal getBasicPrincipal() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        return BasicPrincipal.getBasicPrincipal(subject);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

