/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.auth.Permission;
import openwfe.org.auth.ServicePermissionCollection;
import org.apache.log4j.Logger;

public class ServicePermission
extends Permission {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$ServicePermission == null ? (class$openwfe$org$auth$ServicePermission = ServicePermission.class$("openwfe.org.auth.ServicePermission")) : class$openwfe$org$auth$ServicePermission).getName());
    public static final String ACTIONS = "actions";
    private List actionList = null;
    static /* synthetic */ Class class$openwfe$org$auth$ServicePermission;

    public ServicePermission(Map params) {
        super(params);
        this.buildActionList((String)params.get(ACTIONS));
    }

    private void buildActionList(String actions) {
        String[] ss = actions.split(", *");
        this.actionList = new ArrayList(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            this.actionList.add(ss[i].trim().toLowerCase());
        }
        Collections.sort(this.actionList);
    }

    private boolean isActionListEqual(ServicePermission other) {
        if (this.actionList.size() != other.actionList.size()) {
            return false;
        }
        Iterator it = this.actionList.iterator();
        while (it.hasNext()) {
            String action = (String)it.next();
            if (other.actionList.contains(action)) continue;
            return false;
        }
        return true;
    }

    private boolean isActionWildCard() {
        return this.actionList.size() == 1 && ((String)this.actionList.get(0)).equals("*");
    }

    private boolean actionImplies(ServicePermission other) {
        if (this.isActionWildCard()) {
            return true;
        }
        if (this.actionList.size() < other.actionList.size()) {
            return false;
        }
        Iterator it = other.actionList.iterator();
        while (it.hasNext()) {
            String action = (String)it.next();
            if (this.actionList.contains(action)) continue;
            return false;
        }
        return true;
    }

    public String actionListToString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.actionList.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String getActions() {
        return this.actionListToString();
    }

    public int hashCode() {
        return this.getName().hashCode() + ((Object)this.actionList).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServicePermission)) {
            return false;
        }
        ServicePermission other = (ServicePermission)o;
        return this.getName().equals(other.getName()) && this.isActionListEqual(other);
    }

    public boolean implies(java.security.Permission p) {
        if (p == null || !(p instanceof ServicePermission)) {
            return false;
        }
        ServicePermission other = (ServicePermission)p;
        log.debug((Object)("does " + this + " implies " + other + " ?"));
        if (!this.getName().equals(other.getName()) && !this.getName().trim().equals("*")) {
            return false;
        }
        return this.actionImplies(other);
    }

    public PermissionCollection newPermissionCollection() {
        return new ServicePermissionCollection();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<ServicePermission name=\"");
        sb.append(this.getName());
        sb.append("\" actions=\"");
        sb.append(this.actionListToString());
        sb.append("\" />");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

