/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.util.Map;

public abstract class Text {
    private Text() {
    }

    public static String substitute(String text, Map context) {
        int j = text.indexOf("}");
        if (j < 0) {
            return text;
        }
        String t = text.substring(0, j);
        int i = t.lastIndexOf("${");
        int ii = t.lastIndexOf("\\${");
        if (i < 0) {
            return text;
        }
        if (i != 0 && ii == i - 1) {
            return Text.unescape(text);
        }
        String key = text.substring(i + 2, j);
        String value = (String)context.get(key);
        if (value == null) {
            value = "";
        }
        return Text.substitute(text.substring(0, i) + value + text.substring(j + 1), context);
    }

    public static String unescape(String text) {
        return text.replaceAll("\\\\\\$\\{", "\\${");
    }

    public static String adjust(String text, int columns, boolean leftAlign) {
        int l;
        if (columns < 1) {
            return text;
        }
        if (text == null) {
            text = "";
        }
        if ((l = text.length()) == columns) {
            return text;
        }
        if (l > columns) {
            if (leftAlign) {
                return text.substring(0, columns);
            }
            return text.substring(l - columns);
        }
        int delta = columns - l;
        StringBuffer sb = new StringBuffer(text);
        for (int i = 0; i < delta; ++i) {
            if (leftAlign) {
                sb.append(" ");
                continue;
            }
            sb.insert(0, " ");
        }
        return sb.toString();
    }
}

