/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.rest;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import openwfe.org.Application;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.misc.Base64;
import openwfe.org.misc.IoUtils;
import openwfe.org.net.NetUtils;
import openwfe.org.net.SocketService;
import openwfe.org.rest.RestSession;
import openwfe.org.rest.RestUtils;
import openwfe.org.time.Time;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class RestService
extends SocketService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$rest$RestService == null ? (class$openwfe$org$rest$RestService = RestService.class$("openwfe.org.rest.RestService")) : class$openwfe$org$rest$RestService).getName());
    public static final int DEFAULT_PORT = 6080;
    public static final String P_SERVER_NAME = "serverName";
    public static final String P_REST_SESSION_CLASS = "restSessionClass";
    public static final String P_PURGE_FREQUENCY = "purgeFrequency";
    public static final String P_SESSION_TIMEOUT = "sessionTimeout";
    protected static final String DEFAULT_SERVER_NAME = "$Id: RestService.java 2001 2005-08-05 15:52:19Z jmettraux $";
    protected static final long DEFAULT_PURGE_FREQUENCY = Time.parseTimeString("2m");
    protected static final long DEFAULT_SESSION_TIMEOUT = Time.parseTimeString("10m");
    private static final String K_CONTENT_LENGTH = "Content-length";
    private Map unmodifiableServiceParams = null;
    private String serverName = null;
    private String restSessionClassName = null;
    private Map sessions = new HashMap();
    private TimerTask timeOutTask = null;
    private Long lastGivenId = new Long(-1L);
    static /* synthetic */ Class class$openwfe$org$rest$RestService;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        this.setDefaultPort(6080);
        super.init(serviceName, context, serviceParams);
        this.unmodifiableServiceParams = Collections.unmodifiableMap(serviceParams);
        this.serverName = MapUtils.getAsString(serviceParams, P_SERVER_NAME, DEFAULT_SERVER_NAME);
        this.restSessionClassName = MapUtils.getAsString(serviceParams, P_REST_SESSION_CLASS);
        try {
            Class<?> c = Class.forName(this.restSessionClassName);
            RestSession tmpSession = (RestSession)c.newInstance();
        }
        catch (Throwable t) {
            throw new ServiceException("Cannot use RestSession of class " + this.restSessionClassName, t);
        }
        long timeout = MapUtils.getAsLong(serviceParams, P_SESSION_TIMEOUT, DEFAULT_SESSION_TIMEOUT);
        long frequency = MapUtils.getAsLong(serviceParams, P_PURGE_FREQUENCY, DEFAULT_PURGE_FREQUENCY);
        log.info((Object)("Session timeout set to " + timeout + " ms"));
        log.info((Object)("Purge frequency set to " + frequency + " ms"));
        final long finalTimeout = timeout;
        this.timeOutTask = new TimerTask(){

            public void run() {
                RestService.this.timeOutSessions(finalTimeout);
            }
        };
        Application.getTimer().schedule(this.timeOutTask, 15L, frequency);
        log.info((Object)("Service '" + this.getName() + "' ready."));
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getRestSessionClassName() {
        return this.restSessionClassName;
    }

    public Element getStatus() {
        Element result = new Element(this.getName());
        result.addContent((Content)XmlUtils.getClassElt(this));
        result.addContent((Content)XmlUtils.getRevisionElt(DEFAULT_SERVER_NAME));
        return result;
    }

    private String[] extractHeaders(SocketChannel channel) throws IOException {
        int i;
        ArrayList<String> l = new ArrayList<String>(10);
        StringBuffer line = new StringBuffer();
        int zeroReads = 0;
        while ((i = IoUtils.read(channel)) != -1) {
            if (i == 0) {
                if (zeroReads >= 3) {
                    l.add(line.toString());
                    break;
                }
                ++zeroReads;
                Thread.yield();
                continue;
            }
            zeroReads = 0;
            char c = (char)i;
            if (c == '\r') continue;
            if (c == '\n') {
                String sLine = line.toString().trim();
                if (sLine.length() < 1) break;
                l.add(sLine);
                line = new StringBuffer();
                continue;
            }
            line.append(c);
        }
        return Utils.toStringArray(l);
    }

    public void handle(SelectionKey key) throws ServiceException {
        try {
            SocketChannel channel = (SocketChannel)key.channel();
            log.debug((Object)("handle() incoming connection from " + channel.socket().getInetAddress()));
            String[] headers = this.extractHeaders(channel);
            String firstLine = headers[0];
            if (!this.verify(key, firstLine)) {
                return;
            }
            Long sessionId = RestService.extractSessionId(firstLine);
            if (sessionId == null) {
                this.authenticate(key, headers);
                return;
            }
            RestSession session = (RestSession)this.sessions.get(sessionId);
            if (session == null) {
                NetUtils.httpReply(key, 404, "No such session", this.serverName, null, "text/plain", null);
                return;
            }
            session.handle(key, headers);
        }
        catch (Throwable t) {
            throw new ServiceException("Socket handling failed", t);
        }
    }

    public void stop() throws ServiceException {
        this.timeOutTask.cancel();
        log.info((Object)"timeout system for rest sessions stopped.");
        super.stop();
    }

    private void authenticate(SelectionKey key, String[] headers) {
        Throwable throwable = null;
        String sAuth = RestService.extractHeaderValue(headers, "Authorization");
        if (sAuth != null) {
            if (!sAuth.toLowerCase().startsWith("basic")) {
                NetUtils.httpReply(key, 401, "Unauthorized: only 'BASIC' authentication supported", this.serverName, null, "text/plain", null);
                return;
            }
            int i = sAuth.indexOf(" ");
            sAuth = sAuth.substring(i + 1);
            sAuth = new String(Base64.decode(sAuth.getBytes()));
            String[] ss = sAuth.split(":");
            try {
                Long sessionId = this.generateNewSessionId();
                log.debug((Object)("authenticate() new sessionId : " + sessionId));
                RestSession restSession = this.newRestSession(sessionId, ss[0], ss[1]);
                ss = null;
                this.sessions.put(sessionId, restSession);
                Element eSession = new Element("session");
                eSession.setAttribute("id", "" + sessionId);
                log.debug((Object)"authenticate() 200 Authorized");
                NetUtils.httpReply(key, 200, "OK", this.serverName, null, "text/xml", eSession);
                return;
            }
            catch (Throwable t) {
                throwable = t;
                log.debug((Object)"authenticate() failed.", t);
            }
        }
        log.debug((Object)"authenticate() 401 Unauthorized");
        NetUtils.httpReply(key, 401, "Unauthorized", this.serverName, new String[]{"WWW-Authenticate: BASIC realm=\"" + this.serverName + "\""}, "text/plain", throwable);
    }

    protected RestSession newRestSession(Long sessionId, String username, String password) throws Exception {
        Class<?> clazz = Class.forName(this.restSessionClassName);
        RestSession session = (RestSession)clazz.newInstance();
        session.init(this, sessionId, username, password);
        log.debug((Object)"newRestSession() ok.");
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long generateNewSessionId() {
        Long l = this.lastGivenId;
        synchronized (l) {
            long id;
            for (id = System.currentTimeMillis(); id <= this.lastGivenId; ++id) {
            }
            this.lastGivenId = new Long(id);
            return this.lastGivenId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeOutSessions(long maxDelta) {
        log.debug((Object)"session cleaner waking up");
        long now = System.currentTimeMillis();
        Map map = this.sessions;
        synchronized (map) {
            ArrayList<Long> sessionsToRemove = new ArrayList<Long>(this.sessions.size());
            Iterator<Object> it = this.sessions.keySet().iterator();
            while (it.hasNext()) {
                Long sessionId = (Long)it.next();
                RestSession session = (RestSession)this.sessions.get(sessionId);
                long delta = now - session.getLastUsed();
                if (delta <= maxDelta) continue;
                log.debug((Object)("Removing session " + sessionId));
                sessionsToRemove.add(sessionId);
            }
            it = sessionsToRemove.iterator();
            while (it.hasNext()) {
                this.sessions.remove(it.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(Long sessionId) {
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.remove(sessionId);
        }
    }

    protected static Long extractSessionId(String firstLine) throws IOException {
        try {
            String value = RestUtils.extractFromLine(firstLine, "session");
            log.debug((Object)("extractSessionId() sessionId = \"" + value + "\""));
            return new Long(Long.parseLong(value));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String extractHeaderValue(String[] headers, String key) {
        String sKey = key.toLowerCase() + ": ";
        for (int i = 0; i < headers.length; ++i) {
            String line = headers[i];
            if (!line.toLowerCase().startsWith(sKey)) continue;
            return line.substring(key.length() + 2);
        }
        log.debug((Object)("extractHeaderValue() didn't find value for key '" + key + "'"));
        return null;
    }

    private static String print(String[] ss) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < ss.length; ++i) {
            sb.append("'");
            sb.append(ss[i]);
            sb.append("'");
            if (i >= ss.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean verify(SelectionKey key, String firstLine) {
        String[] ss = firstLine.split(" ");
        log.debug((Object)("ss is " + RestService.print(ss)));
        if (ss.length < 3) {
            NetUtils.httpReply(key, 400, "Bad request", this.serverName, null, "text/plain", "Incomplete HTTP request");
            return false;
        }
        String method = ss[0].toUpperCase();
        if (!method.equals("GET") && !method.equals("POST")) {
            NetUtils.httpReply(key, 405, "Method Not Allowed", this.serverName, null, "text/plain", "Method '" + method + "' not allowed.");
            return false;
        }
        if (!ss[1].startsWith("/" + this.serverName)) {
            NetUtils.httpReply(key, 404, "Not Found", this.serverName, null, "text/plain", "Object >" + ss[1] + "< not found.");
            return false;
        }
        if (!ss[2].startsWith("HTTP/")) {
            NetUtils.httpReply(key, 505, "HTTP Version not supported", this.serverName, null, "text/plain", "HTTP Version >" + ss[2] + "< not supported.");
            return false;
        }
        return true;
    }

    public static int extractNumericHeaderValue(String[] headers, String key) {
        String s = RestService.extractHeaderValue(headers, key);
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static int determineBytesToRead(String[] headers) {
        return RestService.extractNumericHeaderValue(headers, K_CONTENT_LENGTH);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

