/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.rmi;

import java.rmi.Remote;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import org.apache.log4j.Logger;

public class LocalRemoteService
extends AbstractService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$rmi$LocalRemoteService == null ? (class$openwfe$org$rmi$LocalRemoteService = LocalRemoteService.class$("openwfe.org.rmi.LocalRemoteService")) : class$openwfe$org$rmi$LocalRemoteService).getName());
    public static final String REMOTE_NAME = "remoteName";
    public static final String REMOTE_CLASS = "remoteClass";
    private String remoteName = null;
    private Class remoteClass = null;
    private Remote remote = null;
    static /* synthetic */ Class class$openwfe$org$rmi$LocalRemoteService;
    static /* synthetic */ Class class$openwfe$org$Service;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.localInit();
        String remoteName = "local." + this.remoteName;
        this.getContext().put(remoteName, this.remote);
        log.debug((Object)("init() Stored remote in context under name '" + remoteName + "'"));
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public Remote getRemote() {
        return this.remote;
    }

    public void stop() throws ServiceException {
        super.stop();
        this.getContext().put(this.remoteName, null);
    }

    protected void localInit() throws ServiceException {
        this.remoteName = MapUtils.getAsString(this.getParams(), REMOTE_NAME, this.getName());
        log.info((Object)("localInit() ServerName is set to '" + this.remoteName + "'"));
        String remoteClassName = MapUtils.getAsString(this.getParams(), REMOTE_CLASS);
        if (remoteClassName == null) {
            log.warn((Object)"localInit() Parameter 'remoteClass' is missing. Cannot start any rmi server.");
            throw new ServiceException("Parameter 'remoteClass' is missing. Cannot start any rmi server.");
        }
        try {
            this.remoteClass = Class.forName(remoteClassName);
            this.remote = (Remote)this.remoteClass.newInstance();
            if (!(this.remote instanceof Service)) {
                throw new ServiceException("Class '" + remoteClassName + "' must implement interface " + (class$openwfe$org$Service == null ? (class$openwfe$org$Service = LocalRemoteService.class$("openwfe.org.Service")) : class$openwfe$org$Service).getName() + ".");
            }
            ((Service)((Object)this.remote)).init("remote." + this.remoteName, this.getContext(), this.getParams());
        }
        catch (Throwable t) {
            throw new ServiceException("Failed to instantiate server. Cannot continue.", t);
        }
        log.info((Object)("localInit() server class is '" + remoteClassName + "'"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

