/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.sql.ds;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.sql.SqlUtils;
import org.apache.log4j.Logger;

public abstract class OwfeDataSource
extends AbstractService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$sql$ds$OwfeDataSource == null ? (class$openwfe$org$sql$ds$OwfeDataSource = OwfeDataSource.class$("openwfe.org.sql.ds.OwfeDataSource")) : class$openwfe$org$sql$ds$OwfeDataSource).getName());
    public static final String P_URL = "url";
    public static final String P_LOGIN_TIMEOUT = "loginTimeout";
    public static final String P_DO_NOT_CHECK_CONNECTION = "doNotCheckConnection";
    public static final String P_DATA_SOURCE = "dataSource";
    private DataSource dataSource = null;
    private long lastConnectionRelease = System.currentTimeMillis();
    private Connection sqlConnection = null;
    private boolean doNotCheckConnection = false;
    static /* synthetic */ Class class$openwfe$org$sql$ds$OwfeDataSource;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.doNotCheckConnection = MapUtils.getAsBoolean(serviceParams, P_DO_NOT_CHECK_CONNECTION, false);
        log.info((Object)("init() doNotCheckConnection is set to '" + this.doNotCheckConnection + "'"));
    }

    protected void setDataSource(DataSource ds) throws ServiceException {
        this.dataSource = ds;
        long lt = MapUtils.getAsTime(this.getParams(), P_LOGIN_TIMEOUT, -1L);
        if (lt < 0L) {
            return;
        }
        int timeout = (int)(lt / 1000L);
        try {
            this.dataSource.setLoginTimeout(timeout);
        }
        catch (SQLException se) {
            throw new ServiceException("Failed to set login timeout on wrapped datasource", se);
        }
    }

    protected Connection establishConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            log.debug((Object)("getConnection() (" + this.getClass().getName() + ")"));
            long start = System.currentTimeMillis();
            long delta = start - this.lastConnectionRelease;
            if (this.sqlConnection == null || delta > 3600000L || this.isConnectionInvalid()) {
                if (this.sqlConnection != null) {
                    log.debug((Object)"getConnection() closing old connection");
                    try {
                        this.sqlConnection.close();
                    }
                    catch (Throwable t) {
                        log.debug((Object)("getConnection() failed to close old connection " + t.toString()));
                    }
                }
                log.debug((Object)"getConnection() setting up new connection");
                this.sqlConnection = this.establishConnection();
                this.lastConnectionRelease = System.currentTimeMillis();
            }
            long elapsedTime = System.currentTimeMillis() - start;
            log.debug((Object)("getConnection() took " + elapsedTime + " ms"));
            return this.sqlConnection;
        }
    }

    public void releaseConnection() {
        log.debug((Object)"releaseConnection()");
        this.lastConnectionRelease = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnectionInvalid() {
        if (this.getConnectionValiditySqlCode() == null) {
            return false;
        }
        if (this.doNotCheckConnection) {
            return false;
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.sqlConnection.createStatement();
            rs = st.executeQuery(this.getConnectionValiditySqlCode());
        }
        catch (Throwable t) {
            boolean bl;
            try {
                log.info((Object)("isConnectionInvalid() Yes : " + t.toString()));
                bl = true;
            }
            catch (Throwable throwable) {
                SqlUtils.closeStatement(st, rs);
                throw throwable;
            }
            SqlUtils.closeStatement(st, rs);
            return bl;
        }
        SqlUtils.closeStatement(st, rs);
        log.debug((Object)"isConnectionInvalid() seems that con is valid.");
        return false;
    }

    public abstract String getConnectionValiditySqlCode();

    public void stop() throws ServiceException {
        log.debug((Object)"stop()");
        super.stop();
        this.lastConnectionRelease = -1L;
        if (this.sqlConnection != null) {
            try {
                this.sqlConnection.close();
                this.sqlConnection = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void logSQLException(String funcName, Logger logger, SQLException e) {
        while (e != null) {
            logger.error((Object)(funcName + "() SQLException : " + e.toString()));
            e = e.getNextException();
        }
    }

    public static OwfeDataSource lookupDataSource(ApplicationContext context, Map serviceParams) throws ServiceException {
        String dsKey = (String)serviceParams.get(P_DATA_SOURCE);
        if (dsKey == null) {
            dsKey = P_DATA_SOURCE;
        }
        log.debug((Object)("lookupDataSource() looking for data source named '" + dsKey + "'"));
        OwfeDataSource ds = (OwfeDataSource)context.lookup(dsKey);
        if (ds == null) {
            throw new ServiceException("No OwfeDataSource stored as service named '" + dsKey + "'");
        }
        return ds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

