/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class Time {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$time$Time == null ? (class$openwfe$org$time$Time = Time.class$("openwfe.org.time.Time")) : class$openwfe$org$time$Time).getName());
    public static final SimpleDateFormat SDF_ISO_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
    public static final SimpleDateFormat SDF_ISO_DATE_SHORT = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{SDF_ISO_DATE, SDF_ISO_DATE_SHORT, new SimpleDateFormat("yy-MM-dd HH:mm:ss"), new SimpleDateFormat("dd-MM-yy"), new SimpleDateFormat("dd-MM-yy HH:mm:ss")};
    static /* synthetic */ Class class$openwfe$org$time$Time;

    public static long parseTimeString(String time) {
        time = time.trim();
        int index = -1;
        long result = 0L;
        String number = "";
        while (true) {
            if (++index >= time.length()) {
                if (number.length() <= 0) break;
                result += (long)Integer.parseInt(number);
                break;
            }
            char c = time.charAt(index);
            if (Character.isDigit(c)) {
                number = number + c;
                continue;
            }
            long value = Long.parseLong(number);
            number = "";
            if (c == 'y') {
                result += value * 365L * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'M') {
                result += value * 30L * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'w') {
                result += value * 7L * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'd') {
                result += value * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'h') {
                result += value * 3600L * 1000L;
                continue;
            }
            if (c == 'm') {
                result += value * 60L * 1000L;
                continue;
            }
            if (c == 's') {
                result += value * 1000L;
                continue;
            }
            result += value;
        }
        return result;
    }

    public static Date parseDate(String s) {
        if (s == null) {
            return null;
        }
        String sDate = s.trim();
        sDate = sDate.replace('/', '-');
        sDate = sDate.replace('.', '-');
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                Date d = dateFormats[i].parse(sDate);
                return d;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return null;
    }

    public static String toIsoDate(long time) {
        Date d = new Date(time);
        return SDF_ISO_DATE.format(d);
    }

    public static String toIsoDate() {
        return Time.toIsoDate(System.currentTimeMillis());
    }

    public static long fromIsoDate(String sDate) throws ParseException {
        return SDF_ISO_DATE.parse(sDate).getTime();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

