/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ReflectionUtils;
import openwfe.org.xml.XmlCodingException;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;

public abstract class XmlCoder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$xml$XmlCoder == null ? (class$openwfe$org$xml$XmlCoder = XmlCoder.class$("openwfe.org.xml.XmlCoder")) : class$openwfe$org$xml$XmlCoder).getName());
    private static final String E_INSTANCE = "instance";
    private static final String E_FIELD = "field";
    private static final String E_ARRAY = "array";
    private static final String E_PRIMITIVE = "primitive";
    private static final String E_MAP = "map";
    private static final String E_COLLECTION = "collection";
    private static final String E_NULL = "null";
    private static final String E_JDOM = "jdom";
    private static final String E_ENTRY = "entry";
    private static final String A_CLASS = "class";
    private static final String A_SIZE = "size";
    private static final String A_NAME = "name";
    private static final String IS = "is";
    private static final String SET = "set";
    static /* synthetic */ Class class$openwfe$org$xml$XmlCoder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;

    private static boolean isPrimitive(Object instance) {
        Class<?> clazz = instance.getClass();
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = XmlCoder.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = XmlCoder.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return true;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = XmlCoder.class$("java.lang.Long")) : class$java$lang$Long)) {
            return true;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = XmlCoder.class$("java.lang.Short")) : class$java$lang$Short)) {
            return true;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = XmlCoder.class$("java.lang.Float")) : class$java$lang$Float)) {
            return true;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = XmlCoder.class$("java.lang.Double")) : class$java$lang$Double)) {
            return true;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlCoder.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return true;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = XmlCoder.class$("java.lang.Character")) : class$java$lang$Character)) {
            return true;
        }
        return clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = XmlCoder.class$("java.lang.Byte")) : class$java$lang$Byte);
    }

    private static void encodeField(Object instance, Element container, Method getMethod) throws Exception {
        Element eField = new Element(E_FIELD);
        String getMethodName = getMethod.getName();
        String rawFieldName = getMethodName.substring(3);
        if (getMethodName.startsWith(IS)) {
            rawFieldName = getMethodName.substring(2);
        }
        eField.setAttribute(A_NAME, rawFieldName);
        Object[] args = null;
        Object value = getMethod.invoke(instance, args);
        eField.addContent((Content)XmlCoder.encode(value));
        container.addContent((Content)eField);
    }

    private static Element encodePrimitive(Object value) {
        Element result = new Element(E_PRIMITIVE);
        result.setAttribute(A_CLASS, value.getClass().getName());
        result.addContent((Content)new Text(value.toString()));
        return result;
    }

    private static Element encodeArray(Object array) throws Exception {
        Element result = new Element(E_ARRAY);
        Object firstEltClass = null;
        boolean isHomogeneous = true;
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object elt = Array.get(array, i);
            result.addContent((Content)XmlCoder.encode(elt));
        }
        result.setAttribute(A_SIZE, "" + Array.getLength(array));
        return result;
    }

    private static Element encodeMap(Object map) throws Exception {
        Map theMap = (Map)map;
        Element result = new Element(E_MAP);
        result.setAttribute(A_CLASS, map.getClass().getName());
        Iterator it = theMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = theMap.get(key);
            Element eEntry = new Element(E_ENTRY);
            eEntry.addContent((Content)XmlCoder.encode(key));
            eEntry.addContent((Content)XmlCoder.encode(value));
            result.addContent((Content)eEntry);
        }
        return result;
    }

    private static Element encodeCollection(Object col) throws Exception {
        Element result = new Element(E_COLLECTION);
        result.setAttribute(A_CLASS, col.getClass().getName());
        Iterator it = ((Collection)col).iterator();
        while (it.hasNext()) {
            result.addContent((Content)XmlCoder.encode(it.next()));
        }
        return result;
    }

    private static Element encodeJdomElement(Object o) {
        Element result = new Element(E_JDOM);
        Element elt = (Element)o;
        elt.detach();
        result.addContent((Content)elt);
        return result;
    }

    public static String encodeToString(Object bean, String encoding) throws XmlCodingException {
        Document doc = new Document(XmlCoder.encode(bean));
        return XmlUtils.toString(doc, encoding);
    }

    public static String encodeToString(Object bean) throws XmlCodingException {
        return XmlCoder.encodeToString(bean, null);
    }

    public static Element encode(Object bean) throws XmlCodingException {
        if (bean == null) {
            return new Element(E_NULL);
        }
        try {
            if (bean.getClass().isArray()) {
                return XmlCoder.encodeArray(bean);
            }
            if ((class$java$util$Map == null ? (class$java$util$Map = XmlCoder.class$("java.util.Map")) : class$java$util$Map).isInstance(bean)) {
                return XmlCoder.encodeMap(bean);
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = XmlCoder.class$("java.util.Collection")) : class$java$util$Collection).isInstance(bean)) {
                return XmlCoder.encodeCollection(bean);
            }
            if (XmlCoder.isPrimitive(bean)) {
                return XmlCoder.encodePrimitive(bean);
            }
            if (bean instanceof Element) {
                return XmlCoder.encodeJdomElement(bean);
            }
        }
        catch (Exception e) {
            throw new XmlCodingException("Encoding failure for bean of class '" + bean.getClass().getName() + "'", e);
        }
        Element result = new Element(E_INSTANCE);
        result.setAttribute(A_CLASS, bean.getClass().getName());
        Iterator it = ReflectionUtils.listReadWriteFields(bean).iterator();
        while (it.hasNext()) {
            Method[] methods = (Method[])it.next();
            try {
                XmlCoder.encodeField(bean, result, methods[0]);
            }
            catch (Exception e) {
                throw new XmlCodingException("Failed to encode field behind getter '" + methods[0].getName() + "' for bean of class '" + bean.getClass().getName() + "'", e);
            }
        }
        return result;
    }

    private static Class getClass(Element elt) throws ClassNotFoundException {
        String classname = elt.getAttributeValue(A_CLASS);
        return Class.forName(classname);
    }

    private static int getSize(Element elt) {
        String sSize = elt.getAttributeValue(A_SIZE);
        try {
            return Integer.parseInt(sSize);
        }
        catch (Exception e) {
            return 10;
        }
    }

    private static Object decodeArray(Element elt) throws Exception {
        Object[] result = new Object[XmlCoder.getSize(elt)];
        int i = 0;
        Iterator it = elt.getChildren().iterator();
        while (it.hasNext()) {
            result[i] = XmlCoder.decode((Element)it.next());
            ++i;
        }
        return result;
    }

    private static Object decodeMap(Element elt) throws Exception {
        Map result = (Map)XmlCoder.getClass(elt).newInstance();
        Iterator it = elt.getChildren().iterator();
        while (it.hasNext()) {
            Element eEntry = (Element)it.next();
            Object key = XmlCoder.decode((Element)eEntry.getChildren().get(0));
            Object value = XmlCoder.decode((Element)eEntry.getChildren().get(1));
            result.put(key, value);
        }
        return result;
    }

    private static Object decodeCollection(Element elt) throws Exception {
        Collection result = (Collection)XmlCoder.getClass(elt).newInstance();
        Iterator it = elt.getChildren().iterator();
        while (it.hasNext()) {
            result.add(XmlCoder.decode((Element)it.next()));
        }
        return result;
    }

    private static Object invokeStringConstructor(Class primitiveClass, String value) throws Exception {
        Constructor c = primitiveClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = XmlCoder.class$("java.lang.String")) : class$java$lang$String);
        return c.newInstance(value);
    }

    private static Object decodePrimitive(Element elt) throws Exception {
        Class clazz = XmlCoder.getClass(elt);
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = XmlCoder.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character(elt.getText().charAt(0));
        }
        return XmlCoder.invokeStringConstructor(clazz, elt.getText());
    }

    private static Object decodeJdomElement(Element elt) throws Exception {
        return elt.getChildren().get(0);
    }

    public static Object decode(Document doc) throws XmlCodingException {
        return XmlCoder.decode(doc.getRootElement());
    }

    public static Object decode(Element elt) throws XmlCodingException {
        if (elt.getName().equals(E_NULL)) {
            return null;
        }
        try {
            Object value;
            if (elt.getName().equals(E_ARRAY)) {
                return XmlCoder.decodeArray(elt);
            }
            if (elt.getName().equals(E_MAP)) {
                return XmlCoder.decodeMap(elt);
            }
            if (elt.getName().equals(E_COLLECTION)) {
                return XmlCoder.decodeCollection(elt);
            }
            if (elt.getName().equals(E_PRIMITIVE)) {
                return XmlCoder.decodePrimitive(elt);
            }
            if (elt.getName().equals(E_JDOM)) {
                return XmlCoder.decodeJdomElement(elt);
            }
            Class clazz = XmlCoder.getClass(elt);
            Object result = clazz.newInstance();
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            Iterator it = elt.getChildren(E_FIELD).iterator();
            while (it.hasNext()) {
                Element eField = (Element)it.next();
                String rawFieldName = eField.getAttributeValue(A_NAME);
                Element eValue = (Element)eField.getChildren().get(0);
                value = XmlCoder.decode(eValue);
                fieldMap.put(SET + rawFieldName, value);
            }
            it = ReflectionUtils.listReadWriteFields(clazz).iterator();
            while (it.hasNext()) {
                Method[] ms = (Method[])it.next();
                Method setMethod = ms[1];
                String setMethodName = setMethod.getName();
                value = fieldMap.get(setMethodName);
                try {
                    setMethod.invoke(result, value);
                }
                catch (Throwable t) {
                    log.warn((Object)("decode() failed to invoke '" + setMethodName + "' on bean of class '" + clazz.getName() + "'. Continuing anyway..."), t);
                }
            }
            return result;
        }
        catch (Throwable t) {
            throw new XmlCodingException("Failed to decode elt named '" + elt.getName() + "'", t);
        }
    }

    public static Object load(String fileName) throws IOException, JDOMException, XmlCodingException {
        return XmlCoder.decode(XmlUtils.extractXml(fileName, false));
    }

    public static Object load(URL fileUrl) throws IOException, JDOMException, XmlCodingException {
        return XmlCoder.decode(XmlUtils.extractXml(fileUrl, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String fileName, Object bean) throws IOException, XmlCodingException {
        FileOutputStream fos = null;
        try {
            Document doc = new Document(XmlCoder.encode(bean));
            fos = new FileOutputStream(fileName);
            XmlUtils.getXMLOutputter().output(doc, (OutputStream)fos);
            fos.flush();
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

