/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.OpenWfeException;
import openwfe.org.Service;
import openwfe.org.Utils;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class XmlUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$xml$XmlUtils == null ? (class$openwfe$org$xml$XmlUtils = XmlUtils.class$("openwfe.org.xml.XmlUtils")) : class$openwfe$org$xml$XmlUtils).getName());
    static /* synthetic */ Class class$openwfe$org$xml$XmlUtils;

    public static Element extractXml(String docUrl, boolean validate) throws JDOMException, IOException {
        log.debug((Object)("extractXml(sUrl) docUrl is >" + docUrl + "<"));
        if (docUrl.startsWith("resource:")) {
            InputStream is = (class$openwfe$org$xml$XmlUtils == null ? (class$openwfe$org$xml$XmlUtils = XmlUtils.class$("openwfe.org.xml.XmlUtils")) : class$openwfe$org$xml$XmlUtils).getResourceAsStream(docUrl.substring(9));
            return XmlUtils.extractXml(is, validate);
        }
        docUrl = Utils.ensureProtocol(docUrl);
        log.debug((Object)("extractXml(sUrl) docUrl is >" + docUrl + "<"));
        return XmlUtils.extractXml(new URL(docUrl), validate);
    }

    public static Element extractXml(InputStream is, boolean validate) throws JDOMException, IOException {
        log.debug((Object)"extractXml(is)");
        SAXBuilder builder = XmlUtils.getSAXBuilder(validate);
        Document doc = builder.build(is);
        return doc.getRootElement();
    }

    public static Element extractXml(File file, boolean validate) throws JDOMException, IOException {
        log.debug((Object)("extractXml(file) " + file.getName()));
        SAXBuilder builder = XmlUtils.getSAXBuilder(validate);
        Document doc = builder.build((InputStream)new FileInputStream(file));
        return doc.getRootElement();
    }

    public static Element extractXml(URL docUrl, boolean validate) throws JDOMException, IOException {
        log.debug((Object)("extractXml(url) " + docUrl.toString()));
        SAXBuilder builder = XmlUtils.getSAXBuilder(validate);
        Document doc = builder.build(docUrl);
        return doc.getRootElement();
    }

    public static Element extractXml(URLConnection uc, boolean validate) throws JDOMException, IOException {
        log.debug((Object)("extractXml(uc) " + uc.getURL().toString()));
        SAXBuilder builder = XmlUtils.getSAXBuilder(validate);
        Document doc = builder.build(uc.getInputStream());
        return doc.getRootElement();
    }

    public static Document extractXmlDocument(String xmlDocument, boolean validate) throws JDOMException, IOException {
        SAXBuilder builder = XmlUtils.getSAXBuilder(validate);
        StringReader sReader = new StringReader(xmlDocument);
        return builder.build((Reader)sReader);
    }

    public static Element extractXmlElement(String rawXml) throws JDOMException, IOException {
        Document doc = XmlUtils.extractXmlDocument(rawXml, false);
        Element elt = doc.getRootElement();
        elt.detach();
        return elt;
    }

    public static Map fetchAttributes(Element elt) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator it = elt.getAttributes().iterator();
        while (it.hasNext()) {
            Attribute att = (Attribute)it.next();
            result.put(att.getName(), att.getValue());
        }
        return result;
    }

    public static byte[] toByteArray(Element elt) throws OpenWfeException {
        byte[] result = XmlUtils.toByteArray(new Document(elt));
        elt.detach();
        return result;
    }

    public static byte[] toByteArray(Document doc) throws OpenWfeException {
        XMLOutputter out = XmlUtils.getXMLOutputter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            out.output(doc, (OutputStream)baos);
            baos.write(10);
            baos.flush();
        }
        catch (IOException ie) {
            throw new OpenWfeException("Failed to encode workitem as xml", ie);
        }
        return baos.toByteArray();
    }

    public static XMLOutputter getXMLOutputter(String encoding) {
        Format format = Format.getPrettyFormat();
        if (encoding == null) {
            encoding = Utils.getEncoding();
        }
        format.setEncoding(encoding);
        return new XMLOutputter(format);
    }

    public static XMLOutputter getXMLOutputter() {
        return XmlUtils.getXMLOutputter(null);
    }

    public static String toString(Document doc) {
        return XmlUtils.toString(doc, null);
    }

    public static String toString(Document doc, String encoding) {
        if (encoding == null) {
            encoding = Utils.getEncoding();
        }
        XMLOutputter out = XmlUtils.getXMLOutputter(encoding);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            out.output(doc, (OutputStream)baos);
            baos.write(10);
            baos.flush();
            return baos.toString(encoding);
        }
        catch (IOException ie) {
            log.warn((Object)"Failed to encode workitem as xml", (Throwable)ie);
            return "";
        }
    }

    public static String toString(Content c) {
        boolean hasParent;
        if (c instanceof Text) {
            return ((Text)c).getTextTrim();
        }
        Element elt = (Element)c;
        boolean bl = hasParent = elt.getParent() != null;
        if (hasParent) {
            elt = (Element)elt.clone();
        }
        String result = XmlUtils.toString(new Document(elt), null);
        if (!hasParent) {
            elt.detach();
        }
        return result;
    }

    public static Element getClassElt(Service s) {
        Element result = new Element("class");
        if (s == null) {
            result.addContent("null");
        } else {
            result.addContent(s.getClass().getName());
        }
        return result;
    }

    public static Element getRevisionElt(String revId) {
        Element result = new Element("revision");
        if (revId == null) {
            result.addContent("null");
        } else {
            result.addContent(revId);
        }
        return result;
    }

    public static void setAttributes(Element elt, Map attributes) {
        if (elt == null) {
            return;
        }
        if (attributes == null) {
            return;
        }
        Iterator it = attributes.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            String value = attributes.get(key).toString();
            elt.setAttribute(key, value);
        }
    }

    public static String dumpContent(Element elt) {
        StringBuffer sb = new StringBuffer();
        sb.append("  --" + elt.getName() + "--\n");
        Iterator it = elt.getAttributes().iterator();
        while (it.hasNext()) {
            Attribute at = (Attribute)it.next();
            sb.append("     - " + at.getName() + "='" + at.getValue() + "'\n");
        }
        it = elt.getContent().iterator();
        while (it.hasNext()) {
            Object c = it.next();
            if (c instanceof Element) {
                Element e = (Element)c;
                sb.append("   * --" + e.getName() + "--\n");
                continue;
            }
            sb.append("   * " + c.getClass().getName() + "\n");
        }
        return sb.toString();
    }

    public static SAXBuilder getSAXBuilder(boolean validate) {
        if (!validate) {
            return new SAXBuilder(false);
        }
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        return builder;
    }

    public static Element getFirstChild(Element elt) {
        return XmlUtils.getChild(elt, 0);
    }

    public static Element getChild(Element elt, int childIndex) {
        if (elt == null) {
            return null;
        }
        int pos = 0;
        Iterator it = elt.getContent().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Element)) continue;
            if (pos == childIndex) {
                return (Element)o;
            }
            ++pos;
        }
        return null;
    }

    public static String fetchTextContent(Element elt) {
        if (elt.getContent().size() < 1) {
            return "";
        }
        Iterator it = elt.getContent().iterator();
        while (it.hasNext()) {
            Object content = it.next();
            if (content instanceof Text) {
                return ((Text)content).getTextTrim();
            }
            if (!(content instanceof CDATA)) continue;
            return ((CDATA)content).getTextTrim();
        }
        return null;
    }

    public static String fetchCdataContent(Element elt) {
        if (elt.getContent().size() < 1) {
            return "";
        }
        Iterator it = elt.getContent().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof CDATA)) continue;
            return ((CDATA)o).getTextTrim();
        }
        return null;
    }

    public static String dump(String prefix, Element elt) {
        try {
            return Utils.dump(prefix, XmlUtils.toByteArray(elt));
        }
        catch (Throwable t) {
            log.debug((Object)"dump() failure", t);
            return null;
        }
    }

    public static String dump(String prefix, Document doc) {
        try {
            return Utils.dump(prefix, XmlUtils.toByteArray(doc));
        }
        catch (Throwable t) {
            log.debug((Object)"dump() failure", t);
            return null;
        }
    }

    public static String removeHeaderLine(String sXml) {
        if (!sXml.startsWith("<?xml")) {
            return sXml;
        }
        int i = sXml.indexOf(">");
        String s = sXml.substring(i + 1);
        return s.trim();
    }

    public static String xmlToString(Content c) {
        return XmlUtils.removeHeaderLine(XmlUtils.toString(c));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

