/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Parameters.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// Parameters.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org;

import java.util.Collections;


/**
 * Methods for extracting parameters from XML files or SQL db
 * (perhaps LDAP directories in the near future)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: Parameters.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class Parameters
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Parameters.class.getName());

    /**
     * Takes an XML element and parses its "params" children
     */
    public static java.util.Map extractParameters (final org.jdom.Element elt)
    {
        return extractParameters(elt.getChildren("param"));
    }

    /**
     * Extract parameters from a list of org.jdom.Element
     */
    public static java.util.Map extractParameters 
        (final java.util.List elements)
    {
        java.util.Map result = new java.util.HashMap();

        java.util.Iterator it = elements.iterator();
        while (it.hasNext())
        {
            org.jdom.Element param = (org.jdom.Element)it.next();

            if ( ! param.getName().equals("param")) continue;

            //
            // 1st priority style
            //
            // <param
            //     name="x"
            //     value="y"
            // />

            String paramName = param.getAttributeValue("name");
            Object paramValue = param.getAttributeValue("value");

            //
            // 2nd priority style
            //
            // <param>
            //     <param-name>x</param-name>
            //     <param-value>y</param-value>
            // </param>

            if (paramName == null)
            {
                paramName = param.getChildTextTrim("param-name");
                paramValue = param.getChildTextTrim("param-value");
            }

            paramName = paramName.trim();
            paramValue = ((String)paramValue).trim();

            /*
            System.out.println("--param");
            System.out.println("---name >"+paramName+"<");
            System.out.println("---value >"+paramValue+"<");
            */

            Object currentValue = result.get(paramName);
            if (currentValue != null)
            {
                if (currentValue instanceof String)
                {
                    String s = (String)currentValue;
                    currentValue = new java.util.ArrayList(10);
                    ((java.util.List)currentValue).add(s);
                }

                java.util.List valueList = (java.util.List)currentValue;
                valueList.add(paramValue);

                paramValue = valueList;
            }

            result.put(paramName, paramValue);
        }

        return Collections.unmodifiableMap(result);
    }

    /**
     * Sometimes parameters are attributes of an XML element...
     * Use this method to take them as a Map
     */
    public static java.util.Map extractAttributes (final org.jdom.Element e)
    {
        java.util.Map result = new java.util.HashMap(e.getAttributes().size());

        java.util.Iterator it = e.getAttributes().iterator();
        while (it.hasNext())
        {
            org.jdom.Attribute a = (org.jdom.Attribute)it.next();

            String key = a.getName();
            String value = a.getValue();

            result.put(key, value);
        }

        return result;
    }

    /**
     * mixes parameters and xml attributes in one map
     */
    public static java.util.Map extractParamsAndAttributes 
        (final org.jdom.Element e)
    {
        final java.util.Map result = extractAttributes(e);
        result.putAll(extractParameters(e));

        return result;
    }

    /**
     * Adds the content of the param map as attributes to the XML element
     */
    public static void encodeAsAttributes 
        (final org.jdom.Element e, final java.util.Map params)
    {
        final java.util.Iterator it = params.keySet().iterator();
        while (it.hasNext())
        {
            Object oKey = it.next();
            String key = oKey.toString();
            String value = params.get(oKey).toString();

            e.setAttribute(key, value);
        }
    }

}
