/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: BasicLoginModule.java 1889 2005-06-14 13:17:26Z jmettraux $
 */

//
// BasicLoginModule.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.auth;

import java.security.NoSuchAlgorithmException;
import javax.security.auth.login.LoginException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

import openwfe.org.misc.ByteUtils;


/**
 * The login module for BasicPrincipal...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-06-14 15:17:26 +0200 (Tue, 14 Jun 2005) $
 * <br>$Id: BasicLoginModule.java 1889 2005-06-14 13:17:26Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class BasicLoginModule

    extends LoginModule

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(BasicLoginModule.class.getName());

    //
    // CONSTANTS and definitions

    public final static String DIGEST_ALGORITHM = "MD5";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    public static String digestPassword (String pass)
        throws NoSuchAlgorithmException
    {
        java.security.MessageDigest digest = java.security.MessageDigest
            .getInstance(DIGEST_ALGORITHM);

        digest.update(pass.getBytes());

        return ByteUtils.toString(digest.digest());
    }

    public boolean login () 
        throws LoginException
    {
        if (this.policyService == null)
        {
            throw new LoginException
                ("No policy service. "+
                 "Check application log for details");
        }

        //
        // prompt for username and password
        
        NameCallback nameCb = new NameCallback("username");
        PasswordCallback passCb = new PasswordCallback("password", false);

        try
        {
            this.handler.handle(new Callback[] { nameCb, passCb });
        }
        catch (Exception e)
        {
            log.debug
                ("Failed to gather user credentials", e);
            throw new LoginException
                ("Failed to gather user credentials");
        }

        //
        // get name and pass
        
        String userName = nameCb.getName();
        String pass = new String(passCb.getPassword());

        try
        {
            pass = digestPassword(pass);
        }
        catch (NoSuchAlgorithmException nsae)
        {
            log.warn("hash algo not found", nsae);
            throw new LoginException(""+nsae);
        }

        //
        // allow or deny

        this.principal = null;
        try
        {
            this.principal = this.policyService.authentify(userName, pass);

            //log.debug("Login success for\n"+this.principal.toString());
        }
        catch (final AuthException ae)
        {
            log.info
                ("LoginException : Failed to authentify user", ae);
            throw new LoginException
                ("Failed to authentify user because of \""+ae+"\"");
        }

        this.succeeded = (this.principal != null);

        return this.succeeded;
    }

    //
    // utilities...

    public static void main (String[] args)
    {
        if (args.length < 1)
        {
            System.out.println();
            System.out.println("USAGE :");
            System.out.println();
            System.out.println("genpass password");
            System.out.println();
            System.out.print("will output the password, but hashed.");
            System.out.println();
            System.exit(0);
        }

        try
        {
            System.out.println(digestPassword(args[0]));
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }

}
