/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: BasicPrincipal.java 2247 2005-11-30 09:19:53Z jmettraux $
 */

//
// BasicPrincipal.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.auth;

import java.util.Collections;
import javax.security.auth.Subject;


/**
 * A principal that can be granted permissions, our little extension to 
 * JAAS. Grants may be considered as sets of permissions.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-11-30 10:19:53 +0100 (Wed, 30 Nov 2005) $
 * <br>$Id: BasicPrincipal.java 2247 2005-11-30 09:19:53Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class BasicPrincipal

    implements Principal

{

    static final long serialVersionUID = -3421084984894408642L;

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(BasicPrincipal.class.getName());

    //
    // CONSTANTS and definitions

    public final static String NAME = "name";
    public final static String CLASS = "class";
    public final static String PASSWORD = "password";
    public final static String GRANTS = "grants";

    //
    // FIELDS

    private String name = null;
    private java.util.Set grants = null;

    private /*transient*/ String hashedPassword = null;
    private java.util.Map initParameters = null;

    //
    // CONSTRUCTORS

    public BasicPrincipal ()
    {
        //openwfe.org.Utils.logStackTrace(log, "new");

        this.grants = new java.util.HashSet(0);
    }

    public void init (final java.util.Map initParams)
        throws AuthException
    {
        java.util.HashMap m = new java.util.HashMap(initParams);
        m.put(CLASS, this.getClass().getName());

        this.initParameters = Collections.unmodifiableMap(m);

        try
        {
            this.name = (String)initParams.get(NAME);
            this.hashedPassword = (String)initParams.get(PASSWORD);

            //log.debug
            //    ("init() is hashedPassword null ? "+
            //     (this.hashedPassword == null));

            final Object o = initParams.get(GRANTS);
            if (o != null) this.grants = (java.util.Set)o;
        }
        catch (final ClassCastException cce)
        {
            throw new AuthException
                ("init failed", cce);
        }

        log.debug("init() initted '"+this.name+"'");

        //
        // mandatory fields
        
        if (this.name == null)
        {
            throw new AuthException
                ("Parameter '"+NAME+"' is missing for Principal building");
        }
        if (this.grants == null)
        {
            this.grants = new java.util.HashSet();
        }
    }

    //
    // METHODS from java.security.Principal

    /**
     * Compares this principal to the specified object.  Returns true
     * if the object passed in matches the principal represented by
     * the implementation of this interface.
     *
     * @param another principal to compare with.
     *
     * @return true if the principal passed in is the same as that
     * encapsulated by this principal, and false otherwise.
     */
    public boolean equals (Object another)
    {
        if (another == null) return false;

        BasicPrincipal other = null;
        try
        {
            other = (BasicPrincipal)another;
        }
        catch (Exception e)
        {
            return false;
        }

        //log.debug("this.name  >"+this.name+"<");
        //log.debug("other.name >"+other.name+"<");
        //log.debug("this.grants  != null is "+(this.grants != null));
        //log.debug("other.grants != null is "+(other.grants != null));

        if ( ! this.name.equals(other.name)) return false;

        if (this.grants.size() != other.grants.size()) return false;

        java.util.Iterator it = this.grants.iterator();
        while (it.hasNext())
        {
            String grantName = (String)it.next();

            if ( ! other.grants.contains(grantName))
                return false;
        }

        return true;
    }

    public String toString ()
    {
        StringBuffer sb = new StringBuffer();

        sb.append("<"); sb.append(this.getClass().getName()); sb.append("\n");
        sb.append("  name=\""); sb.append(this.name); sb.append("\" \n");
        sb.append("> \n");

        java.util.Iterator it = this.grants.iterator();
        while (it.hasNext())
        {
            String grantName = (String)it.next();
            sb.append("  <grant name=\"");
            sb.append(grantName);
            sb.append("\" /> \n");
        }

        sb.append("</"); sb.append(this.getClass().getName()); sb.append(">");

        return sb.toString();
    }

    public int hashCode ()
    {
        return this.name.hashCode();
    }

    public String getName ()
    {
        return this.name;
    }

    public void setName (String s)
    {
        this.name = s;
    }

    public void setHashedPassword (final String hashedPassword)
    {
        this.hashedPassword = hashedPassword;

        //log.debug
        //    ("setHashedPassword() is hashedPassword null ? "+
        //     (this.hashedPassword == null));
    }

    /**
     * Returns true if this principal is just a copy (given upon a 
     * successful authentification).
     */
    public boolean isCopy ()
    {
        return (this.hashedPassword == null);
    }
    
    //
    // METHODS from openwfe.org.auth.Principal

    /**
     * In this implementation the 'credentials are just the
     * already hashed password
     */
    public boolean authentify (final Object credentials)
        throws AuthException
    {
        if (this.hashedPassword == null)
        {
            throw new AuthException
                ("Cannot authentify Principal against a principal copy");
        }

        //log.debug("credentials    : >"+credentials+"<");
        //log.debug("hashedPassword : >"+this.hashedPassword+"<");

        return 
            (this.hashedPassword.equals(credentials));
    }

    public java.util.Set getGrants ()
    {
        return this.grants;
    }

    /**
     * returns a clone of this Principal without the authentification 
     * credentials (auth has just been done, and the returned principal
     * is meant to be stored in a Subject)
     */
    public Principal getWorkCopy ()
    {
        final BasicPrincipal bp = new BasicPrincipal();

        fill(bp);
        bp.hashedPassword = null;

        return bp;
    }

    public void addGrant (String grantName)
    {
        if ( ! this.grants.contains(grantName))
            this.grants.add(grantName);
    }

    public void removeGrant (String grantName)
    {
        this.grants.remove(grantName);
    }

    public java.util.Map getInitParameters ()
    {
        return this.initParameters;
    }

    //
    // METHODS

    /**
     * fills other with these values
     */
    public void fill (final BasicPrincipal other)
    {
        other.name = this.name;
        other.hashedPassword = this.hashedPassword;
        other.grants = this.grants;

        //log.debug("other.name is >"+other.name+"<");
    }

    public String getHashedPassword () { return this.hashedPassword; }

    //
    // STATIC METHODS

    /**
     * A convenience method : returns the first basic principal
     * found in the given subject.
     */
    public static BasicPrincipal getBasicPrincipal (final Subject s)
    {
        java.util.Set set = s.getPrincipals(BasicPrincipal.class);

        java.util.Iterator it = set.iterator();

        BasicPrincipal principal = (BasicPrincipal)it.next();

        return principal;
    }

    /**
     * Returns the basic principal as found in the subject of the
     * current access control context if any.
     */
    public static BasicPrincipal getBasicPrincipal ()
    {
        Subject subject = Subject.getSubject
            (java.security.AccessController.getContext());
        return getBasicPrincipal(subject);
    }

}
