/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlToSql.java 1945 2005-07-13 20:53:40Z jmettraux $
 */

//
// XmlToSql.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.auth.sql;

import openwfe.org.ApplicationContext;
import openwfe.org.sql.ds.OwfeDataSource;
import openwfe.org.sql.ds.MysqlDataSource;
import openwfe.org.auth.Grant;
import openwfe.org.auth.Passwd;
import openwfe.org.auth.Principal;
import openwfe.org.auth.xml.XmlPasswdCodec;


/**
 * Some utility code for transforming a passwd.xml file into a set of 
 * SQL records.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlToSql.java 1945 2005-07-13 20:53:40Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class XmlToSql
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlToSql.class.getName());


    private static void printUsage (final String[] args)
    {
        String command = XmlToSql.class.getName();
        if (args.length > 0) command = args[0];

        System.out.println("");
        System.out.println("  USAGE");
        System.out.println("");
        System.out.println("  "+command+" {path.to.passwd.xml}");
        System.out.println("");
    }

    public static void main (final String[] args)
        throws Exception
    {
        if (args.length < 2)
        {
            printUsage(args);
            return;
        }

        String xmlPasswdUrl = args[1];
        if (xmlPasswdUrl.indexOf(":") < 0)
            xmlPasswdUrl = "file:"+xmlPasswdUrl;

        final XmlPasswdCodec xmlCodec = new XmlPasswdCodec();

        //xmlCodec.init(context, params);

        Passwd passwd = 
            xmlCodec.decodePasswd(new java.net.URL(xmlPasswdUrl));

        //
        // transfer to database
        
        final ApplicationContext context = new ApplicationContext();

        final java.util.Map dsParams = new java.util.HashMap(1);
        dsParams.put
            (OwfeDataSource.P_URL, 
             "jdbc:mysql://127.0.0.1/powfe?user=powfe&password=powfe");
        final OwfeDataSource ds = new MysqlDataSource();
        ds.init(null, null, dsParams);

        context.put("dataSource", ds);

        final java.util.Map scParams = new java.util.HashMap(1);
        scParams.put(OwfeDataSource.P_DATA_SOURCE, "dataSource");
        
        final SqlPasswdCodec sqlCodec = new SqlPasswdCodec();

        sqlCodec.init(context, scParams);

        sqlCodec.encodePasswd(passwd);

        log.debug("transfer done.");

        //
        // reload
        
        //final Passwd passwd = sqlCodec.decodePasswd(null, context, scParams);
        //passwd = sqlCodec.decodePasswd(null, context, scParams);
        passwd = sqlCodec.decodePasswd();

        // list grants

        java.util.Iterator it = 
            passwd.getGrantMap().values().iterator();
        while (it.hasNext())
        {
            final Grant grant = (Grant)it.next();
            System.out.println
                ("   **** grant '"+grant.getName()+"' ****");
            System.out.println
                ("        codesource is "+grant.getCodeSource());

            final java.util.Iterator jt = 
                grant.getPermissionValues().iterator();
            while (jt.hasNext())
                System.out.println(jt.next().toString());

            System.out.println();
        }
        System.out.println("\n\n");

        // list principals

        it = passwd.getPrincipalMap().values().iterator();
        while (it.hasNext())
        {
            final Principal principal = (Principal)it.next();
            System.out.println
                ("   **** principal '"+principal.getName()+"' ****");

            final java.util.Iterator jt = principal.getGrants().iterator();
            while (jt.hasNext())
                System.out.println("      >"+jt.next().toString()+"<");
        }
        System.out.println();
    }

}
