/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Text.java 2494 2006-04-15 21:15:08Z jmettraux $
 */

//
// Text.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.misc;

/**
 * Text formatting static methods 
 * (for some aspects, it has been obsoleted by Velocity usage)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: Text.java 2494 2006-04-15 21:15:08Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class Text
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Text.class.getName());
    */

    //
    // CONSTRUCTORS

    /**
     * (Making it private to prevent any further extensions)
     */
    private Text ()
    {
        super();
    }

    //
    // METHODS

    /**
     * Given a text and a map, will substitute occurence of "${nada}" with
     * the value held for "nada" in the map.
     */
    public static String substitute
        (final String text, final java.util.Map context)
    {
        //log.debug("---");
        //log.debug("text >"+text+"<");

        int j = text.indexOf("}");

        //log.debug("j = "+j);

        if (j < 0) return text;

        String t = text.substring(0, j);

        int i = t.lastIndexOf("${");
        int ii = t.lastIndexOf("\\${");

        //log.debug("i  = "+i);
        //log.debug("ii = "+ii);

        if (i < 0) 
            //
            // didn't find any '${'
            //
            return text;

        if (i != 0 && ii == i-1) 
            //
            // found '\${' 
            //
            return unescape(text);

        final String key = text.substring(i+2, j);

        //log.debug("key >"+key+"<");

        String value = (String)context.get(key);
        if (value == null) value = "";

        //log.debug("value >"+value+"<");

        return substitute
            (text.substring(0, i) + value + text.substring(j+1),
             context);
    }

    /**
     * Turns "\${vaca}" into "${vaca}" (removes the backslach preceding
     * the '${' opening.
     */
    public static String unescape (final String text)
    {
        return text.replaceAll("\\\\\\$\\{", "\\${");
    }

    /**
     * Ensures that a text has the given number of chars (columns).
     */
    public static String adjust 
        (String text, final int columns, final boolean leftAlign)
    {
        if (columns < 1) return text;

        if (text == null) text = "";

        final int l = text.length();

        if (l == columns) return text;

        if (l > columns)
        {
            if (leftAlign) return text.substring(0, columns);
            return text.substring(l - columns);
        }

        final int delta = columns - l;

        final StringBuffer sb = new StringBuffer(text);

        for (int i=0; i<delta; i++)
        {
            if (leftAlign) 
                sb.append(" ");
            else
                sb.insert(0, " ");
        }

        return sb.toString();
    }

    //
    // MAIN

    /*
    public static void main (final String[] args)
    {
        final java.util.Map context = new java.util.HashMap();

        context.put("nada", "toto");
        context.put("die", "da");
        context.put("java.home", "/usr/local/java");

        System.out.println(substitute(args[0], context));
    }
    */

}
