/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Wget.java 2461 2006-04-07 15:55:02Z jmettraux $
 */

//
// Wget.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.misc;

import java.net.URL;
import java.net.URLConnection;


/**
 * A java implementation of 'wget'.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: Wget.java 2461 2006-04-07 15:55:02Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class Wget
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Wget.class.getName());
    */

    //
    // CONSTANTS & co

    /**
     * How many bytes should get read at once ?
     */
    public final static int READ_BUFFER_SIZE = 2048;

    public final static String BANNER 
        = "OpenWFE Wget 0.0.2d - simple java wget";

    /**
     * After 7 unsuccessful reads on the wire, Wget will consider the download
     * as done.
     */
    public final static int MAX_RETRIES = 42;

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // STATIC METHODS

    /**
     * Same as wget(d, u), but verbosity is off.
     */
    public static void wget 
        (final String downloadDir, final String sUrl)
    throws Exception
    {
        wget(downloadDir, sUrl, false);
    }

    /**
     * This method is public so that applications may use it (as a library).
     */
    public static void wget 
        (final String downloadDir, final String sUrl, final boolean verbose)
    throws Exception
    {
        final URL url = new URL(sUrl);

        final URLConnection con = url.openConnection();

        int contentLength = con.getContentLength();

        if (verbose)
            System.out.println("..wget() contentLength is "+contentLength);

        if (contentLength < 0) contentLength = Integer.MAX_VALUE;

        int i = sUrl.lastIndexOf("/");
        String fileName = sUrl.substring(i+1);
        fileName = downloadDir + fileName;

        if (verbose)
            System.out.println("..wget() will save to "+fileName);

        final java.io.InputStream is = url.openStream();

        final java.io.FileOutputStream fos = 
            new java.io.FileOutputStream(fileName);

        byte[] buffer = new byte[READ_BUFFER_SIZE];

        int totalRead = 0;
        int retries = 0;

        while (true)
        {
            int read = is.read(buffer);

            totalRead += read;

            if (verbose)
            {
                System.out.println
                    ("..wget() read "+read+
                     " bytes   ("+totalRead+"/"+contentLength+") r"+retries);
            }

            if (read > 0)
            {
                fos.write(buffer, 0, read);
                fos.flush();

                retries = 0;
            }

            if (totalRead >= contentLength) break;

            if (read < READ_BUFFER_SIZE)
            {
                if (retries >= MAX_RETRIES)
                {
                    if (verbose)
                        System.out.println("..wget() giving up.");

                    break;
                }

                if (read < 1)
                {
                    //Thread.sleep(14);
                    Thread.yield();
                    retries++;
                }
            }
        }

        //fos.flush();
        fos.close();
        is.close();
    }

    private static void printUsage ()
    {
        final String cmd = "java "+Wget.class.getName();

        System.out.println();
        System.out.println(BANNER);
        System.out.println();
        System.out.println("USAGE :");
        System.out.println();
        System.out.print  (cmd);
        System.out.println(" [-d {downloadDir}] [-v] {URL}*");
        System.out.println();
        System.out.println("Wget is a java 'wget', with not much features.");
        System.out.println();
        System.out.println("  -v : verbose");
        System.out.println("  -h : prints this usage and exits");
        System.out.println();

        System.exit(-1);
    }

    public static void main (final String[] args)
        throws Exception
    {
        if (args.length < 1) printUsage();

        boolean verbose = false;

        int index = 0;

        String downloadDir = ".";

        while (args[index].startsWith("-"))
        {
            if (args[index].equals("-d"))
            {
                if (args.length - index < 2) printUsage();

                downloadDir = args[index+1];
                index += 2;

            }
            else if (args[index].equals("-v"))
            {
                verbose = true;
                index++;

                //System.out.println("...verbose");
            }
            else if (args[index].equals("-h"))
            {
                printUsage();
            }
        }

        if ( ! downloadDir.endsWith(java.io.File.separator))
            downloadDir += java.io.File.separator;

        //
        // do download

        for (int i=index; i<args.length; i++)
        {
            //System.out.println("args["+i+"] is >"+args[i]+"<");
            
            wget(downloadDir, args[i], verbose);
            System.out.println("...got "+args[i]);
        }
    }

}
